// utilities.cxx -- routines for file-reading and interpolation
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <iostream>
#include <fstream>
#include <string>
#include <stdlib.h>

#include "utilities.hxx"

using namespace std;

int read_array(string name, double array[][2])
 {
      int counter = 0;
      double data;          
      ifstream fin;    

      fin.open(name.c_str(),ios::in);    

      fin >> data;       
                               
      while (!fin.eof( ))     
      {

           //cout<<data<<endl;
	   array[counter][0] = data;
           fin >> data;  
	   array[counter][1] = data;
           fin >> data;  
	   counter++;            
      }
      fin.close( );  
      //list_array(array, counter);
      return counter;
 }

int read_array(string name, double array[][2], double normalization)
 {
      int counter = 0;
      double data;          
      ifstream fin;    

      fin.open(name.c_str(),ios::in);    

      fin >> data;       
                               
      while (!fin.eof( ))     
      {

           //cout<<data<<endl;
	   array[counter][0] = data;
           fin >> data;  
	   array[counter][1] = normalization * data;
           fin >> data;  
	   counter++;            
      }
      fin.close( );  
      //list_array(array, counter);
      return counter;
 }

void list_array(double array[][2], int n)
{

for (int i=0; i<n; i++)
	{
	cout << array[i][0] << " " << array[i][1] << endl;
	}
}

double interpolate(double value, double array[][2], int n)
{
int i;



double v_min = array[0][0];
double v_max = array[n-1][0];

//cout << n << endl;
//cout << array[0][0] << " " << array[1][0] << " " << array[2][0] << " " << array[3][0] << endl;

if ((value < v_min) || (value > v_max)) { return 0.0; }



for (i =0; i< n-1; i++)
	{
	if ((value >= array[i][0]) && (value < array[i+1][0])) {break;}
	}

return array[i][1] + (array[i+1][1] - array[i][1]) * (value - array[i][0]) / (array[i+1][0] - array[i][0]) ;

}

double interpolate(double value, double** array, int n)
{
int i;

double v_min = array[0][0];
double v_max = array[n-1][0];



if ((value < v_min) || (value > v_max)) { return 0.0; }


for (i =0; i< n-1; i++)
	{
	if ((value >= array[i][0]) && (value < array[i+1][0])) {break;}
	}

return array[i][1] + (array[i+1][1] - array[i][1]) * (value - array[i][0]) / (array[i+1][0] - array[i][0]) ;

}
