// terrain_relief.hxx -- routines to assign and compute terrain relief 
//
// Written by Thorsten Renk, started 2025
//
// Copyright (C) 2025  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#include "terrain_elements.hxx"

class TerrainRelief {

	int res_lat;
	int res_lon;

	int fe_search_x;
	int fe_search_y;

	int fe_search_lake_size;
	int fe_search_id;

	bool fe_search_final_flag;

	double base_scale;
	double evolution_time;
	double timestep;

	double impact_rate;
	double impact_mass_distribution;
	double impact_atmosphere_density;
	double impact_gravity;

	double fe_rainfall;
	double fe_rainfall_var;
	double fe_evaporation;
	double fe_hardness;

	double fe_search_barrier_level;
	double fe_search_inflow;
	

	TerrainElement** terrain_elements;

	double rnd(double, double);
	double pseudo_rnd(double, double);
	double clamp_01(double);
	double smoothstep(double, double, double);
	double perlin_noise(double, double, double, double);

	void create_surface();
	void create_meteor_impact();
	void meteor_impact(int, int, double, double, double);

	void create_rainfall();
	void trace_flow();
	void erode();
	void flood();
	void flood_from(int, int);
	void flood_fill(int, int, double);
	void reset_lakes();
	void clean_up_lakes();
	void reset_fill_parameters();
	
	bool flood_check_barrier(int, int, double);

	std::string plotfile;

	bool do_impacts;
	bool do_flow_erosion;
	bool do_tectonics;


	public:

	


	void set_random_seed(int);
	void set_general_parameters(int, int, double, double, double, std::string);
	void set_impact_parameters(double, double, double, double);
	void set_flow_erosion_parameters(double, double, double, double);

	void evolve();

	//plots
	void plot_surface_data_gnu(int, std::string);
};
