// terrain_elements.hxx -- routines to assign and compute terrain relief surface elements
//
// Written by Thorsten Renk, started 2025
//
// Copyright (C) 2025  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


class TerrainElement {

	double elevation;
	double rainfall;
	double flow;
	double water_level;
	double gradient;
	double barrier_height;
	double outflow;
	double inflow;

	int grad_x;
	int grad_y;

	int fill_id;

	bool is_sink;
	bool is_lake;
	bool is_minimum;

	public:

	
	//constructor
	TerrainElement ();

	void set_elevation(double);
	void set_rainfall(double);

	void reset_flow();
	void add_to_flow(double);
	void add_to_inflow(double);
	void add_to_water_level(double);
	void set_water_to_level(double);

	void set_sink();
	void set_lake();
	void unset_lake();
	void set_minimum();
	void unset_minimum();

	void set_flow_dir(int, int);
	void set_fill_id(int);
	void set_gradient(double);
	void set_barrier(double);
	void set_water_level(double);
	void set_inflow(double);
	void set_outflow(double);

	//property access
	double get_elevation();
	double get_water_elevation();
	double get_water_level();
	double get_rainfall();
	double get_flow();
	double get_gradient();
	double get_barrier();
	double get_outflow();
	double get_inflow();

	int get_grad_x();
	int get_grad_y();
	int get_fill_id();

	bool get_terminating();
	bool get_sink();
	bool get_lake();
	bool get_minimum();
	bool check_fill_id(int);

};
