// star.hxx -- routines to assign and compute stellar properties
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

class Star {
	  double mass_solar;
	  double mass;
	  double luminosity_solar;
	  double luminosity;
	  double temperature;
	  double radius;
	  double density;
	  double x;
	  double y;
	  double z;
	  double ir_fraction;
	  double vis_fraction;
 	  double uv_fraction;
	  double compute_luminosity(double);
	  void compute_spectral_fractions();
	  std::string designation;
	  bool designation_set;


	public:
	  Star (double, double);
	  Star ();
	  void assign_properties(double, double);
	  void assign_properties(double, double, double, double);
	  void set_xyz (double, double, double);
	  double spectrum (double);
	  double get_mass(void) {return mass;}
	  double get_radius(void) {return radius;}
	  std::string get_designation (void) {return designation;} 
	  double get_luminosity (void) {return luminosity;}
	  double get_ir_fraction (void) {return ir_fraction;}
	  double get_vis_fraction (void) {return vis_fraction;}
	  double get_uv_fraction (void) {return uv_fraction;}
	  void list_properties (void);
	  void assign_name (std::string set_name) {designation = set_name; designation_set = true;}
};
