// parser.hxx -- parser for config files
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


void materials_parser (string );

void file_parser (string config_file)
{
string element, star_type, mode, block, key;

double value;

int key_flag = 0; // initially expect a keyword
int body_flag = 0; // initially input for a planet
int i_body = -1; // the current index for an additional gravitating body

mode = "void";
block = "void";
key = "void";

options_list.orbital_sim_timestep = 1000.0;
options_list.star_mass = 0.0;
options_list.star_temperature = 0.0;
options_list.star_luminosity = 0.0;
options_list.star_radius = 0.0;
options_list.star_defined = false;
options_list.companion_defined = false;
options_list.companion_mass = 0.0;
options_list.companion_temperature = 0.0;
options_list.companion_luminosity = 0.0;
options_list.companion_radius = 0.0;
options_list.companion_apsis_angle = 0.0;
options_list.companion_retrograde = false;
options_list.binary_defined = false;
options_list.binary_mass = 0.0;
options_list.binary_temperature = 0.0;
options_list.binary_luminosity = 0.0;
options_list.binary_radius = 0.0;
options_list.binary_apsis_angle = 0.0;
options_list.binary_retrograde = false;
options_list.moon_apsis_angle = 0.0;
options_list.moon_retrograde = false;
options_list.moon_lagrange_orbit = false;
options_list.moon_lagrange_leading = false;
options_list.planet_defined = false;
options_list.planet_atmosphere_defined = false;
options_list.planet_orbit_binary_defined = false;
options_list.planet_orbit_longyear_defined = false;
options_list.planet_lagrange_orbit = false;
options_list.planet_lagrange_leading = false;
options_list.plot_defined = false;
options_list.plot_int_range_set = false;
options_list.plot_orbit_defined = false;
options_list.plot_orbit_relative = false;
options_list.plot_orbit_3d = true;
options_list.plot_surface_defined = false;
options_list.planet_orbit_longyear_defined = false;
options_list.moon_defined = false;
options_list.moon_thermal_defined = false;
options_list.moon_atmosphere_defined = false;
options_list.orbit_evolve = false;
options_list.full_evolve = false;
options_list.star_name_set = false;
options_list.companion_name_set = false;
options_list.planet_name_set = false;
options_list.planet_thermal_defined = false;
options_list.thermal_evolve = false;
options_list.atmosphere_defined = false;
options_list.weather_defined = false;
options_list.use_gr_corrections = true;
options_list.use_apoapsis_init = false;
options_list.use_eclipse_finder = false;
options_list.use_eclipse_verbose = true;
options_list.use_collision_finder = false;
options_list.use_indirect_irradiation = true;
options_list.record_defined = false;
options_list.record_global = false;
options_list.record_filename_defined = false;
options_list.scatter_plot_defined = false;
options_list.scatter_filename_defined = false;
options_list.scatter_filters_defined = false;
options_list.orbit_resume_flag = false;
options_list.orbit_save_flag = false;
options_list.forest_fires = false;
options_list.roche_check = false;
options_list.hill_sphere_check = false;
options_list.atmosphere_phase_check = false;
options_list.tidal_locking_check = false;
options_list.consistency_checks = false;
options_list.weather_storms = false;
options_list.bodies_defined = false;
options_list.report_orbit_defined = false;
options_list.moon_geology_defined = false;
options_list.planet_geology_defined = false;
options_list.depth_profile_defined = false;
options_list.geology_differentiated = true;
options_list.relief_defined = false;
options_list.par_1 = 0.0;
options_list.par_2 = 0.0;
options_list.planet_inc_of_companion = 0.0;
options_list.planet_inc_of_binary = 0.0;
options_list.planet_lan_of_companion = 0.0;
options_list.planet_lan_of_binary = 0.0;
options_list.z_min_surface = 0.0;
options_list.z_max_surface = 0.0;
options_list.atmosphere_transport_coeff = 0.0;
options_list.atmosphere_albedo = 0.0;
options_list.hydrosphere_transport_coeff = 0.0;
options_list.hydrosphere_ice_factor = 1.0;
options_list.atmosphere_IR_blocking = 0.0;
options_list.moon_inc_of_planet = 0.0;
options_list.moon_lan_of_planet = 0.0;
options_list.moon_atmosphere_transport_coeff = 0.0;
options_list.moon_hydrosphere_transport_coeff = 0.0;
options_list.moon_hydrosphere_ice_factor = 1.0;
options_list.moon_atmosphere_IR_blocking = 0.0;
options_list.moon_atmosphere_albedo = 0.0;
options_list.planet_semimajor_longyear = 0.0;
options_list.o2_fraction = 0.0;
options_list.n2_fraction = 0.0;
options_list.cl2_fraction = 0.0;
options_list.co2_fraction = 0.0;
options_list.he_fraction = 0.0;
options_list.ne_fraction = 0.0;
options_list.ar_fraction = 0.0;
options_list.h2o_fraction = 0.0;
options_list.o3_fraction = 0.0;
options_list.so2_fraction = 0.0;
options_list.ch4_fraction = 0.0;
options_list.h2s_fraction = 0.0;
options_list.nh3_fraction = 0.0;
options_list.co_fraction = 0.0;
options_list.full_evolve_timestep = 1000.0;
options_list.planet_max_diurnal_depth = 0.0;
options_list.planet_T_init = 0.0;
options_list.full_evolve_time_op = 0.0;
options_list.orbit_evolve_time_op = 0.0;
options_list.plot_orbit_body_index = 1;
options_list.plot_surface_body_index = 1;
options_list.plot_body_index = 0;
options_list.plot_star_index = 0;
options_list.plot_int_range_min = -1.1;
options_list.plot_int_range_max = -1.1;
options_list.plot_x_range_factor = 1.0;
options_list.record_num_columns = 0;
options_list.record_delay_op = 0.0;
options_list.record_x_format_factor = 1.0;
options_list.record_body_index = 0;
options_list.scatter_type = 0;
options_list.scatter_delay = 0.0;
options_list.scatter_delay_op = 0.0;
options_list.scatter_interval = 1000.0;
options_list.random_seed = -1;
options_list.weather_random_seed = -1;
options_list.circulation_model_preset = -1;
options_list.weather_mid_cloudlevel_min = 0.0;
options_list.weather_mid_cloudlevel_max = 0.0;
options_list.weather_precipitation_factor = 1.0;
options_list.weather_ridge_migration_factor = 0.5;
options_list.weather_ridge_suppression_factor = 0.1;
options_list.weather_snow_albedo = 0.8;
options_list.weather_precipitation_threshold_convection = -1.0;
options_list.weather_precipitation_factor_convection = -1.0;
options_list.weather_cloud_factor_convection = -1.0;
options_list.weather_storm_grad_motion_factor = 1.0;
options_list.geology_system_age = 4.5;
options_list.geology_inner_mantle_material = "";
options_list.geology_outer_mantle_material = "";
options_list.geology_core_material = "";
options_list.geology_isotope_abundancy = 1.0;
options_list.geology_core_density = -1.0;
options_list.geology_inner_mantle_density = -1.0;
options_list.geology_outer_mantle_density = -1.0;
options_list.geology_core_radius = 0.0;
options_list.geology_num_components = 0;
options_list.geology_tidal_dissipation_factor = 1.0;
options_list.geology_surface_temperature = -1.0;
options_list.depth_profile_resolution = 10000.0;
options_list.forest_fire_clouds = 0.0;
options_list.forest_fire_T_min = 0.0;
options_list.forest_fire_T_max = 0.0;
options_list.forest_fire_strato_transfer = 0.0;
options_list.cloud_to_T_feedback = 0.0;
options_list.high_cloud_to_T_feedback = 0.0;
options_list.mid_cloud_to_T_feedback = 0.0;
options_list.precipitation_to_T_feedback = 1.0;
options_list.plot_exclusive_component = "";
options_list.num_bodies = 0;
options_list.report_orbit_num_var = 0;
options_list.report_orbit_num_src = 0;
options_list.report_orbit_reference = "";
options_list.relief_filename = "terrain_relief.dat";
options_list.relief_initial_heightfield_filename = "";
options_list.relief_num_lat = 1000;
options_list.relief_num_lon = 1000;
options_list.relief_base_scale = 1.0;
options_list.relief_annual_rainfall = 0.0;
options_list.relief_rainfall_var = 0.0;
options_list.relief_impact_rate = 0.0;
options_list.relief_impact_mass_distribution = 0.5;
options_list.relief_annual_rainfall = 0.0;
options_list.relief_rainfall_var = 0.0;
options_list.relief_evaporation = 0.0;
options_list.relief_bedrock_hardness = 1.0;
options_list.plot_body = "";
options_list.planet_L_dphi = 0.0;;
options_list.planet_L_dR = 0.0;
options_list.planet_L_dz = 0.0;
options_list.planet_L_dvR = 0.0;
options_list.planet_L_dvT = 0.0;
options_list.planet_L_dvz = 0.0;
options_list.moon_L_dphi = 0.0;;
options_list.moon_L_dR = 0.0;
options_list.moon_L_dz = 0.0;
options_list.moon_L_dvR = 0.0;
options_list.moon_L_dvT = 0.0;
options_list.moon_L_dvz = 0.0;

for (int i=0; i< 10; i++)
	{
	options_list.body_name[i] = "";
	options_list.body_attach_to[i] = "";
	options_list.body_mass[i] = 0.0;
	options_list.body_semimajor[i] = 0.0;
	options_list.body_eccentricity[i] = 0.0;
	options_list.body_apsis_angle[i] = 0.0;
	options_list.body_apsis_angle_min[i] = 0.0;
	options_list.body_apsis_angle_max[i] = 0.0;
	options_list.body_inclination[i] = 0.0;
	options_list.body_lan[i] = 0.0;
	options_list.body_radius[i] = 0.0;
	options_list.body_distance[i] = 0.0;
	}

  ifstream cfgfile (config_file.c_str());
  if (cfgfile.is_open())
  {
    while (element !="end")
    {
      cfgfile >> element;
      //cout << element << " " << key_flag << '\n';

      	if (key_flag == 1)
		{
		value = atof (element.c_str());
		}

   	if (key_flag == 0)
		{
		//cout << "parsing key: " << element << endl;
		if (element == "input") {mode = "input"; block = "void";}
		else if (element == "config") {mode = "config"; block = "void";}
		else if (element == "plot") {mode = "plot"; block = "void";}
		else if (element == "orbit") {mode = "orbit"; block = "void";}
		else if (element == "thermal") {mode = "thermal"; block = "void";}
		else if (element == "evolution") {mode = "evolution"; block = "void";}
		else if (element == "atmosphere_basic") {mode = "atmosphere_basic"; block = "void";}
		else if (element == "feedback_loops") {mode = "feedback_loops"; block = "void";}
		else if (element == "hydrosphere_basic") {mode = "hydrosphere_basic"; block = "void";}
		else if (element == "weather") {mode = "weather"; block = "void";}
		else if (element == "terrain_relief") {mode = "terrain_relief"; block = "void"; options_list.relief_defined = true;}
		else if (element == "checks") {mode = "checks"; block = "void";}
		else if (element == "atmosphere") {mode = "atmosphere"; block = "void";}
		else if (element == "geology") {mode = "geology"; block = "void";}
		else if (element == "plot_orbit") {mode = "plot_orbit"; block = "void"; options_list.plot_orbit_defined = true;}
		else if (element == "plot_surface") {mode = "plot_surface"; block = "void"; }
		else if (element == "record") {mode = "record"; block = "void"; }
		else if (element == "record_global") {mode = "record"; options_list.record_global = true; block = "void"; }
		else if (element == "scatter_plot") {mode = "scatter_plot"; block = "void"; }
		else if (element == "orbit_summary") {mode = "orbit_summary";}
		else if (element == "end") {mode = "end";}
		else if (element == "star") {block = "star";}
		else if (element == "companion") {block = "companion";}
		else if (element == "binary") {block = "binary";}
		else if (element == "planet") {block = "planet";}
		else if (element == "orbiting_body") {block = "body"; i_body++; options_list.num_bodies = i_body+1;}
		else if (element == "moon") {block = "moon"; body_flag = 1;}
		else if (element == "var_x") {key = element; key_flag = 2;}
		else if (element == "var_y") {key = element; key_flag = 2;}
		else if (element == "var_z") {key = element; key_flag = 2;}
		else if (element == "variable") {key = element; key_flag = 2;}				
		else if (element == "file") {key = element; key_flag = 2;}
		else if (element == "name") {key = element; key_flag = 2;}
		else if (element == "attach_to") {key = element; key_flag = 2;}
		else if (element == "materials") {key = element; key_flag = 2;}
		else if (element == "gr_corrections") {key = element; key_flag = 2;}
		else if (element == "eclipse_finder") {key = element; key_flag = 2;}
		else if (element == "collision_finder") {key = element; key_flag = 2;}
		else if (element == "indirect_irradiation") {key = element; key_flag = 2;}
		else if (element == "eclipse_verbose") {key = element; key_flag = 2;}
		else if (element == "retrograde") {key = element; key_flag = 2;}
		else if (element == "body") {key = element; key_flag = 2;}
		else if (element == "reference") {key = element; key_flag = 2;}
		else if (element == "apoapsis_init") {key = element; key_flag = 2;}
		else if (element == "materials_file") {key = element; key_flag = 2;}
		else if (element == "resume_from") {key = element; key_flag = 2;}
		else if (element == "save_to") {key = element; key_flag = 2;}
		else if (element == "relative_to") {key = element; key_flag = 2;}
		else if (element == "exclusive_component") {key = element; key_flag = 2;}
		else if (element == "radiation_from") {key = element; key_flag = 2;}
		else if (element == "roche_limit") {key = element; key_flag = 2;}
		else if (element == "orbital_stability") {key = element; key_flag = 2;}
		else if (element == "atmosphere_phase") {key = element; key_flag = 2;}
		else if (element == "tidal_locking") {key = element; key_flag = 2;}
		else if (element == "storms") {key = element; key_flag = 2;}
		else if (element == "type") {key = element; key_flag = 2;}
		else if (element == "mantle_material") {key = element; key_flag = 2;}
		else if (element == "core_material") {key = element; key_flag = 2;}
		else if (element == "outer_mantle_material") {key = element; key_flag = 2;}
		else if (element == "material") {key = element; key_flag = 2;}
		else if (element == "component") {key = element; key_flag = 2;}
		else if (element == "depth_profile") {key = element; key_flag = 2;}
		else if (element == "lagrange_point") {key = element; key_flag = 2;}
		else {key = element; key_flag = 1;}
		}

    	else if (key_flag == 1)
		{
		//cout << "parsing value: " << value << endl;
		if (block == "star")
			{
			if (key == "mass") {options_list.star_mass = value;}
			else if (key == "T_surf") {options_list.star_temperature = value;}
			else if (key == "radius") {options_list.star_radius = value;}
			else if (key == "luminosity") {options_list.star_luminosity = value;}
			else {cout << "Key " << key << " not recognized in the context 'star', exiting..." << endl; exit(0);}
			}
		else if (block == "companion")
			{
			if (key == "mass") {options_list.companion_mass = value;}
			else if (key == "T_surf") {options_list.companion_temperature = value;}
			else if (key == "radius") {options_list.companion_radius = value;}
			else if (key == "luminosity") {options_list.companion_luminosity = value;}
			else if (key == "apsis_angle") {options_list.companion_apsis_angle = value * deg_to_rad;}
			else {cout << "Key " << key << " not recognized in the context 'companion', exiting..." << endl; exit(0);}
			}
		else if (block == "binary")
			{
			if (key == "mass") {options_list.binary_mass = value;}
			else if (key == "T_surf") {options_list.binary_temperature = value;}
			else if (key == "radius") {options_list.binary_radius = value;}
			else if (key == "luminosity") {options_list.binary_luminosity = value;}
			else if (key == "apsis_angle") {options_list.binary_apsis_angle = value * deg_to_rad;}
			else {cout << "Key " << key << " not recognized in the context 'binary', exiting..." << endl; exit(0);}
			}
		else if (block == "planet")
			{
			if (key == "mass") {options_list.planet_mass = value;}
			else if (key == "radius") {options_list.planet_radius = value;}
			else if (key == "inclination") {options_list.planet_inc = value * deg_to_rad;}
			else if (key == "axis_tilt") {options_list.planet_inc = value * deg_to_rad;}
			else if (key == "dec_offset") {options_list.planet_dec_offset = value * deg_to_rad;}
			else if (key == "semimajor_au") {options_list.planet_semimajor = value * AU;}
			else if (key == "semimajor_km") {options_list.planet_semimajor = value * 1.0e3;}
			else if (key == "semimajor_Mkm") {options_list.planet_semimajor = value * 1.0e9;}
			else if (key == "eccentricity") {options_list.planet_eccentricity = value;}
			else if (key == "semimajor_longyear_au") {options_list.planet_semimajor_longyear = value * AU;}
			else if (key == "eccentricity_longyear") {options_list.planet_eccentricity_longyear = value;}
			else if (key == "inclination_longyear") {options_list.planet_inc_of_companion = value * deg_to_rad; options_list.plot_orbit_3d = true;}
			else if (key == "lon_asc_node_longyear") {options_list.planet_lan_of_companion = value * deg_to_rad; }
			else if (key == "lan_longyear") {options_list.planet_lan_of_companion = value * deg_to_rad; }
			else if (key == "semimajor_binary_au") {options_list.planet_semimajor_binary = value * AU;}
			else if (key == "eccentricity_binary") {options_list.planet_eccentricity_binary = value;}
			else if (key == "inclination_binary") {options_list.planet_inc_of_binary = value * deg_to_rad; options_list.plot_orbit_3d = true;}
			else if (key == "lon_asc_node_binary") {options_list.planet_lan_of_binary = value * deg_to_rad; }
			else if (key == "lan_binary") {options_list.planet_lan_of_binary = value * deg_to_rad; }
			else if (key == "rot_period_h") {options_list.planet_rot_period = value * 3600.0;}
			else if (key == "rot_period_d") {options_list.planet_rot_period = value * 86400.0;}
			else if (key == "rot_period") {options_list.planet_rot_period = value;}
			else if (key == "sid_rot_period_h") {options_list.planet_sid_rot_period = value * 3600.0;}
			else if (key == "sid_rot_period_d") {options_list.planet_sid_rot_period = value * 86400.0;}
			else if (key == "sid_rot_period") {options_list.planet_sid_rot_period = value;}
			else if (key == "mean_albedo") {options_list.planet_mean_albedo = value;}
			else if (key == "mean_heat_capacity") {options_list.planet_mean_heat_capacity = value;}
			else if (key == "mean_depth") {options_list.planet_mean_diurnal_depth = value;}
			else if (key == "max_depth") {options_list.planet_max_diurnal_depth = value;}
			else if (key == "internal_heat") {options_list.planet_internal_heat = value;}
			else if (key == "elements_lat") {options_list.surface_nlat = (int) value;}
			else if (key == "elements_lon") {options_list.surface_nlon = (int) value;}
			else if (key == "T_init") {options_list.planet_T_init = value;}
			else if (key == "lagrange_delta_phi") {options_list.planet_L_dphi = value * deg_to_rad;}
			else if (key == "lagrange_delta_R") {options_list.planet_L_dR = value;}
			else if (key == "lagrange_delta_R_km") {options_list.planet_L_dR = value * 1.0e3;}
			else if (key == "lagrange_delta_R_Mkm") {options_list.planet_L_dR = value * 1.0e9;}
			else if (key == "lagrange_delta_R_au") {options_list.planet_L_dR = value * AU;}
			else if (key == "lagrange_delta_z") {options_list.planet_L_dz = value;}
			else if (key == "lagrange_delta_z_km") {options_list.planet_L_dz = value * 1.0e3;}
			else if (key == "lagrange_delta_z_Mkm") {options_list.planet_L_dz = value * 1.0e9;}
			else if (key == "lagrange_delta_z_aau") {options_list.planet_L_dz = value * AU;}
			else {cout << "Key " << key << " not recognized in the context 'planet', exiting..." << endl; exit(0);}
			}
		else if (block == "moon")
			{
			if (key == "mass") {options_list.moon_mass = value;}
			else if (key == "radius") {options_list.moon_radius = value;}
			else if (key == "inclination") {options_list.moon_inc = value * deg_to_rad;}
			else if (key == "axis_tilt") {options_list.moon_inc = value * deg_to_rad;}
			else if (key == "dec_offset") {options_list.moon_dec_offset = value * deg_to_rad;}
			else if (key == "semimajor_au") {options_list.moon_semimajor = value * AU;}
			else if (key == "semimajor_km") {options_list.moon_semimajor = value * 1.0e3;}
			else if (key == "semimajor_Mkm") {options_list.moon_semimajor = value * 1.0e9;}
			else if (key == "eccentricity") {options_list.moon_eccentricity = value;}
			else if (key == "inclination_planet") {options_list.moon_inc_of_planet = value * deg_to_rad; options_list.plot_orbit_3d = true;}
			else if (key == "inclination_to_planet") {options_list.moon_inc_of_planet = value * deg_to_rad; options_list.plot_orbit_3d = true;}
			else if (key == "inc_to_planet") {options_list.moon_inc_of_planet = value * deg_to_rad; options_list.plot_orbit_3d = true;}
			else if (key == "lon_asc_node_planet") {options_list.moon_lan_of_planet = value * deg_to_rad; }
			else if (key == "lan_planet") {options_list.moon_lan_of_planet = value * deg_to_rad; }
			else if (key == "rot_period_h") {options_list.moon_rot_period = value * 3600.0;}
			else if (key == "rot_period_d") {options_list.moon_rot_period = value * 86400.0;}
			else if (key == "rot_period") {options_list.moon_rot_period = value;}
			else if (key == "sid_rot_period_h") {options_list.moon_sid_rot_period = value * 3600.0;}
			else if (key == "sid_rot_period_d") {options_list.moon_sid_rot_period = value * 86400.0;}
			else if (key == "sid_rot_period") {options_list.moon_sid_rot_period = value;}
			else if (key == "mean_albedo") {options_list.moon_mean_albedo = value;}
			else if (key == "mean_heat_capacity") {options_list.moon_mean_heat_capacity = value;}
			else if (key == "mean_depth") {options_list.moon_mean_diurnal_depth = value;}
			else if (key == "max_depth") {options_list.moon_max_diurnal_depth = value;}
			else if (key == "internal_heat") {options_list.moon_internal_heat = value;}
			else if (key == "elements_lat") {options_list.moon_surface_nlat = (int) value;}
			else if (key == "elements_lon") {options_list.moon_surface_nlon = (int) value;}
			else if (key == "T_init") {options_list.moon_T_init = value;}
			else if (key == "apsis_angle") {options_list.moon_apsis_angle = value * deg_to_rad;}
			else if (key == "lagrange_delta_phi") {options_list.moon_L_dphi = value * deg_to_rad;}
			else if (key == "lagrange_delta_R") {options_list.moon_L_dR = value;}
			else if (key == "lagrange_delta_R_km") {options_list.moon_L_dR = value * 1.0e3;}
			else if (key == "lagrange_delta_R_Mkm") {options_list.moon_L_dR = value * 1.0e9;}
			else if (key == "lagrange_delta_R_au") {options_list.moon_L_dR = value * AU;}
			else if (key == "lagrange_delta_z") {options_list.moon_L_dz = value;}
			else if (key == "lagrange_delta_z_km") {options_list.moon_L_dz = value * 1.0e3;}
			else if (key == "lagrange_delta_z_Mkm") {options_list.moon_L_dz = value * 1.0e9;}
			else if (key == "lagrange_delta_z_aau") {options_list.moon_L_dz = value * AU;}
			else {cout << "Key " << key << " not recognized in the context 'moon', exiting..." << endl; exit(0);}
			}
		else if (block == "body")
			{
			if (key == "mass") {options_list.body_mass[i_body] = value;}
			else if (key == "radius") {options_list.body_radius[i_body] = value;}
			else if (key == "inclination") {options_list.body_inclination[i_body] = value * deg_to_rad;}
			else if (key == "semimajor_au") {options_list.body_semimajor[i_body] = value * AU;}
			else if (key == "semimajor_min_au") {options_list.body_semimajor_min[i_body] = value * AU;}
			else if (key == "semimajor_max_au") {options_list.body_semimajor_max[i_body] = value * AU;}
			else if (key == "semimajor_km") {options_list.body_semimajor[i_body] = value * 1.0e3;}
			else if (key == "semimajor_min_km") {options_list.body_semimajor_min[i_body] = value * 1.0e3;}
			else if (key == "semimajor_max_km") {options_list.body_semimajor_max[i_body] = value * 1.0e3;}
			else if (key == "semimajor_Mkm") {options_list.body_semimajor[i_body] = value * 1.0e9;}
			else if (key == "semimajor_min_Mkm") {options_list.body_semimajor_min[i_body] = value * 1.0e9;}
			else if (key == "semimajor_max_Mkm") {options_list.body_semimajor_max[i_body] = value * 1.0e9;}
			else if (key == "eccentricity") {options_list.body_eccentricity[i_body] = value;}
			else if (key == "eccentricity_min") {options_list.body_eccentricity_min[i_body] = value;}
			else if (key == "eccentricity_max") {options_list.body_eccentricity_max[i_body] = value;}
			else if (key == "lan") {options_list.body_lan[i_body] = value;}
			else if (key == "lon_asco_node") {options_list.body_lan[i_body] = value;}
			else if (key == "apsis_angle") {options_list.body_apsis_angle[i_body] = value * deg_to_rad;}
			else if (key == "apsis_angle_min") {options_list.body_apsis_angle_min[i_body] = value * deg_to_rad;}
			else if (key == "apsis_angle_max") {options_list.body_apsis_angle_max[i_body] = value * deg_to_rad;}
			else if (key == "distance_au") {options_list.body_distance[i_body] = value * AU;}
			else if (key == "distance_km") {options_list.body_distance[i_body] = value * 1.0e3;}
			else if (key == "distance_Mkm") {options_list.body_distance[i_body] = value * 1.0e9;}
			else {cout << "Key " << key << " not recognized in the context 'body', exiting..." << endl; exit(0);}
			}
		else if (mode == "plot")
			{
			if (key == "xmin") {options_list.x_min = value;}
			else if (key == "xmax") {options_list.x_max = value;}
			else if (key == "int_range_min") {options_list.plot_int_range_min = value;}
			else if (key == "int_range_max") {options_list.plot_int_range_max = value;}
			else if (key == "lat") {options_list.par_1 = value;}
			else if (key == "lon") {options_list.par_2 = value;}
			else if (key == "alt_level") {options_list.par_1 = value;}
			else if (key == "npoints") {options_list.n_points = (int) value;}
			else {cout << "Key " << key << " not recognized in the context 'plot', exiting..." << endl; exit(0);}
			}
		else if (mode == "plot_orbit")
			{
			if (key == "npoints") {options_list.n_points_orbit = (int) value;}
			else if (key == "timeframe") {options_list.plot_orbit_timeframe = value;}
			else if (key == "timeframe_d") {options_list.plot_orbit_timeframe = value * 86400.0;}
			else if (key == "timeframe_a") {options_list.plot_orbit_timeframe = value * 31636000.0;}
			else {cout << "Key " << key << " not recognized in the context 'plot_orbit', exiting..." << endl; exit(0);}
			}
		else if (mode == "plot_surface")
			{
			if (key == "z_min") {options_list.z_min_surface = value;}
			else if (key == "z_max") {options_list.z_max_surface = value;}
			else {cout << "Key " << key << " not recognized in the context 'plot_suface', exiting..." << endl; exit(0);}
			}
		else if (mode == "record")
			{
			if (key == "delay") {options_list.record_delay = value;}
			else if (key == "delay_d") {options_list.record_delay = value * 86400.0;}
			else if (key == "delay_a") {options_list.record_delay = value * 31636000.0;}
			else if (key == "delay_op") {options_list.record_delay_op = value;}
			else if (key == "npoints") {options_list.record_n_points = (int) value;}
			else if (key == "index_x") {options_list.record_index_y = (int) value;}
			else if (key == "index_y") {options_list.record_index_x = (int) value;}
			else if (key == "index_lat") {options_list.record_index_x = (int) value;}
			else if (key == "index_lon") {options_list.record_index_y = (int) value;}
			else {cout << "Key " << key << " not recognized in the context 'record', exiting..." << endl; exit(0);}
			}
		else if (mode == "scatter_plot")
			{
			if (key == "delay") {options_list.scatter_delay = value;}
			else if (key == "delay_d") {options_list.scatter_delay = value * 86400.0;}
			else if (key == "delay_a") {options_list.scatter_delay = value * 31636000.0;}
			else if (key == "delay_op") {options_list.scatter_delay_op = value;}
			else if (key == "interval") {options_list.scatter_interval = value;}
			else if (key == "interval_d") {options_list.scatter_interval = value * 86400.0;}
			else if (key == "interval_a") {options_list.scatter_interval = value * 31636000.0;}
			else if (key == "filter_low") {options_list.scatter_filter_low = value; options_list.scatter_filters_defined = true;}
			else if (key == "filter_high") {options_list.scatter_filter_high = value; options_list.scatter_filters_defined = true;}
			else {cout << "Key " << key << " not recognized in the context 'scatter_plot', exiting..." << endl; exit(0);}
			}
		else if (mode == "orbit")
			{
			if (key == "evolve_a") {options_list.orbit_evolve_time = value * 31536000.0; options_list.orbit_evolve = true;}
			else if (key == "evolve_d") {options_list.orbit_evolve_time = value * 86400.0; options_list.orbit_evolve = true;}
			else if (key == "evolve_op") {options_list.orbit_evolve_time_op = value;}
			else if (key == "evolve") {options_list.orbit_evolve_time = value; options_list.orbit_evolve = true;}
			else if (key == "day_fraction") {options_list.orbit_day_fraction = value; }
			else if (key == "daytime") {options_list.orbit_day_fraction = value/options_list.planet_rot_period; }
			else if (key == "timestep") {options_list.orbit_evolve_timestep = value; }
			else {cout << "Key " << key << " not recognized in the context 'orbit', exiting..." << endl; exit(0);}
			}
		else if (mode == "thermal")
			{
			if (key == "evolve_a") {options_list.thermal_evolve_time = value * 31536000.0; options_list.thermal_evolve = true;}
			else if (key == "evolve_d") {options_list.thermal_evolve_time = value * 86400; options_list.thermal_evolve = true;}
			else if (key == "evolve") {options_list.thermal_evolve_time = value; options_list.thermal_evolve = true;}
			else {cout << "Key " << key << " not recognized in the context 'thermal', exiting..." << endl; exit(0);}
			}
		else if (mode == "evolution")
			{
			if (key == "evolve_a") {options_list.full_evolve_time = value * 31536000.0; options_list.full_evolve = true;}
			else if (key == "evolve_d") {options_list.full_evolve_time = value * 86400.0; options_list.full_evolve = true;}
			else if (key == "evolve") {options_list.full_evolve_time = value; options_list.full_evolve = true;}
			else if (key == "evolve_op") {options_list.full_evolve_time_op = value; }
			else if (key == "timestep") {options_list.full_evolve_timestep = value; }
			else {cout << "Key " << key << " not recognized in the context 'evolution', exiting..." << endl; exit(0);}
			}
		else if (mode == "config")
			{
			if (key == "orbital_sim_timestep") {options_list.orbital_sim_timestep = value;}
			else if (key == "random_seed") {options_list.random_seed = static_cast<int>(value);}
			else {cout << "Key " << key << " not recognized in the context 'config', exiting..." << endl; exit(0);}
			}
		else if (mode == "atmosphere_basic")
			{
			if (body_flag == 0)
				{
				if (key == "infrared_blocking") {options_list.atmosphere_IR_blocking = value;}
				else if (key == "transport_coeff") {options_list.atmosphere_transport_coeff = value;}
				else if (key == "atmosphere_albedo") {options_list.atmosphere_albedo = value;}
				else {cout << "Key " << key << " not recognized in the context 'atmosphere_basic', exiting..." << endl; exit(0);}
				}
			else if (body_flag == 1)
				{
				if (key == "infrared_blocking") {options_list.moon_atmosphere_IR_blocking = value;}
				else if (key == "transport_coeff") {options_list.moon_atmosphere_transport_coeff = value;}
				else if (key == "atmosphere_albedo") {options_list.moon_atmosphere_albedo = value;}
				else {cout << "Key " << key << " not recognized in the context 'atmosphere_basic', exiting..." << endl; exit(0);}
				}
			}
		else if (mode == "hydrosphere_basic")
			{
			if (body_flag == 0)
				{
				if (key == "transport_coeff") {options_list.hydrosphere_transport_coeff = value;}
				else if (key == "ice_buildup_factor") {options_list.hydrosphere_ice_factor = value;}
				else {cout << "Key " << key << " not recognized in the context 'hydrosphere_basic', exiting..." << endl; exit(0);}
				}
			else if (body_flag == 1)
				{
				if (key == "transport_coeff") {options_list.moon_hydrosphere_transport_coeff = value;}
				else if (key == "ice_buildup_factor") {options_list.moon_hydrosphere_ice_factor = value;}
				else {cout << "Key " << key << " not recognized in the context 'hydrosphere_basic', exiting..." << endl; exit(0);}
				}
			}
		else if (mode == "feedback_loops")
			{
			if (key == "fire_cloud_factor") {options_list.forest_fire_clouds = value;}
			else if (key == "fire_min_T") {options_list.forest_fire_T_min = value;}
			else if (key == "fire_max_T") {options_list.forest_fire_T_max = value;}
			else if (key == "smoke_stratosphere_transfer") {options_list.forest_fire_strato_transfer = value;}
			else if (key == "cloud_T_feedback") {options_list.cloud_to_T_feedback = value;}
			else if (key == "mid_cloud_T_feedback") {options_list.mid_cloud_to_T_feedback = value;}
			else if (key == "high_cloud_T_feedback") {options_list.high_cloud_to_T_feedback = value;}
			else if (key == "precipitation_T_feedback") {options_list.precipitation_to_T_feedback = value;}
			else {cout << "Key " << key << " not recognized in the context 'feedback_loops', exiting..." << endl; exit(0);}
			}
		else if (mode == "weather")
			{
			if (key == "random_seed") {options_list.weather_random_seed = static_cast<int>(value); options_list.weather_defined = true;}
			else if (key == "mid_cloudlevel_min")  {options_list.weather_mid_cloudlevel_min = value; options_list.weather_defined = true;}
			else if (key == "mid_cloudlevel_max")  {options_list.weather_mid_cloudlevel_max = value; options_list.weather_defined = true;}
			else if (key == "high_cloudlevel_min")  {options_list.weather_high_cloudlevel_min = value; options_list.weather_defined = true;}
			else if (key == "high_cloudlevel_max")  {options_list.weather_high_cloudlevel_max = value; options_list.weather_defined = true;}
			else if (key == "precipitation_factor")  {options_list.weather_precipitation_factor = value; options_list.weather_defined = true;}
			else if (key == "snow_albedo") {options_list.weather_snow_albedo = value;  options_list.weather_defined = true;}
			else if (key == "precipitation_threshold_convection") {options_list.weather_precipitation_threshold_convection = value;  options_list.weather_defined = true;}
			else if (key == "precipitation_threshold") {options_list.weather_precipitation_threshold_convection = value;  options_list.weather_defined = true;}
			else if (key == "precipitation_factor_convection") {options_list.weather_precipitation_factor_convection = value;  options_list.weather_defined = true;}
			else if (key == "cloud_factor_convection") {options_list.weather_cloud_factor_convection = value;  options_list.weather_defined = true;}
			else if (key == "ridge_migration_factor") {options_list.weather_ridge_migration_factor = value; options_list.weather_defined = true;}
			else if (key == "ridge_suppression_factor") {options_list.weather_ridge_suppression_factor = value; options_list.weather_defined = true;}
			else if (key == "circulation_model") {options_list.circulation_model_preset = static_cast<int>(value);}
			else if (key == "grad_motion_factor") {options_list.weather_storm_grad_motion_factor = value;}
			else {cout << "Key " << key << " not recognized in the context 'weather', exiting..." << endl; exit(0);}
			}
		else if (mode == "atmosphere")
			{
			if (key == "co2") {options_list.co2_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "co") {options_list.co_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "o2") {options_list.o2_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "o3") {options_list.o3_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "ar") {options_list.ar_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "n2") {options_list.n2_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "h2") {options_list.h2_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "cl2") {options_list.cl2_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "h2o") {options_list.h2o_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "ch4") {options_list.ch4_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "he") {options_list.he_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "ne") {options_list.ne_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "nh3") {options_list.nh3_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "h2s") {options_list.h2s_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "so2") {options_list.so2_fraction = value; options_list.atmosphere_defined = true;}
			else if (key == "surface_pressure") {options_list.atmosphere_surface_pressure = value; }
			else {cout << "Key " << key << " not recognized in the context 'atmosphere', exiting..." << endl; exit(0);}
			}
		else if (mode == "geology")
			{
			if (key == "system_age_gy") {options_list.geology_system_age = value;}
			else if (key == "isotope_abundancy") {options_list.geology_isotope_abundancy = value;}
			else if (key == "core_radius_km") {options_list.geology_core_radius = value * 1000.0;}
			else if (key == "core_radius") {options_list.geology_core_radius = value;}
			else if (key == "core_density") {options_list.geology_core_density = value * 1000;}
			else if (key == "inner_mantle_density") {options_list.geology_inner_mantle_density = value * 1000;}
			else if (key == "outer_mantle_density") {options_list.geology_outer_mantle_density = value * 1000;}
			else if (key == "depth_profile_res_km") {options_list.depth_profile_resolution = value * 1000.0;}
			else if (key == "tidal_dissipation") {options_list.geology_tidal_dissipation_factor = value;}
			else if (key == "surface_temperature") {options_list.geology_surface_temperature = value;}
			else {cout << "Key " << key << " not recognized in the context 'geology', exiting..." << endl; exit(0);}
			}
		else if (mode == "terrain_relief")
			{
			if (key == "base_scale_km") {options_list.relief_base_scale = value;}
			else if (key == "resolution_lat") {options_list.relief_num_lat = static_cast<int>(value);}
			else if (key == "resolution_lon") {options_list.relief_num_lon = static_cast<int>(value);}
			else if (key == "annual_rainfall") {options_list.relief_annual_rainfall = value;}	
			else if (key == "rainfall_variation") {options_list.relief_rainfall_var = value;}
			else if (key == "impact_rate_per_a") {options_list.relief_impact_rate = value;}
			else if (key == "impact_rate") {options_list.relief_impact_rate = value;}
			else if (key == "impact_mass_dist_par") {options_list.relief_impact_mass_distribution = value;}
			else if (key == "evolution_time_a") {options_list.relief_evolution_time = value;}
			else if (key == "evolution_time_myr") {options_list.relief_evolution_time = 1.0e6 * value;}
			else if (key == "evolution_time_gyr") {options_list.relief_evolution_time = 1.0e9 * value;}
			else if (key == "evolution_timestep_a") {options_list.relief_evolution_timestep = value;}
			else if (key == "evolution_timestep") {options_list.relief_evolution_timestep = value;}
			else if (key == "annual_rainfall_mm") {options_list.relief_annual_rainfall = value / 1000.0;}
			else if (key == "annual_rainfall_m") {options_list.relief_annual_rainfall = value;}
			else if (key == "annual_evaporation_mm") {options_list.relief_evaporation = value / 1000.0;}
			else if (key == "annual_evaporation_m") {options_list.relief_evaporation = value;}
			else {cout << "Key " << key << " not recognized in the context 'terrain_relief', exiting..." << endl; exit(0);}




			}
		key_flag = 0;
		}
	else if (key_flag == 2)
		{
		if (block == "star")
			{
			if (key == "name")
				{
				options_list.star_name = element;
				options_list.star_name_set = true;
				}
			}
		else if (block == "companion")
			{
			if (key == "name")
				{
				options_list.companion_name = element;
				options_list.companion_name_set = true;
				}
			else if (key == "retrograde")
				{
				if (element == "true") 
					{options_list.companion_retrograde = true;}
				}
			}
		else if (block == "binary")
			{
			if (key == "name")
				{
				options_list.binary_name = element;
				options_list.binary_name_set = true;
				}
			else if (key == "retrograde")
				{
				if (element == "true") 
					{options_list.binary_retrograde = true;}
				}
			}
		else if (block == "planet")
			{
			if (key == "name")
				{
				options_list.planet_name = element;
				options_list.planet_name_set = true;
				}
			else if (key == "materials_file")
				{
				options_list.materials_file = element;
				options_list.materials_file_set = true;
				}
			else if (key == "lagrange_point") 
				{
				if (element == "L4") 
					{options_list.planet_lagrange_orbit = true; options_list.planet_lagrange_leading = true;}
				else if (element == "L5")
					{options_list.planet_lagrange_orbit = true; options_list.planet_lagrange_leading = false;}
				else {cout << element << " is not a valid stable Lagrange point, use L4 or L5, exiting..." << endl; exit(0);}
				}
			else
				{cout << "Key " << key << " not recognized in the context 'planet', exiting..." << endl; exit(0);}
			}
		else if (block == "moon")
			{
			if (key == "name")
				{
				options_list.moon_name = element;
				options_list.moon_name_set = true;
				}
			else if (key == "materials_file")
				{
				options_list.moon_materials_file = element;
				options_list.moon_materials_file_set = true;
				}
			else if (key == "retrograde")
				{
				if (element == "true") 
					{options_list.moon_retrograde = true;}
				}
			else if (key == "lagrange_point") 
				{
				if (element == "L4") 
					{options_list.moon_lagrange_orbit = true; options_list.moon_lagrange_leading = true;}
				else if (element == "L5")
					{options_list.moon_lagrange_orbit = true; options_list.moon_lagrange_leading = false;}
				else {cout << element << " is not a valid stable Lagrange point, use L4 or L5, exiting..." << endl; exit(0);}
				}
			else
				{cout << "Key " << key << " not recognized in the context 'moon', exiting..." << endl; exit(0);}
			}
		else if (block == "body")
			{
			if (key == "name")
				{
				options_list.body_name[i_body] = element;
				}
			else if (key == "attach_to")
				{
				options_list.body_attach_to[i_body] = element;
				}
			else
				{cout << "Key " << key << " not recognized in the context 'body', exiting..." << endl; exit(0);}
				

			}
		else if (mode == "plot")
			{
			if (key == "var_x")
				{
				if (element == "lambda") {options_list.var_x = 1;}
				else if (element == "norm_daytime") {options_list.var_x = 2;}
				else if (element == "lat") {options_list.var_x = 3;}
				else if (element == "days") {options_list.var_x = 4;}
				else if (element == "hours"){options_list.var_x = 5;}
				else if (element == "altitude_m") {options_list.var_x = 6;}
				else if (element == "depth_m") {options_list.var_x = 6;}
				else if (element == "depth_R") 
					{options_list.var_x = 6; options_list.plot_x_range_factor = options_list.planet_radius * R_earth;}
				else if (element == "depth_km") 
					{options_list.var_x = 6; options_list.plot_x_range_factor = 1000.0;}
				}
			else if (key == "var_y")
				{
				if (element == "solar_spectrum") {options_list.var_y = 1;}
				else if (element == "sun_angle") {options_list.var_y = 2;}
				else if (element == "year_avg_irradiation") {options_list.var_y = 3;}
				else if (element == "atmosphere_transmission") {options_list.var_y = 4;}
				else if (element == "atmosphere_IR_transmission") {options_list.var_y = 4;}
				else if (element == "IR_emission_surface") {options_list.var_y = 5;}
				else if (element == "IR_emission_space") {options_list.var_y = 6;}
				else if (element == "atmosphere_UV_transmission") {options_list.var_y = 7;}
				else if (element == "solar_spectrum_surface") {options_list.var_y = 8;}
				else if (element == "atmosphere_UV_heating") {options_list.var_y = 9;}
				else if (element == "atmosphere_UV_T") {options_list.var_y = 10;}
				else if (element == "ozone_production") {options_list.var_y = 11;}
				else if (element == "internal_temperature") {options_list.var_y = 12;}
				else if (element == "internal_pressure") {options_list.var_y = 14;}
				}
			else if (key == "file") 
				{
				options_list.plot_filename = element; 
				options_list.plot_filename_defined = true;
				}	
			else if (key == "body")
				{
				options_list.plot_body = element;
				if (element == "planet") 
					{options_list.plot_body_index = 1;}
				else if (element == "star")
					{options_list.plot_body_index = 0;}
				else if (element == "binary")
					{options_list.plot_body_index = 2;}
				else if (element == "companion")
					{options_list.plot_body_index = 2;}
				else if (element == "moon")
					{options_list.plot_body_index = 2;}
				else if (element == options_list.star_name) 
					{options_list.plot_body_index = 0;}
				else if (element == options_list.companion_name) 
					{options_list.plot_body_index = 2;}
				else if (element == options_list.binary_name) 
					{options_list.plot_body_index = 2;}
				else if (element == options_list.moon_name) 
					{options_list.plot_body_index = 2;}
				else if (element == options_list.planet_name) 
					{options_list.plot_body_index = 1;}
				}
			else if (key == "radiation_from")
				{
				if (element == "all"){options_list.plot_star_index = 0;}
				else if (element == "star") {options_list.plot_star_index = 1;}
				else if (element == "companion") {options_list.plot_star_index = 2;}
				else if (element == "binary") {options_list.plot_star_index = 3;}
				else if (element == options_list.star_name) {options_list.plot_star_index = 1;}
				else if (element == options_list.companion_name) {options_list.plot_star_index = 2;}
				else if (element == options_list.binary_name) {options_list.plot_star_index = 3;}
				else {cout << "Element " << element << " not recognized in the context 'radiation_from', exiting..." << endl; exit(0);}
				}
			else if (key == "exclusive_component") {options_list.plot_exclusive_component = element;}
	
			else {cout << "Key " << key << " not recognized in the context 'plot', exiting..." << endl; exit(0);}
			}
		else if (mode == "plot_orbit")
			{
			if (key == "file") 
				{
				options_list.plot_orbit_filename = element; 
				options_list.plot_orbit_filename_defined = true;
				}
			else if (key == "body")
				{
				options_list.plot_orbit_body = element;



				if (element == "planet") 
					{options_list.plot_orbit_body_index = 1;}
				else if (element == "star")
					{options_list.plot_orbit_body_index = 0;}
				else if (element == "binary")
					{options_list.plot_orbit_body_index = 2;}
				else if (element == "companion")
					{options_list.plot_orbit_body_index = 2;}
				else if (element == "moon")
					{options_list.plot_orbit_body_index = 2;}
				else if (element == options_list.star_name)
					{options_list.plot_orbit_body_index = 0;}
				else if (element == options_list.planet_name)
					{options_list.plot_orbit_body_index = 1;}
				else if (element == options_list.binary_name)
					{options_list.plot_orbit_body_index = 2;}
				else if (element == options_list.companion_name)
					{options_list.plot_orbit_body_index = 2;}
				else if (element == options_list.moon_name)
					{options_list.plot_orbit_body_index = 2;}
				else if (options_list.num_bodies > 0)
					{
					for (int i=0; i< options_list.num_bodies; i++)
						{
						if (element == options_list.body_name[i]) {options_list.plot_orbit_body_index = 4; break;}
						}
					if (options_list.plot_orbit_body_index != 4) { cout << "Element " << element << " not recognized in the context 'plot_orbit', exiting..." << endl; exit(0); }	
					}
				else {cout << "Element " << element << " not recognized in the context 'plot_orbit', exiting..." << endl; exit(0);}
				}
			else if (key == "relative_to")
				{
				options_list.plot_orbit_reference = element;
				if (element == "planet") 
					{options_list.plot_orbit_ref_index = 1; options_list.plot_orbit_relative = true;}
				else if (element == "star")
					{options_list.plot_orbit_ref_index = 0; options_list.plot_orbit_relative = true;}
				else if (element == "binary")
					{options_list.plot_orbit_ref_index = 2; options_list.plot_orbit_relative = true;}
				else if (element == "companion")
					{options_list.plot_orbit_ref_index = 2; options_list.plot_orbit_relative = true;}
				else if (element == "moon")
					{options_list.plot_orbit_ref_index = 2; options_list.plot_orbit_relative = true;}
				else if (element == options_list.star_name)
					{options_list.plot_orbit_ref_index = 0; options_list.plot_orbit_relative = true;}
				else if (element == options_list.planet_name)
					{options_list.plot_orbit_ref_index = 1; options_list.plot_orbit_relative = true;}
				else if (element == options_list.companion_name)
					{options_list.plot_orbit_ref_index = 2; options_list.plot_orbit_relative = true;}
				else if (element == options_list.binary_name)
					{options_list.plot_orbit_ref_index = 2; options_list.plot_orbit_relative = true;}
				else if (element == options_list.moon_name)
					{options_list.plot_orbit_ref_index = 2; options_list.plot_orbit_relative = true;}
				else if (options_list.num_bodies > 0)
					{
					for (int i=0; i< options_list.num_bodies; i++)
						{
						if (element == options_list.body_name[i]) {options_list.plot_orbit_ref_index = 4; options_list.plot_orbit_relative = true; break;}
						}
					if (options_list.plot_orbit_ref_index != 4) {cout << "Element " << element << " not recognized in the context 'plot_orbit',  exiting..." << endl; exit(0);}	
					}
				else {cout << "Element " << element << " not recognized in the context 'plot_orbit', exiting..." << endl; exit(0);}
				
				}

			}
		else if (mode == "plot_surface")
			{
			if (key == "file") 
				{
				options_list.plot_surface_filename = element; 
				options_list.plot_surface_filename_defined = true;
				}
			else if (key == "var_z") 
				{	
				if (element == "albedo") {options_list.var_z_surface = 1;}
				else if (element == "temperature") {options_list.var_z_surface = 2;}
				else if (element == "total_irradiation") {options_list.var_z_surface = 3;}
				else if (element == "IR_emission_flux") {options_list.var_z_surface = 4;}
				else if (element == "reflected_flux") {options_list.var_z_surface = 5;}
				else if (element == "transported_flux") {options_list.var_z_surface = 6;}
				else if (element == "instantaneous_transported_flux") {options_list.var_z_surface = 7;}
				else if (element == "transported_energy") {options_list.var_z_surface = 8;}
				else if (element == "cloud_cover") {options_list.var_z_surface = 9;}
				else if (element == "absorbed_flux") {options_list.var_z_surface = 10;}
				else if (element == "low_cloud_cover") {options_list.var_z_surface = 11;}
				else if (element == "mid_cloud_cover") {options_list.var_z_surface = 12;}
				else if (element == "ice_thickness") {options_list.var_z_surface = 13;}
				else if (element == "snow_thickness") {options_list.var_z_surface = 14;}
				else if (element == "precipitation") {options_list.var_z_surface = 15;}
				else if (element == "high_cloud_cover") {options_list.var_z_surface = 16;}
				else if (element == "ground_albedo") {options_list.var_z_surface = 17;}
				else if (element == "total_albedo") {options_list.var_z_surface = 18;}
				else if (element == "storms") {options_list.var_z_surface = 19;}
				else if (element == "convective_energy") {options_list.var_z_surface = 20;}
				}
			else if (key == "body")
				{
				options_list.plot_surface_body = element;
				if (element == "planet") 
					{options_list.plot_surface_body_index = 1;}
				else if (element == "moon")
					{options_list.plot_surface_body_index = 2;}
				else if (element == options_list.planet_name)
					{options_list.plot_surface_body_index = 1;}
				else if (element == options_list.moon_name)
					{options_list.plot_surface_body_index = 2;}
				}
			}
		else if (mode == "orbit")
			{
			if (key == "resume_from")
				{
				options_list.orbit_filename = element;
				options_list.orbit_resume_flag = true;
				}
			else if (key == "save_to")
				{
				options_list.orbit_filename = element;
				options_list.orbit_save_flag = true;
				}
			}
		else if (mode == "weather")
			{
			if (key == "storms")
				{
				if (element == "true") 
					{options_list.weather_storms = true;}
				else 
					{options_list.weather_storms = false;}
				}

			}
		else if (mode == "geology")
			{
			if (key == "core_material") {options_list.geology_core_material = element;}
			else if (key == "material") {options_list.geology_core_material = element;}
			else if (key == "mantle_material") {options_list.geology_inner_mantle_material = element;}
			else if (key == "inner_mantle_material") {options_list.geology_inner_mantle_material = element;}
			else if (key == "outer_mantle_material") {options_list.geology_outer_mantle_material = element;}
			else if (key == "component") 	
				{
				if (options_list.geology_num_components == 0) {options_list.geology_component_1 = element;}
				else {options_list.geology_component_2 = element;}
				options_list.geology_num_components++;
				options_list.geology_differentiated = false;
				}
			else if (key == "depth_profile")
				{
				if (element == "true") {options_list.depth_profile_defined = true;}
				}

			}
		else if (mode == "terrain_relief")
			{
			if (key == "file") {options_list.relief_filename = element;}
			else {cout << "Key " << key<< " not recognized in the context 'terrain_relief', exiting..." << endl; exit(0);}
			}
		else if (mode == "checks")
			{
			if (key == "roche_limit")
				{
				if (element == "true") 
					{options_list.roche_check = true; options_list.consistency_checks = true;}
				}
			else if (key == "orbital_stability")
				{
				if (element == "true") 
					{options_list.hill_sphere_check = true; options_list.consistency_checks = true;}
				}
			else if (key == "atmosphere_phase")
				{
				if (element == "true") 
					{options_list.atmosphere_phase_check = true; options_list.consistency_checks = true;}
				}
			else if (key == "tidal_locking")
				{
				if (element == "true") 
					{options_list.tidal_locking_check = true; options_list.consistency_checks = true;}
				}
			else 
				{
				cout << "Keyword " << key << " not recognized in the context 'checks', exiting..." << endl; exit(0);
				}
			}
		else if (mode == "record")
			{

			if (key == "file")
				{
				options_list.record_filename = element; 
				options_list.record_filename_defined = true;
				}
			else if (key == "var_y")
				{
				if (element == "temperature")
					{options_list.record_var_y[options_list.record_num_columns] = 1; options_list.record_num_columns++;}
				else if (element == "sun_angle")
					{options_list.record_var_y[options_list.record_num_columns] = 2; options_list.record_num_columns++;}
				else if (element == "IR_emission_flux")
					{options_list.record_var_y[options_list.record_num_columns] = 3; options_list.record_num_columns++;}
				else if (element == "reflected_flux")
					{options_list.record_var_y[options_list.record_num_columns] = 4; options_list.record_num_columns++;}
				else if (element == "absorbed_flux")
					{options_list.record_var_y[options_list.record_num_columns] = 5; options_list.record_num_columns++;}
				else if (element == "cloud_cover")
					{options_list.record_var_y[options_list.record_num_columns] = 6; options_list.record_num_columns++;}
				else if (element == "low_cloud_cover")
					{options_list.record_var_y[options_list.record_num_columns] = 7; options_list.record_num_columns++;}
				else if (element == "mid_cloud_cover")
					{options_list.record_var_y[options_list.record_num_columns] = 8; options_list.record_num_columns++;}
				else if (element == "high_cloud_cover")
					{options_list.record_var_y[options_list.record_num_columns] = 9; options_list.record_num_columns++;}
				else if (element == "precipitation")
					{options_list.record_var_y[options_list.record_num_columns] = 10; options_list.record_num_columns++;}
				else if (element == "snow_thickness")
					{options_list.record_var_y[options_list.record_num_columns] = 11; options_list.record_num_columns++;}
				else if (element == "ice_thickness")
					{options_list.record_var_y[options_list.record_num_columns] = 12; options_list.record_num_columns++;}
				else if (element == "albedo")
					{options_list.record_var_y[options_list.record_num_columns] = 13; options_list.record_num_columns++;}
				else if (element == "debug_year_fraction") 
					{options_list.record_var_y[options_list.record_num_columns] = 14; options_list.record_num_columns++;}
				else if (element == "debug_longyear_fraction") 
					{options_list.record_var_y[options_list.record_num_columns] = 15; options_list.record_num_columns++;}
				else if (element == "debug_solar_declination") 
					{options_list.record_var_y[options_list.record_num_columns] = 16; options_list.record_num_columns++;}
				else if (element == "debug_solar_declination_companion") 
					{options_list.record_var_y[options_list.record_num_columns] = 17; options_list.record_num_columns++;}
				else if (element == "debug_solar_declination_binary") 
					{options_list.record_var_y[options_list.record_num_columns] = 18; options_list.record_num_columns++;}
				else if (element == "convective_energy") 
					{options_list.record_var_y[options_list.record_num_columns] = 19; options_list.record_num_columns++;}

				}
			else if (key == "var_x")
				{
				if (element == "days")
					{options_list.record_x_format_factor = 86400.0;}
				else if (element == "years")
					{options_list.record_x_format_factor = 31536000.0;}
				else if (element == "hours")
					{options_list.record_x_format_factor = 3600;}

				}
			else if (key == "reference")
				{
				if (element == "star")
					{options_list.record_ref_index = 0;}
				else if (element == "companion")
					{options_list.record_ref_index = 1;}
				else if (element == "binary")
					{options_list.record_ref_index = 2;}
				else if (element == options_list.star_name)
					{options_list.record_ref_index = 0;}
				else if (element == options_list.companion_name)
					{options_list.record_ref_index = 1;}
				else if (element == options_list.binary_name)
					{options_list.record_ref_index = 2;}
				

				}
			else if (key == "body")
				{
				if (element == "planet")
					{options_list.record_body_index = 0;}
				else if (element == "moon")
					{options_list.record_body_index = 1;}
				else if (element == options_list.planet_name) 
					{options_list.record_body_index = 0;}
				else if (element == options_list.moon_name) 
					{options_list.record_body_index = 1;}
				

				}
			else 
				{cout << "Keyword " << key << " not recognized in mode 'record'. " << endl;}
	
			}
		else if (mode == "scatter_plot")
			{

			if (key == "file")
				{
				options_list.scatter_filename = element; 
				options_list.scatter_filename_defined = true;
				}
			else if (key == "type")
				{
				if (element == "storm_tracks"){options_list.scatter_type = 0; options_list.scatter_plot_defined = true;}

				}
			}
		else if (mode == "orbit_summary")
			{
			if (key == "variable")
				{
				options_list.report_orbit_variable[options_list.report_orbit_num_var] = element;
				options_list.report_orbit_num_var++;
				}
			else if (key == "body")
				{
				options_list.report_orbit_source[options_list.report_orbit_num_src] = element;
				options_list.report_orbit_num_src++;
				}
			else if (key == "reference")
				{
				options_list.report_orbit_reference = element;
				}

			}
		else if (mode == "config")
			{
			if (key == "materials")
				{
				materials_parser(element);
				}
			else if (key == "gr_corrections")
				{
				if (element == "false") 
					{options_list.use_gr_corrections = false;}
				
				}
			else if (key == "apoapsis_init")
				{
				if (element == "true") 
					{options_list.use_apoapsis_init = true;}
				
				}
			else if (key == "eclipse_finder")
				{
				if (element == "true") 
					{options_list.use_eclipse_finder = true;}
				
				}
			else if (key == "collision_finder")
				{
				if (element == "true") 
					{options_list.use_collision_finder = true;}
				
				}
			else if (key == "eclipse_verbose")
				{
				if (element == "false") 
					{options_list.use_eclipse_verbose = false;}
				
				}
			else if (key == "indirect_irradiation")
				{
				if (element == "false") 
					{options_list.use_indirect_irradiation = false;}
				
				}
			}
			
		key_flag = 0;
		}
	//cout << key_flag << endl;


    }
    cfgfile.close();

    if ((options_list.weather_random_seed == -1) && (options_list.random_seed != -1)) 
		{options_list.weather_random_seed = options_list.random_seed;}
    else if (options_list.weather_random_seed == -1)
		{options_list.weather_random_seed = time(0); }
    if (options_list.random_seed == -1) {options_list.random_seed = time(0); }


    if ((options_list.star_mass > 0.0) && (options_list.star_temperature > 0.0) && (options_list.star_luminosity == 0.0))
	{
	central_sun.assign_properties(options_list.star_mass, options_list.star_temperature);
	options_list.star_defined = true;
	if (options_list.star_name_set) {central_sun.assign_name(options_list.star_name);}
	central_sun.list_properties();
	}
   else if ((options_list.star_mass > 0.0) && (options_list.star_temperature > 0.0) && (options_list.star_luminosity > 0.0) && (options_list.star_radius > 0.0))
	{
	central_sun.assign_properties(options_list.star_mass, options_list.star_temperature, options_list.star_luminosity, options_list.star_radius);
	options_list.star_defined = true;
	if (options_list.star_name_set) {central_sun.assign_name(options_list.star_name);}
	central_sun.list_properties();
	}


    if ((options_list.companion_mass > 0.0) && (options_list.companion_temperature > 0.0) && (options_list.companion_luminosity == 0.0))
	{
	companion.assign_properties(options_list.companion_mass, options_list.companion_temperature);
	options_list.companion_defined = true;
	if (options_list.companion_name_set) {companion.assign_name(options_list.companion_name);}
	companion.list_properties();
	}
   else if ((options_list.companion_mass > 0.0) && (options_list.companion_temperature > 0.0) && (options_list.companion_luminosity > 0.0) && (options_list.companion_radius > 0.0))
	{
	companion.assign_properties(options_list.companion_mass, options_list.companion_temperature, options_list.companion_luminosity, options_list.companion_radius);
	options_list.companion_defined = true;
	if (options_list.companion_name_set) {companion.assign_name(options_list.companion_name);}
	companion.list_properties();
	}


    if ((options_list.binary_mass > 0.0) && (options_list.binary_temperature > 0.0) && (options_list.binary_luminosity == 0.0))
	{
	binary.assign_properties(options_list.binary_mass, options_list.binary_temperature);
	options_list.binary_defined = true;
	if (options_list.binary_name_set) {binary.assign_name(options_list.binary_name);}
	binary.list_properties();
	}
   else if ((options_list.binary_mass > 0.0) && (options_list.binary_temperature > 0.0) && (options_list.binary_luminosity > 0.0) && (options_list.binary_radius > 0.0))
	{
	binary.assign_properties(options_list.binary_mass, options_list.binary_temperature, options_list.binary_luminosity, options_list.binary_radius);
	options_list.binary_defined = true;
	if (options_list.binary_name_set) {binary.assign_name(options_list.binary_name);}
	binary.list_properties();
	}


   if ((options_list.planet_mass > 0.0) && (options_list.planet_radius > 0.0))
	{
	planet.assign_properties(options_list.planet_mass, options_list.planet_radius);
	if (options_list.planet_name_set) {planet.assign_name(options_list.planet_name);}
	else  {planet.assign_name("Planet");}
	planet.list_properties();
	options_list.planet_defined = true;

  	planet.assign_atmosphere_basic(options_list.atmosphere_IR_blocking, options_list.atmosphere_transport_coeff);
  	planet.assign_hydrosphere_basic(options_list.hydrosphere_transport_coeff, options_list.hydrosphere_ice_factor);
	planet.atmosphere.set_albedo(options_list.atmosphere_albedo);

	}

  if ((options_list.planet_semimajor > 0.0) && (options_list.planet_semimajor_binary == 0.0))
	{
	double ecc = 0.0;
	if (options_list.planet_eccentricity > 0.0) {ecc = options_list.planet_eccentricity;}
	planet.assign_orbit (options_list.planet_semimajor, ecc, central_sun.get_mass());
	planet.list_orbit();
	options_list.planet_orbit_defined = true;

	}




  // if there is a defined orbit, we can do evolution times in terms of orbital period

  if (options_list.full_evolve_time_op > 0.0) 
		{
		options_list.full_evolve_time = options_list.full_evolve_time_op * planet.get_period();
	        options_list.full_evolve = true;
		}

  if (options_list.orbit_evolve_time_op > 0.0) 
		{
		options_list.orbit_evolve_time = options_list.orbit_evolve_time_op * planet.get_period();
	        options_list.orbit_evolve = true;
		}

  if (options_list.record_delay_op > 0.0)
		{
		options_list.record_delay = options_list.record_delay_op * planet.get_period();
		}
  if (options_list.scatter_delay_op > 0.0)
		{
		options_list.scatter_delay = options_list.scatter_delay_op * planet.get_period();
		}



  if ((options_list.report_orbit_num_src > 0) && (options_list.report_orbit_num_var > 0))
	{
	options_list.report_orbit_defined = true;
	}


  if (options_list.planet_semimajor_longyear > 0.0)
	{
	double ecc = 0.0;
	if (options_list.planet_eccentricity_longyear > 0.0) {ecc = options_list.planet_eccentricity_longyear;}
	planet.assign_orbit_longyear (options_list.planet_semimajor_longyear, ecc, companion.get_mass(), central_sun.get_mass());
	planet.tilt_orbit_longyear(options_list.planet_inc_of_companion, options_list.planet_lan_of_companion);

	planet.list_orbit_longyear();
	options_list.planet_orbit_longyear_defined = true;
	}

  // Lagrange orbits, work only for planets in companion systems or moons

  if ((options_list.planet_semimajor == 0.0) && (options_list.planet_lagrange_orbit == true))
	{
	if (options_list.planet_orbit_longyear_defined == false)
		{
		cout << "Planetary Lagrange orbits can only be assigned with companion stars, exiting..." << endl; 
		exit(0);
		}
		
	planet.assign_orbit_lagrange(options_list.planet_lagrange_leading);
	planet.assign_lagrange_corrections(options_list.planet_L_dphi, options_list.planet_L_dR, options_list.planet_L_dz, options_list.planet_L_dvR, options_list.planet_L_dvT, options_list.planet_L_dvz);
	planet.list_orbit();
	options_list.planet_orbit_defined = true;
	}


  if (options_list.planet_semimajor_binary > 0.0)
	{
	double ecc = 0.0;
	if (options_list.planet_eccentricity_binary > 0.0) {ecc = options_list.planet_eccentricity_binary;}
	planet.assign_orbit_binary (options_list.planet_semimajor_binary, ecc, binary.get_mass(), central_sun.get_mass());
	planet.tilt_orbit_binary(options_list.planet_inc_of_binary, options_list.planet_lan_of_binary);
	planet.list_orbit_binary();
	options_list.planet_orbit_binary_defined = true;
	// need to assign planet orbit now because it orbits barycenter, not primary star
	ecc = 0.0;
	if (options_list.planet_eccentricity > 0.0) {ecc = options_list.planet_eccentricity;}
	planet.assign_orbit (options_list.planet_semimajor, ecc, central_sun.get_mass() + binary.get_mass());
	planet.list_orbit();
	options_list.planet_orbit_defined = true;
	}





   if (((options_list.planet_rot_period > 0.0) || (options_list.planet_sid_rot_period > 0))&& (options_list.planet_orbit_defined))
	{
	if (options_list.planet_rot_period > 0.0)
		{
		planet.assign_rotation(options_list.planet_rot_period, options_list.planet_inc, options_list.planet_dec_offset);
		}
	else
		{
		double rot_period = options_list.planet_sid_rot_period / (1.0 - options_list.planet_sid_rot_period/planet.get_period());
		planet.assign_rotation(rot_period, options_list.planet_inc, options_list.planet_dec_offset);
		}



	if (options_list.companion_defined)
		{
		double dec_offset = options_list.planet_dec_offset + options_list.companion_apsis_angle;
		if (dec_offset > 2.0 * pi) {dec_offset = dec_offset - 2.0 * pi;}

		AxisTransform axis;
		axis.initialize(options_list.planet_inc, dec_offset);	
		axis.tilt_orbital_plane(options_list.planet_inc_of_companion, options_list.planet_lan_of_companion + 90.0 * deg_to_rad);
		planet.assign_companion_dec_offset(axis.get_eff_dec_offset());
		planet.assign_companion_tilt_axis(axis.get_eff_tilt());

		//cout << "Axis to companion: " << axis.get_eff_tilt() * rad_to_deg << " " << axis.get_eff_dec_offset() * rad_to_deg << endl;
		}
	planet.list_rotation();
	options_list.planet_rotation_defined = true;
	}
 





	


	

	

  if (options_list.planet_defined && options_list.star_defined && options_list.planet_orbit_defined)
	{
	if (options_list.planet_mean_albedo > 0.0) {planet.set_albedo(options_list.planet_mean_albedo);}
	else {planet.set_albedo (0.5);}

	if ((options_list.planet_mean_heat_capacity > 0.0) && (options_list.planet_mean_diurnal_depth > 0.0))
		{planet.set_thermal_properties(options_list.planet_mean_heat_capacity, options_list.planet_mean_diurnal_depth);}
	else {planet.set_thermal_properties(2.0, 0.1);}

	if (options_list.planet_max_diurnal_depth > 0.0)
		{planet.set_max_diurnal_depth(options_list.planet_max_diurnal_depth);}

	if (options_list.planet_T_init > 0.0)
		{planet.set_T_init(options_list.planet_T_init);}

	if (options_list.planet_internal_heat > 0.0) {planet.set_internal_heat(options_list.planet_internal_heat);}
	else {planet.set_internal_heat (0.0);}


	double sc_max = central_sun.get_luminosity() / (4.0 * pi * pow(planet.get_periapsis(), 2.0));
	double sc_min = central_sun.get_luminosity() / (4.0 * pi * pow(planet.get_apoapsis(), 2.0));
	planet.set_solar_constants (sc_max, sc_min);

	if (options_list.planet_orbit_longyear_defined)
		{
		sc_max = companion.get_luminosity() / (4.0 * pi * pow(planet.get_periapsis_longyear(), 2.0)); 
		sc_min = companion.get_luminosity() / (4.0 * pi * pow(planet.get_apoapsis_longyear(), 2.0)); 
		planet.set_solar_constants (sc_max, sc_min, 1);
		}

	if (options_list.planet_orbit_binary_defined)
		{
		sc_max = binary.get_luminosity() / (4.0 * pi * pow(planet.get_periapsis(), 2.0)); 
		sc_min = binary.get_luminosity() / (4.0 * pi * pow(planet.get_apoapsis(), 2.0)); 
		planet.set_solar_constants (sc_max, sc_min, 1);
		}

	planet.compute_average_thermal_properties ();
	planet.list_thermal_properties();
	options_list.planet_thermal_defined = true;
	}


   if ((options_list.moon_mass > 0.0) && (options_list.moon_radius > 0.0))
	{
	moon.assign_properties(options_list.moon_mass, options_list.moon_radius);
	if (options_list.moon_name_set) {moon.assign_name(options_list.moon_name);}
	else  {moon.assign_name("Moon");}
	moon.list_properties();
	options_list.moon_defined = true;

  	moon.assign_atmosphere_basic(options_list.moon_atmosphere_IR_blocking, options_list.moon_atmosphere_transport_coeff);
  	moon.assign_hydrosphere_basic(options_list.moon_hydrosphere_transport_coeff, options_list.moon_hydrosphere_ice_factor);
	moon.atmosphere.set_albedo(options_list.moon_atmosphere_albedo);

	}

  if (options_list.moon_semimajor > 0.0) 
	{
	double ecc = 0.0;
	if (options_list.moon_eccentricity > 0.0) {ecc = options_list.moon_eccentricity;}
	moon.assign_orbit (options_list.moon_semimajor, ecc, planet.get_mass());
	moon.tilt_orbit_planet(options_list.moon_inc_of_planet, options_list.moon_lan_of_planet);
	//ecc = 0.0;
	//if (options_list.planet_eccentricity > 0.0) {ecc = options_list.planet_eccentricity;}
	//moon.assign_orbit_longyear (options_list.planet_semimajor, ecc, central_sun.get_mass(), planet.get_mass());
	moon.list_orbit();
	options_list.moon_orbit_defined = true;

	if (options_list.planet_orbit_longyear_defined)
		{
		moon.register_orbit_companion();
		}
	if (options_list.planet_orbit_binary_defined)
		{
		moon.register_orbit_binary();
		}

	}

  // Lagrange orbits, work only for planets in companion systems or moons

  if ((options_list.moon_semimajor == 0.0) && (options_list.moon_lagrange_orbit == true))
	{
	if ((options_list.planet_orbit_longyear_defined) || (options_list.planet_orbit_binary_defined))
		{
		cout << "Moon Lagrange orbits can only be assigned for systems with single stars, exiting..." << endl; 
		exit(0);
		}
		
	moon.assign_orbit_lagrange(options_list.moon_lagrange_leading);
	moon.assign_lagrange_corrections(options_list.moon_L_dphi, options_list.moon_L_dR, options_list.moon_L_dz, options_list.moon_L_dvR, options_list.moon_L_dvT, options_list.moon_L_dvz);
	moon.list_orbit();
	options_list.moon_orbit_defined = true;
	}


   if (((options_list.moon_rot_period > 0.0) || (options_list.moon_sid_rot_period > 0))&& (options_list.moon_orbit_defined))
	{

	AxisTransform axis;
	axis.initialize(options_list.moon_inc, options_list.moon_dec_offset);	
	//cout << "Moon inc: " << options_list.moon_inc * rad_to_deg << " " << options_list.moon_dec_offset * rad_to_deg << endl;
	axis.tilt_orbital_plane(options_list.moon_inc_of_planet, options_list.moon_lan_of_planet + 90.0 * deg_to_rad);

	//cout << "Axis to star: " << axis.get_eff_tilt() * rad_to_deg << " " << axis.get_eff_dec_offset() * rad_to_deg << endl;

	if (options_list.moon_rot_period > 0.0)
		{
		moon.assign_rotation(options_list.moon_rot_period, axis.get_eff_tilt(), axis.get_eff_dec_offset()  );
		}
	else
		{
		double rot_period = options_list.moon_sid_rot_period / (1.0 - options_list.moon_sid_rot_period/moon.get_period());
		moon.assign_rotation(rot_period, axis.get_eff_tilt(), axis.get_eff_dec_offset());
		}

	if (options_list.planet_orbit_longyear_defined)
		{
		//cout << "Companion lan: " << options_list.planet_lan_of_companion * rad_to_deg << endl;
		axis.tilt_orbital_plane(options_list.planet_inc_of_companion, options_list.planet_lan_of_companion + 90.0 * deg_to_rad);
		moon.assign_companion_dec_offset(axis.get_eff_dec_offset() + 0.0 * deg_to_rad );
		moon.assign_companion_tilt_axis(axis.get_eff_tilt());
		//cout << "Axis to companion: " << axis.get_eff_tilt() * rad_to_deg << " " << axis.get_eff_dec_offset() * rad_to_deg << endl;
		}

	moon.list_rotation();
	options_list.moon_rotation_defined = true;


	}





  if (options_list.planet_defined && options_list.star_defined && options_list.planet_orbit_defined && options_list.moon_orbit_defined)
	{
	if (options_list.moon_mean_albedo > 0.0) {moon.set_albedo(options_list.moon_mean_albedo);}
	else {moon.set_albedo (0.5);}

	if ((options_list.moon_mean_heat_capacity > 0.0) && (options_list.moon_mean_diurnal_depth > 0.0))
		{moon.set_thermal_properties(options_list.moon_mean_heat_capacity, options_list.moon_mean_diurnal_depth);}
	else {moon.set_thermal_properties(2.0, 0.1);}

	if (options_list.moon_max_diurnal_depth > 0.0)
		{moon.set_max_diurnal_depth(options_list.moon_max_diurnal_depth);}

	if (options_list.moon_T_init > 0.0)
		{moon.set_T_init(options_list.moon_T_init);}

	if (options_list.moon_internal_heat > 0.0) {moon.set_internal_heat(options_list.moon_internal_heat);}
	else {moon.set_internal_heat (0.0);}


	double sc_max = central_sun.get_luminosity() / (4.0 * pi * pow(planet.get_periapsis() - moon.get_apoapsis(), 2.0));
	double sc_min = central_sun.get_luminosity() / (4.0 * pi * pow(planet.get_apoapsis() + moon.get_apoapsis(), 2.0));
	moon.set_solar_constants (sc_max, sc_min);

	if (options_list.planet_orbit_longyear_defined)
		{
		sc_max = companion.get_luminosity() / (4.0 * pi * pow(planet.get_periapsis_longyear() - moon.get_apoapsis(), 2.0)); 
		sc_min = companion.get_luminosity() / (4.0 * pi * pow(planet.get_apoapsis_longyear() + moon.get_apoapsis(), 2.0)); 
		moon.set_solar_constants (sc_max, sc_min, 1);
		}

	if (options_list.planet_orbit_binary_defined)
		{
		sc_max = binary.get_luminosity() / (4.0 * pi * pow(planet.get_periapsis() - moon.get_apoapsis(), 2.0)); 
		sc_min = binary.get_luminosity() / (4.0 * pi * pow(planet.get_apoapsis() + moon.get_apoapsis(), 2.0)); 
		moon.set_solar_constants (sc_max, sc_min, 1);
		moon.register_orbit_binary();
		}

	moon.compute_average_thermal_properties ();
	moon.list_thermal_properties();
	options_list.moon_thermal_defined = true;
	}

  if (options_list.planet_defined && options_list.star_defined && options_list.planet_orbit_defined)
	{
	bool flag = true;

	for (int i=0; i<options_list.num_bodies; i++)
		{
		if ((options_list.body_radius[i] == 0.0) || (options_list.body_mass[i] == 0.0) || ((options_list.body_semimajor[i] == 0.0) && (options_list.body_semimajor_min[i] == 0.0)) )
			{
			flag = false;
			}
		if ((options_list.body_name[i] == "") || (options_list.body_attach_to[i] == ""))
			{
			flag = false;
			}
		}
	if (flag) 
		{
		options_list.bodies_defined = true;
		body_array = new Body[options_list.num_bodies];
		for (int i=0; i<options_list.num_bodies; i++)
			{

			if (options_list.body_distance[i] == 0.0)
				{
				body_array[i].assign_properties(options_list.body_mass[i], options_list.body_radius[i], options_list.body_semimajor[i], options_list.body_eccentricity[i], options_list.body_apsis_angle[i], options_list.body_inclination[i], options_list.body_lan[i]);
				}
			else
				{
				if (options_list.body_semimajor[i] > 0.0) {cout << "Semimajor axis needs to be negative for hyperbolic orbit, exiting..." << endl; exit(0);}
				body_array[i].assign_properties(options_list.body_mass[i], options_list.body_radius[i], options_list.body_semimajor[i], options_list.body_distance[i], options_list.body_eccentricity[i], options_list.body_apsis_angle[i], options_list.body_inclination[i], options_list.body_lan[i]);
				}
			
			body_array[i].set_random_seed(options_list.random_seed + 123 * i);
			if ((options_list.body_apsis_angle_min[i] != 0.0) || (options_list.body_apsis_angle_max[i] != 0.0))
				{
				body_array[i].set_random("apsis_angle", options_list.body_apsis_angle_min[i], options_list.body_apsis_angle_max[i]);
				}
			if ((options_list.body_semimajor_min[i] != 0.0) || (options_list.body_semimajor_max[i] != 0.0))
				{
				body_array[i].set_random("semimajor", options_list.body_semimajor_min[i], options_list.body_semimajor_max[i]);
				}
			if ((options_list.body_eccentricity_min[i] != 0.0) || (options_list.body_eccentricity_max[i] != 0.0))
				{
				body_array[i].set_random("eccentricity", options_list.body_eccentricity_min[i], options_list.body_eccentricity_max[i]);
				}

			body_array[i].set_name(options_list.body_name[i]);
			body_array[i].set_central_body(options_list.body_attach_to[i]);

			if ((options_list.planet_defined) && ((options_list.body_attach_to[i] == planet.get_designation())|| (options_list.body_attach_to[i] == "planet")))
				{
				body_array[i].set_central_body(planet.get_designation());
				body_array[i].set_central_mass(planet.get_mass());
				}
			else if ((options_list.moon_defined) && ((options_list.body_attach_to[i] == moon.get_designation())|| (options_list.body_attach_to[i] == "moon")))
				{
				body_array[i].set_central_body(moon.get_designation());
				body_array[i].set_central_mass(moon.get_mass());
				}
			else if ((options_list.star_defined) && ((options_list.body_attach_to[i] == central_sun.get_designation())|| (options_list.body_attach_to[i] == "star")))
				{
				body_array[i].set_central_body(central_sun.get_designation());
				body_array[i].set_central_mass(central_sun.get_mass());
				}
			else if ((options_list.binary_defined) && ((options_list.body_attach_to[i] == binary.get_designation())|| (options_list.body_attach_to[i] == "binary")))
				{
				body_array[i].set_central_body(binary.get_designation());
				body_array[i].set_central_mass(binary.get_mass());
				}
			else if ((options_list.companion_defined) && ((options_list.body_attach_to[i] == companion.get_designation())|| (options_list.body_attach_to[i] == "companion")))
				{
				body_array[i].set_central_body(companion.get_designation());
				body_array[i].set_central_mass(companion.get_mass());
				}
			else
				{
				for (int j=0; j<i; j++)
					{
					if (options_list.body_attach_to[i] == options_list.body_name[j])
						{
						body_array[i].set_central_body(options_list.body_name[j]);
						body_array[i].set_central_mass(body_array[j].get_mass());
						}
					}
				}

			body_array[i].list_properties();


			}	

		}

	}

  if (options_list.atmosphere_defined && options_list.planet_thermal_defined && (options_list.moon_thermal_defined == false)) 
	{
	if (options_list.o2_fraction > 0.0) {planet.atmosphere.add_component("O2", options_list.o2_fraction);}
	if (options_list.co2_fraction > 0.0) {planet.atmosphere.add_component("CO2", options_list.co2_fraction);}
	if (options_list.co_fraction > 0.0) {planet.atmosphere.add_component("CO", options_list.co_fraction);}
	if (options_list.n2_fraction > 0.0) {planet.atmosphere.add_component("N2", options_list.n2_fraction);}
	if (options_list.h2_fraction > 0.0) {planet.atmosphere.add_component("H2", options_list.h2_fraction);}
	if (options_list.cl2_fraction > 0.0) {planet.atmosphere.add_component("Cl2", options_list.cl2_fraction);}
	if (options_list.ar_fraction > 0.0) {planet.atmosphere.add_component("Ar", options_list.ar_fraction);}
	if (options_list.he_fraction > 0.0) {planet.atmosphere.add_component("He", options_list.he_fraction);}
	if (options_list.ne_fraction > 0.0) {planet.atmosphere.add_component("Ne", options_list.ne_fraction);}
	if (options_list.h2o_fraction > 0.0) {planet.atmosphere.add_component("H2O", options_list.h2o_fraction);}
	if (options_list.ch4_fraction > 0.0) {planet.atmosphere.add_component("CH4", options_list.ch4_fraction);}
	if (options_list.nh3_fraction > 0.0) {planet.atmosphere.add_component("NH3", options_list.nh3_fraction);}
	if (options_list.h2s_fraction > 0.0) {planet.atmosphere.add_component("H2S", options_list.h2s_fraction);}
	if (options_list.so2_fraction > 0.0) {planet.atmosphere.add_component("SO2", options_list.so2_fraction);}
	if (options_list.o3_fraction > 0.0) {planet.atmosphere.add_component("O3", options_list.o3_fraction);}
	if (options_list.atmosphere_surface_pressure > 0.0) {planet.atmosphere.set_surface_pressure(options_list.atmosphere_surface_pressure);}
	else {planet.atmosphere.set_surface_pressure(1.0);}
	planet.atmosphere.set_surface_gravity(planet.get_surface_gravity());
	planet.atmosphere.compute_mixture();
	planet.atmosphere.list_properties();
	planet.atmosphere.list_composition();
	planet.compute_IR_retention();
	planet.compute_atmosphere_transport();
	options_list.planet_atmosphere_defined = true;
	}
  else if (options_list.atmosphere_defined && options_list.moon_thermal_defined) 
	{
	if (options_list.o2_fraction > 0.0) {moon.atmosphere.add_component("O2", options_list.o2_fraction);}
	if (options_list.co2_fraction > 0.0) {moon.atmosphere.add_component("CO2", options_list.co2_fraction);}
	if (options_list.co_fraction > 0.0) {moon.atmosphere.add_component("CO", options_list.co_fraction);}
	if (options_list.n2_fraction > 0.0) {moon.atmosphere.add_component("N2", options_list.n2_fraction);}
	if (options_list.h2_fraction > 0.0) {moon.atmosphere.add_component("H2", options_list.h2_fraction);}
	if (options_list.cl2_fraction > 0.0) {moon.atmosphere.add_component("Cl2", options_list.cl2_fraction);}
	if (options_list.ar_fraction > 0.0) {moon.atmosphere.add_component("Ar", options_list.ar_fraction);}
	if (options_list.he_fraction > 0.0) {moon.atmosphere.add_component("He", options_list.he_fraction);}
	if (options_list.ne_fraction > 0.0) {moon.atmosphere.add_component("Ne", options_list.ne_fraction);}
	if (options_list.h2o_fraction > 0.0) {moon.atmosphere.add_component("H2O", options_list.h2o_fraction);}
	if (options_list.ch4_fraction > 0.0) {moon.atmosphere.add_component("CH4", options_list.ch4_fraction);}
	if (options_list.nh3_fraction > 0.0) {moon.atmosphere.add_component("NH3", options_list.nh3_fraction);}
	if (options_list.h2s_fraction > 0.0) {moon.atmosphere.add_component("H2S", options_list.h2s_fraction);}
	if (options_list.so2_fraction > 0.0) {moon.atmosphere.add_component("SO2", options_list.so2_fraction);}
	if (options_list.o3_fraction > 0.0) {moon.atmosphere.add_component("O3", options_list.o3_fraction);}
	if (options_list.atmosphere_surface_pressure > 0.0) {moon.atmosphere.set_surface_pressure(options_list.atmosphere_surface_pressure);}
	else {moon.atmosphere.set_surface_pressure(1.0);}
	moon.atmosphere.set_surface_gravity(moon.get_surface_gravity());
	moon.atmosphere.compute_mixture();
	moon.atmosphere.list_properties();
	moon.atmosphere.list_composition();
	moon.compute_IR_retention();
	moon.compute_atmosphere_transport();
	options_list.moon_atmosphere_defined = true;
	}

  if ((options_list.geology_core_material != "") || (options_list.geology_num_components ==2)) {options_list.geology_defined = true;}

  if (options_list.geology_defined)
	{
	if (options_list.moon_defined)
		{

		if (options_list.geology_core_density > 0.0)
			{moon.geology_override_density(options_list.geology_core_density, "core");}
		if (options_list.geology_inner_mantle_density > 0.0)
			{moon.geology_override_density(options_list.geology_inner_mantle_density, "inner_mantle");}
		if (options_list.geology_outer_mantle_density > 0.0)
			{moon.geology_override_density(options_list.geology_outer_mantle_density, "outer_mantle");}

		if (options_list.depth_profile_defined)
			{moon.set_geo_par("depth_resolution", options_list.depth_profile_resolution);}

		if (options_list.geology_tidal_dissipation_factor != 1.0)
			{moon.set_geo_par("tidal_dissipation", options_list.geology_tidal_dissipation_factor);}

		if (options_list.geology_surface_temperature > 0.0)
			{moon.set_geo_par("surface_temperature", options_list.geology_surface_temperature);}

		if (options_list.geology_differentiated == false)
			{
			moon.init_geology_undifferentiated(options_list.geology_system_age, options_list.geology_isotope_abundancy, planet.get_mass(), options_list.geology_component_1, options_list.geology_component_2);
			}
		else if ((options_list.geology_inner_mantle_material != "") && (options_list.geology_outer_mantle_material != ""))
			{
			moon.init_geology(options_list.geology_system_age, options_list.geology_isotope_abundancy, planet.get_mass(), options_list.geology_core_radius,  options_list.geology_core_material, options_list.geology_inner_mantle_material, options_list.geology_outer_mantle_material);
			}

		else if ((options_list.geology_inner_mantle_material != "") && (options_list.geology_outer_mantle_material == ""))
			{
			moon.init_geology(options_list.geology_system_age, options_list.geology_isotope_abundancy, planet.get_mass(), options_list.geology_core_material, options_list.geology_inner_mantle_material);
			}
		else
			{
			moon.init_geology(options_list.geology_system_age, options_list.geology_isotope_abundancy, planet.get_mass(), options_list.geology_core_material);
			}
		options_list.moon_geology_defined = true;

		}
	else
		{

		if (options_list.geology_core_density > 0.0)
			{planet.geology_override_density(options_list.geology_core_density, "core");}
		if (options_list.geology_inner_mantle_density > 0.0)
			{planet.geology_override_density(options_list.geology_inner_mantle_density, "inner_mantle");}
		if (options_list.geology_outer_mantle_density > 0.0)
			{planet.geology_override_density(options_list.geology_outer_mantle_density, "outer_mantle");}

		if (options_list.depth_profile_defined)
			{planet.set_geo_par("depth_resolution", options_list.depth_profile_resolution);}

		if (options_list.geology_tidal_dissipation_factor != 1.0)
			{planet.set_geo_par("tidal_dissipation", options_list.geology_tidal_dissipation_factor);}

		if (options_list.geology_surface_temperature > 0.0)
			{planet.set_geo_par("surface_temperature", options_list.geology_surface_temperature);}

		if (options_list.geology_differentiated == false)
			{
			planet.init_geology_undifferentiated(options_list.geology_system_age, options_list.geology_isotope_abundancy, central_sun.get_mass(), options_list.geology_component_1, options_list.geology_component_2);
			}
		else if ((options_list.geology_inner_mantle_material != "") && (options_list.geology_outer_mantle_material != ""))
			{
			planet.init_geology(options_list.geology_system_age, options_list.geology_isotope_abundancy, central_sun.get_mass(), options_list.geology_core_radius,  options_list.geology_core_material, options_list.geology_inner_mantle_material, options_list.geology_outer_mantle_material);
			}
		else if ((options_list.geology_inner_mantle_material != "") && (options_list.geology_outer_mantle_material == ""))
			{
			planet.init_geology(options_list.geology_system_age, options_list.geology_isotope_abundancy, central_sun.get_mass(), options_list.geology_core_material, options_list.geology_inner_mantle_material);
			}

		else
			{
			planet.init_geology(options_list.geology_system_age, options_list.geology_isotope_abundancy, central_sun.get_mass(), options_list.geology_core_material);
			}
		options_list.planet_geology_defined = true;
		}

	}

  if (options_list.weather_defined)
	{
	if (options_list.moon_defined)
		{
		moon.init_weather(options_list.weather_random_seed, options_list.circulation_model_preset, options_list.weather_mid_cloudlevel_min, options_list.weather_mid_cloudlevel_max, options_list.weather_high_cloudlevel_min, options_list.weather_high_cloudlevel_max, options_list.weather_precipitation_factor);

		moon.set_weather_par("ridge_migration_factor", options_list.weather_ridge_migration_factor);
		moon.set_weather_par("ridge_suppression_factor", options_list.weather_ridge_suppression_factor);
		moon.set_weather_par("grad_motion_factor", options_list.weather_storm_grad_motion_factor);
		}
	else 
		{
		planet.init_weather(options_list.weather_random_seed, options_list.circulation_model_preset, options_list.weather_mid_cloudlevel_min, options_list.weather_mid_cloudlevel_max, options_list.weather_high_cloudlevel_min, options_list.weather_high_cloudlevel_max, options_list.weather_precipitation_factor);

		planet.set_weather_par("ridge_migration_factor", options_list.weather_ridge_migration_factor);
		planet.set_weather_par("ridge_suppression_factor", options_list.weather_ridge_suppression_factor);
		planet.set_weather_par("grad_motion_factor", options_list.weather_storm_grad_motion_factor);
		}
	}

   if (options_list.relief_defined)
	{



	if (options_list.moon_defined)
		{
		relief.set_general_parameters(options_list.relief_num_lat, options_list.relief_num_lon, options_list.relief_base_scale, options_list.relief_evolution_time, options_list.relief_evolution_timestep, options_list.relief_filename);

		double atmo = 0.0;

		if (options_list.atmosphere_defined) {atmo = options_list.atmosphere_surface_pressure;}

		relief.set_impact_parameters(options_list.relief_impact_rate, options_list.relief_impact_mass_distribution, atmo, moon.get_surface_gravity());

		relief.set_flow_erosion_parameters(options_list.relief_annual_rainfall, options_list.relief_rainfall_var, options_list.relief_evaporation, options_list.relief_bedrock_hardness);
			


		}
	else
		{
		relief.set_general_parameters(options_list.relief_num_lat, options_list.relief_num_lon, options_list.relief_base_scale, options_list.relief_evolution_time, options_list.relief_evolution_timestep, options_list.relief_filename);

		double atmo = 0.0;
		if (options_list.atmosphere_defined) {atmo = options_list.atmosphere_surface_pressure;}

		relief.set_impact_parameters(options_list.relief_impact_rate, options_list.relief_impact_mass_distribution, atmo, planet.get_surface_gravity());

		relief.set_flow_erosion_parameters(options_list.relief_annual_rainfall, options_list.relief_rainfall_var, options_list.relief_evaporation, options_list.relief_bedrock_hardness);


		}

	}



	
  if ((options_list.surface_nlat > 0) && (options_list.surface_nlon > 0))
	{
  	planet.create_surface_elements(options_list.surface_nlat,options_list.surface_nlon );
	if (options_list.materials_file_set){planet.assign_materials_map(options_list.materials_file, materials);}


	if ((options_list.weather_defined) && (options_list.moon_thermal_defined == false))
		{
		if (options_list.weather_snow_albedo != 0.8)
			{
			planet.set_weather_par("snow_albedo", options_list.weather_snow_albedo);
			}
		if (options_list.weather_precipitation_threshold_convection >= 0.0)
			{
			planet.set_weather_par("precipitation_threshold_convection", options_list.weather_precipitation_threshold_convection);
			}
		if (options_list.weather_precipitation_factor_convection >= 0.0)
			{
			planet.set_weather_par("precipitation_factor_convection", options_list.weather_precipitation_factor_convection);
			}
		if (options_list.weather_cloud_factor_convection >= 0.0)
			{
			planet.set_weather_par("cloud_factor_convection", options_list.weather_cloud_factor_convection);
			}
		if (options_list.precipitation_to_T_feedback != 1.0)
			{
			planet.set_weather_par("precipitation_feedback", options_list.precipitation_to_T_feedback);
			}
		if (options_list.cloud_to_T_feedback != 0.0)
			{
			planet.set_weather_par("cloud_feedback", options_list.cloud_to_T_feedback);
			}
		if (options_list.high_cloud_to_T_feedback != 0.0)
			{
			planet.set_weather_par("high_cloud_feedback", options_list.high_cloud_to_T_feedback);
			}
		if (options_list.mid_cloud_to_T_feedback != 0.0)
			{
			planet.set_weather_par("mid_cloud_feedback", options_list.mid_cloud_to_T_feedback);
			}
		if ((options_list.forest_fire_clouds > 0.0) && (options_list.forest_fire_T_min > 0.0) && (options_list.forest_fire_T_max > 0.0))
			{
			options_list.forest_fires = true;
			planet.init_forest_fire_simulation(options_list.forest_fire_clouds, options_list.forest_fire_T_min, options_list.forest_fire_T_max);
			}
		if ((options_list.forest_fire_strato_transfer > 0.0) && (options_list.forest_fires == true))
			{
			planet.set_weather_par("smoke_stratosphere_transfer", options_list.forest_fire_strato_transfer);
			}
		if (options_list.weather_storms){planet.set_weather_par("storms", 1.0);}
		}


	}

  if ((options_list.moon_surface_nlat > 0) && (options_list.moon_surface_nlon > 0) && options_list.moon_thermal_defined)
	{
  	moon.create_surface_elements(options_list.moon_surface_nlat,options_list.moon_surface_nlon );
	if (options_list.moon_materials_file_set){moon.assign_materials_map(options_list.moon_materials_file, materials);}

	if (options_list.weather_defined) 
		{
		if (options_list.weather_snow_albedo != 0.8)
			{
			moon.set_weather_par("snow_albedo", options_list.weather_snow_albedo);
			}
		if (options_list.weather_precipitation_threshold_convection >= 0.0)
			{
			moon.set_weather_par("precipitation_threshold_convection", options_list.weather_precipitation_threshold_convection);
			}
		if (options_list.weather_precipitation_factor_convection >= 0.0)
			{
			moon.set_weather_par("precipitation_factor_convection", options_list.weather_precipitation_factor_convection);
			}
		if (options_list.weather_cloud_factor_convection >= 0.0)
			{
			moon.set_weather_par("cloud_factor_convection", options_list.weather_cloud_factor_convection);
			}
		if (options_list.precipitation_to_T_feedback != 1.0)
			{
			moon.set_weather_par("precipitation_feedback", options_list.precipitation_to_T_feedback);
			}
		if (options_list.cloud_to_T_feedback != 0.0)
			{
			moon.set_weather_par("cloud_feedback", options_list.cloud_to_T_feedback);
			}
		if (options_list.high_cloud_to_T_feedback != 0.0)
			{
			moon.set_weather_par("high_cloud_feedback", options_list.high_cloud_to_T_feedback);
			}
		if (options_list.mid_cloud_to_T_feedback != 0.0)
			{
			moon.set_weather_par("mid_cloud_feedback", options_list.mid_cloud_to_T_feedback);
			}
		if ((options_list.forest_fire_clouds > 0.0) && (options_list.forest_fire_T_min > 0.0) && (options_list.forest_fire_T_max > 0.0))
			{
			options_list.forest_fires = true;
			moon.init_forest_fire_simulation(options_list.forest_fire_clouds, options_list.forest_fire_T_min, options_list.forest_fire_T_max);
			}
		if ((options_list.forest_fire_strato_transfer > 0.0) && (options_list.forest_fires == true))
			{
			moon.set_weather_par("smoke_stratosphere_transfer", options_list.forest_fire_strato_transfer);
			}
		if (options_list.weather_storms){moon.set_weather_par("storms", 1.0);}
		}

	}

  if ((options_list.var_x > 0) && (options_list.var_y > 0) && (options_list.x_max > options_list.x_min))
	{
	options_list.plot_defined = true;
	if ((options_list.plot_int_range_min != -1.1) && (options_list.plot_int_range_max != -1.1))
		{
		options_list.plot_int_range_set = true;
		}
	if (options_list.plot_exclusive_component != "")
		{
		if (options_list.plot_exclusive_component == "o2") {options_list.plot_exclusive_component = "O2";}
		else if (options_list.plot_exclusive_component == "o3") {options_list.plot_exclusive_component = "O3";}
		else if (options_list.plot_exclusive_component == "n2") {options_list.plot_exclusive_component = "N2";}
		else if (options_list.plot_exclusive_component == "co2") {options_list.plot_exclusive_component = "CO2";}
		else if (options_list.plot_exclusive_component == "ch4") {options_list.plot_exclusive_component = "CH4";}
		else if (options_list.plot_exclusive_component == "h2o") {options_list.plot_exclusive_component = "H2O";}
		planet.atmosphere.consider_only_component(options_list.plot_exclusive_component);
		}
	}


  if ((options_list.var_z_surface > 0) && (options_list.surface_nlat > 0) && (options_list.surface_nlon > 0))
	{
	//cout << "Surface plot defined!" << endl;
	options_list.plot_surface_defined = true;
	}


  if ((options_list.record_num_columns > 0) && (options_list.record_n_points > 0) && (options_list.full_evolve == true))
	{
	options_list.record_defined = true;

	//options_list.record_n_points = (int) (options_list.full_evolve_time - options_list.record_delay)/options_list.record_interval;
	options_list.record_interval = (options_list.full_evolve_time - options_list.record_delay)/options_list.record_n_points;
	//cout << "Interval is now: " << options_list.record_interval << endl;
	}

  

  solver.set_GR(options_list.use_gr_corrections);
  solver.set_collisions(options_list.use_collision_finder);
  solver.set_init_apoapsis(options_list.use_apoapsis_init);
  solver.set_retrograde(options_list.companion_retrograde);
  solver.set_moon_retrograde(options_list.moon_retrograde);
  solver.set_apsis_angle(options_list.companion_apsis_angle);
  solver.set_moon_apsis_angle(options_list.moon_apsis_angle);
  }

  else cout << "Unable to open file " << config_file << " !" << endl;


}


void define_material (double albedo, double depth, double CV, string name, bool name_set, int mat_index)
{
//cout << "Defining mat " << mat_index << endl;

if (mat_index == 0) {return;}
else {mat_index = mat_index - 1;}

if ((albedo == 0) || (depth == 0) || (CV == 0))
	{cout << "Incomplete material definition - aborting." << endl; exit(0);}


if (!name_set)
	{name ="Material";}


Material surface_material(albedo, CV, depth, name);

materials[mat_index] = surface_material;
n_materials ++;
}

void set_material_parameter(int index, string par, double value)
{
if (par == "fire_factor")
	{
	materials[index-1].set_fire_factor(value);
	}
else if (par == "convection_factor")
	{
	materials[index-1].set_convection_factor(value);
	}

}


void materials_parser (string config_file)
{
bool name_set = false;
string element, name, key;

double value;
double albedo, depth, CV, fire_factor, convection_factor;

int key_flag = 0; // initially expect a keyword
int mat_counter = -1;

n_materials = 0;

name ="";
albedo = 0.0;
depth = 0.0;
fire_factor = 0.0;
convection_factor = 0.0;
CV = 0.0;

  ifstream cfgfile (config_file.c_str());
  if (cfgfile.is_open())
  {
    while (element !="end")
    {
      cfgfile >> element;
      //cout << element << " " << key_flag << '\n';

      	if (key_flag == 1)
		{
		value = atof (element.c_str());
		}

   	if (key_flag == 0)
		{
		//cout << "parsing key: " << element << endl;
		if (element == "material") 
			{
			mat_counter++; define_material(albedo, depth, CV, name, name_set, mat_counter);
			if (fire_factor > 0.0) {set_material_parameter(mat_counter, "fire_factor", fire_factor); fire_factor = 0.0;}
			if (convection_factor > 0.0) {set_material_parameter(mat_counter, "convection_factor", convection_factor); convection_factor = 0.0;}
			}
		else if (element == "end") 
			{
			mat_counter++; define_material(albedo, depth, CV, name, name_set, mat_counter);
			if (fire_factor > 0.0) {set_material_parameter(mat_counter, "fire_factor", fire_factor); fire_factor = 0.0;}
			if (convection_factor > 0.0) {set_material_parameter(mat_counter, "convection_factor", convection_factor); convection_factor = 0.0;}
			}
		else if (element == "name") {key = element; key_flag = 2;}
		else {key = element; key_flag = 1;}
		}
	else if (key_flag == 1)
		{
		if (key == "albedo") {albedo = value;}
		else if (key == "heat_capacity") {CV = value;}
		else if (key == "depth") {depth = value;}
		else if (key == "fire_factor") {fire_factor = value;}
		else if (key == "convection_factor") {convection_factor = value;}
		key_flag = 0;
		}
	else if (key_flag == 2)
		{
		if (key == "name") {name = element; name_set = true; }
		key_flag = 0;
		}
    }
    cfgfile.close();
  }
  else cout << "Unable to open file " << config_file << " !" << endl;

}


