// options.hxx -- hash to store the parsed configuration options 
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

class Options {
	public:
	  //star and companion star options
	  bool star_defined;
	  bool companion_defined;
	  bool star_name_set;
	  bool companion_name_set;
	  bool companion_retrograde;
	  bool binary_name_set;
	  bool binary_defined;
	  bool binary_retrograde;
	  double star_mass;
	  double star_temperature;
	  double star_luminosity;
	  double star_radius;
	  double companion_mass;
	  double companion_temperature;
	  double companion_luminosity;
	  double companion_radius;
	  double companion_apsis_angle;
	  double binary_mass;
	  double binary_temperature;
	  double binary_luminosity;
	  double binary_radius;
	  double binary_apsis_angle;	  
	  string star_name;
	  string companion_name;
	  string binary_name;

	
	  //planet options
	  bool planet_name_set;
	  bool planet_defined;
	  bool planet_rotation_defined;
	  bool planet_orbit_defined;
	  bool planet_orbit_longyear_defined;
	  bool planet_orbit_binary_defined;
	  bool planet_thermal_defined;
	  bool planet_atmosphere_defined;
	  bool planet_geology_defined;
	  bool planet_lagrange_orbit;
	  bool planet_lagrange_leading;
	  double planet_mass;
	  double planet_radius;
	  double planet_inc;
	  double planet_inc_of_companion;
	  double planet_lan_of_companion;
	  double planet_inc_of_binary;
	  double planet_lan_of_binary;
	  double planet_dec_offset;
	  double planet_rot_period;
	  double planet_sid_rot_period;
	  double planet_semimajor;
	  double planet_eccentricity;
	  double planet_semimajor_longyear;
	  double planet_eccentricity_longyear;
	  double planet_semimajor_binary;
	  double planet_eccentricity_binary;
	  double planet_mean_albedo;
	  double planet_mean_heat_capacity;
	  double planet_mean_diurnal_depth;
	  double planet_max_diurnal_depth;
	  double planet_internal_heat;
	  double planet_T_init;
	  double planet_L_dphi;
	  double planet_L_dR;
	  double planet_L_dz;
	  double planet_L_dvR;
	  double planet_L_dvT;
	  double planet_L_dvz;
	  string planet_name;

	  //moon options
	  bool moon_name_set;
	  bool moon_defined;
	  bool moon_rotation_defined;
	  bool moon_orbit_defined;
	  bool moon_thermal_defined;
	  bool moon_atmosphere_defined;
	  bool moon_geology_defined;
	  bool moon_retrograde;
	  bool moon_lagrange_orbit;
	  bool moon_lagrange_leading;
	  double moon_mass;
	  double moon_radius;
	  double moon_inc;
	  double moon_inc_of_planet;
	  double moon_lan_of_planet;
	  double moon_dec_offset;
	  double moon_rot_period;
	  double moon_sid_rot_period;
	  double moon_semimajor;
	  double moon_eccentricity;
	  double moon_apsis_angle;
	  double moon_mean_albedo;
	  double moon_mean_heat_capacity;
	  double moon_mean_diurnal_depth;
	  double moon_max_diurnal_depth;
	  double moon_internal_heat;
	  double moon_T_init;
	  double moon_L_dphi;
	  double moon_L_dR;
	  double moon_L_dz;
	  double moon_L_dvR;
	  double moon_L_dvT;
	  double moon_L_dvz;
	  string moon_name;

	  //additional gravitating bodies
	  bool bodies_defined;
	  int num_bodies;
	  string body_attach_to[15];
	  string body_name[15];
	  double body_semimajor[15];
	  double body_semimajor_min[15];
	  double body_semimajor_max[15];
	  double body_eccentricity[15];
	  double body_eccentricity_min[15];
	  double body_eccentricity_max[15];
	  double body_apsis_angle[15];
	  double body_apsis_angle_min[15];
	  double body_apsis_angle_max[15];
	  double body_inclination[15];
	  double body_lan[15];
	  double body_mass[15];
	  double body_radius[15];
	  double body_distance[15];

	  //planet surface elements
	  int surface_nlat;
	  int surface_nlon;

	  //moon surface elements
	  int moon_surface_nlat;
	  int moon_surface_nlon;

	  //planetary atmosphere
	  double atmosphere_IR_blocking;
	  double atmosphere_transport_coeff;
	  double atmosphere_albedo;

	  //planetary hydrosphere
	  double hydrosphere_transport_coeff;
	  double hydrosphere_ice_factor;

	  //moon atmosphere
	  double moon_atmosphere_IR_blocking;
	  double moon_atmosphere_transport_coeff;
	  double moon_atmosphere_albedo;

	  //moon hydrosphere
	  double moon_hydrosphere_transport_coeff;
	  double moon_hydrosphere_ice_factor;

	  //planetary weather
	  bool weather_defined;
	  bool weather_storms;
	  int weather_random_seed;
	  int circulation_model_preset;
	  double weather_mid_cloudlevel_min;
	  double weather_mid_cloudlevel_max;
	  double weather_high_cloudlevel_min;
	  double weather_high_cloudlevel_max;
	  double weather_precipitation_factor;
	  double weather_snow_albedo;
	  double weather_ridge_migration_factor;
	  double weather_ridge_suppression_factor;
	  double weather_precipitation_threshold_convection;
	  double weather_precipitation_factor_convection;
	  double weather_cloud_factor_convection;
	  double weather_storm_grad_motion_factor;

	  //planetary geology
	  bool geology_defined;
	  bool geology_differentiated;
	  int geology_num_components;
	  double geology_system_age;
	  double geology_isotope_abundancy;
	  double geology_core_radius;
	  double geology_core_density;
	  double geology_inner_mantle_density;
	  double geology_outer_mantle_density;
	  double geology_tidal_dissipation_factor;
	  double geology_surface_temperature;
	  string geology_inner_mantle_material;
	  string geology_outer_mantle_material;
	  string geology_core_material;
	  string geology_component_1;
	  string geology_component_2;

	  //terrain relief
	  bool relief_defined;
	  int relief_num_lon;
	  int relief_num_lat;
	  double relief_base_scale;
	  double relief_annual_rainfall;
	  double relief_rainfall_var;
	  double relief_evaporation;
	  double relief_bedrock_hardness;
	  double relief_evolution_time;
	  double relief_evolution_timestep;
	  double relief_impact_rate;
	  double relief_impact_mass_distribution;
	  string relief_filename;
	  string relief_initial_heightfield_filename;

	  //detailed atmosphere composition
	  bool atmosphere_defined;
	  double co2_fraction;
	  double o2_fraction;
	  double n2_fraction;
	  double h2_fraction;
	  double cl2_fraction;
	  double ar_fraction;
	  double ne_fraction;
	  double h2o_fraction;
	  double ch4_fraction;
	  double o3_fraction;
	  double he_fraction;
	  double co_fraction;
	  double nh3_fraction;
	  double h2s_fraction;
	  double so2_fraction;
	  double atmosphere_surface_pressure;


	  //feedback_loops
	  bool forest_fires;
	  double forest_fire_clouds;
	  double forest_fire_T_min;
	  double forest_fire_T_max;
	  double forest_fire_strato_transfer;
	  double cloud_to_T_feedback;
	  double mid_cloud_to_T_feedback;
	  double high_cloud_to_T_feedback;
	  double precipitation_to_T_feedback;

	  //evolution options
	  bool orbit_evolve;
	  bool thermal_evolve;
	  bool full_evolve;
	  bool orbit_resume_flag;
	  bool orbit_save_flag;
	  double orbit_evolve_time;
	  double orbit_evolve_time_op;
	  double orbit_evolve_timestep;
	  double orbit_state_x;
	  double orbit_state_y;
	  double orbit_state_vx;
	  double orbit_state_vy;
	  double orbit_day_fraction;
	  double thermal_evolve_time;
	  double full_evolve_time;
	  double full_evolve_time_op;
	  double full_evolve_timestep;
	  string orbit_filename;

	  //plot options
	  bool plot_defined;
	  bool plot_filename_defined;
	  bool plot_int_range_set;
	  int var_x;
	  int var_y;
	  int n_points;
	  int plot_body_index;
	  int plot_star_index;
	  double x_min;
	  double x_max;
	  double par_1;
	  double par_2;
	  double plot_int_range_min;
	  double plot_int_range_max;
	  double plot_x_range_factor;
	  string plot_filename;
	  string plot_body;
	  string plot_exclusive_component;

	  // orbital plot options
	  bool plot_orbit_defined;
	  bool plot_orbit_filename_defined;
	  bool plot_orbit_relative;
	  bool plot_orbit_3d;
	  int n_points_orbit;
	  int plot_orbit_body_index;
	  int plot_orbit_ref_index;
 	  double plot_orbit_timeframe;
	  string plot_orbit_filename;
	  string plot_orbit_reference;
	  string plot_orbit_body;


	  //surface plot options
	  bool plot_surface_defined;
	  bool plot_surface_filename_defined;
	  int var_z_surface;
	  int plot_surface_body_index;
	  double z_min_surface;
	  double z_max_surface;
	  string plot_surface_filename;
	  string plot_surface_body;

	  // config options
	  bool materials_file_set;
	  string materials_file;
	  bool moon_materials_file_set;
	  string moon_materials_file;
	  double orbital_sim_timestep;
	  bool use_gr_corrections;
	  bool use_apoapsis_init;
	  bool use_eclipse_finder;
	  bool use_collision_finder;
	  bool use_eclipse_verbose;
	  bool use_indirect_irradiation;
	  int random_seed;

	  // recording options
	  bool record_defined;
	  bool record_filename_defined;
	  bool record_global;
	  int record_num_columns;
	  int record_n_points;
	  int record_var_y[10];
	  int record_index_x;
	  int record_index_y;
	  int record_ref_index;
	  int record_body_index;
	  double record_delay;
	  double record_delay_op;
	  double record_interval;
	  double record_x_format_factor;
	  string record_filename;

	  // scatter plot options
	  bool scatter_plot_defined;
	  bool scatter_filename_defined;
	  bool scatter_filters_defined;
	  double scatter_delay;
	  double scatter_delay_op;
	  double scatter_interval;
	  double scatter_filter_high;
	  double scatter_filter_low;
	  int scatter_type;
	  string scatter_filename;

	  //orbital summary report options
	  bool report_orbit_defined;
	  int report_orbit_num_src;
	  int report_orbit_num_var;
	  string report_orbit_reference;
	  string report_orbit_variable[10];
	  string report_orbit_source[15];

	  //geology depth profile
	  bool depth_profile_defined;
	  double depth_profile_resolution;

	  // consistency check options
	  bool consistency_checks;
  	  bool roche_check;
	  bool hill_sphere_check;
	  bool atmosphere_phase_check;
	  bool tidal_locking_check;

};
