// material.hxx -- class containing properties of planetary surface materials
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

class Material {
	public:
	  double albedo;
	  double C_V;
	  double depth_diurnal_norm;
	  double fire_factor;
	  double moisture_factor;
	  double convection_factor;
	  bool liquid;
	  std::string designation;
	  bool designation_set;
	  Material(double, double, double);
	  Material(void);
	  Material(double, double, double, std::string);


	  void set_fire_factor(double);
	  void set_convection_factor(double);
	  void list_properties(void);

	friend class Planet;
};

