// material.cxx -- class containing properties of planetary surface materials
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <iostream>
#include <fstream>
#include <string>
#include <stdlib.h>

#include "material.hxx"

using namespace std;

Material::Material(double set_albedo, double set_CV, double set_V)
{
albedo = set_albedo;
C_V = set_CV;
depth_diurnal_norm = set_V;
designation="Material";
fire_factor = 0.0;
liquid = false;
moisture_factor = 0.0;
convection_factor = 1.0;
}

Material::Material(double set_albedo, double set_CV, double set_V, string name)
{
albedo = set_albedo;
C_V = set_CV;
depth_diurnal_norm = set_V;
designation = name;
fire_factor = 0.0;
liquid = false;
moisture_factor = 0.0;
convection_factor = 1.0;
}

Material::Material(void)
{
albedo = 0.0;
C_V = 0.0;
depth_diurnal_norm = 0.0;
designation = "void";
fire_factor = 0.0;
liquid = false;
moisture_factor = 0.0;
convection_factor = 1.0;
}

void Material::set_fire_factor(double value)
{
fire_factor = value;
//cout << "Fire factor for " << designation << " is now: " << fire_factor << endl;
}

void Material::set_convection_factor(double value)
{
convection_factor = value;
}

void Material::list_properties()
{
cout << designation << endl;
cout << "Albedo:                " << albedo << endl;
cout << "Heat capacity: [J/gK]: " << C_V << endl;
cout << "Normalized depth [m]:  " << depth_diurnal_norm << endl;
cout << "Forest fire factor:    " << fire_factor;
cout << "Moisture factor:       " << moisture_factor;
}
