// gases.hxx -- a collection of gas properties
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


class Gases {
	  int n_linedata_CO2;
	  double line_array_CO2[100][2];

	  int n_linedata_H2O;
	  double line_array_H2O[100][2];

	  int n_linedata_CH4;
	  double line_array_CH4[100][2];

	  int n_linedata_O3;
	  double line_array_O3[100][2];

	  int n_linedata_O3_uv;
	  double line_array_O3_uv[100][2];

	  int n_linedata_O2_uv;
	  double line_array_O2_uv[100][2];

	  int n_linedata_N2_uv;
	  double line_array_N2_uv[100][2];

	  int n_linedata_CO2_uv;
	  double line_array_CO2_uv[100][2];

	  int n_linedata_SO2_uv;
	  double line_array_SO2_uv[100][2];

	  int n_linedata_H2_uv;
	  double line_array_H2_uv[100][2];

	  int n_linedata_NH3_uv;
	  double line_array_NH3_uv[100][2];
	  double lineshape_NH3_uv(double lambda);

	  std::string exclusive_component;

	  int n_phasedata_sat_N2;
	  double phasedata_sat_N2[20][2];

	  int n_phasedata_melt_N2;
	  double phasedata_melt_N2[20][2];

	  int n_phasedata_sat_O2;
	  double phasedata_sat_O2[20][2];

	  int n_phasedata_melt_O2;
	  double phasedata_melt_O2[20][2];

	  int n_phasedata_sat_CO2;
	  double phasedata_sat_CO2[20][2];

	  int n_phasedata_melt_CO2;
	  double phasedata_melt_CO2[20][2];

	  int n_phasedata_sat_CH4;
	  double phasedata_sat_CH4[20][2];

	  int n_phasedata_melt_CH4;
	  double phasedata_melt_CH4[20][2];

	  int n_phasedata_sat_Ar;
	  double phasedata_sat_Ar[20][2];

	  int n_phasedata_melt_Ar;
	  double phasedata_melt_Ar[20][2];

	  int n_phasedata_sat_H2O;
	  double phasedata_sat_H2O[20][2];

	  int n_phasedata_melt_H2O;
	  double phasedata_melt_H2O[20][2];
	  
	  int n_phasedata_sat_NH3;
	  double phasedata_sat_NH3[20][2];

	  int n_phasedata_melt_NH3;
	  double phasedata_melt_NH3[20][2];

	  int n_phasedata_sat_SO2;
	  double phasedata_sat_SO2[20][2];

	  int n_phasedata_melt_SO2;
	  double phasedata_melt_SO2[20][2];

	  int n_phasedata_sat_Ne;
	  double phasedata_sat_Ne[20][2];

	  int n_phasedata_melt_Ne;
	  double phasedata_melt_Ne[20][2];

	  int n_phasedata_sat_H2;
	  double phasedata_sat_H2[20][2];

	  int n_phasedata_melt_H2;
	  double phasedata_melt_H2[20][2];

	  int n_phasedata_sat_H2S;
	  double phasedata_sat_H2S[20][2];

	  int n_phasedata_melt_H2S;
	  double phasedata_melt_H2S[20][2];

	public:
	  double get_molecular_weight(std::string name);
	  double get_melting_point(std::string name);
	  double get_boiling_point(std::string name);
	  double get_c_p(std::string name);
	  double get_R(std::string name);
	  double lineshape(double lambda, std::string name);
	  double lineshape_uv(double lambda, std::string name);
	
	  void set_exclusive(std::string name) {exclusive_component = name;}

	  int get_phase(double, double, std::string name);

	  Gases ();
	
};
