// body.hxx -- routines to assign and compute properties of otherwise undefined gravitating bodies
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

class Body {

	int ref_index;
	
	bool hyperbolic_trajectory;

	double mass_earth;
	double mass;
	double radius_earth;
	double radius;
	double density;
	double surface_gravity;
	double semimajor;
	double eccentricity;
	double inclination;
	double lan;
	double apsis_angle;
	double apoapsis;
	double periapsis;
	double speed_periapsis;
	double speed_apoapsis;
	double speed_initial;
	double speed_hyperbolic_excess;
	double speed_esc;
	double period;
	double central_mass;
	double distance;
	double flight_path_angle;

	std::string designation;
	std::string central_body;

	double rnd(double, double);

	

	public:

	void assign_properties(double, double, double, double, double, double, double);
	void assign_properties(double, double, double, double, double, double, double, double);
	void set_random(std::string, double, double);
	void set_central_mass(double);
	void set_name(std::string);
	void set_central_body(std::string);
	void set_ref_index(int);
	void set_random_seed(int);

	void list_properties();

	double get_mass();
	double get_radius();
	double get_periapsis();
	double get_apoapsis();
	double get_speed_apoapsis();
	double get_speed_periapsis();
	double get_apsis_angle();
	double get_inclination();
	double get_lan();
	double get_initial_velocity();
	double get_flight_path_angle();
	double get_distance();


	int get_ref_index();

	std::string get_designation();
	std::string get_central_body();

	bool get_hyperbolic_trajectory();

};
