
// atmosphere.hxx -- routines to define and compute atmosphere properties
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include "gases.hxx"

class Component {
	public: 
	  std::string name;
	  double fraction;
	  double mass_fraction;
	  double molecular_weight;  
	  double c_p;
};


class Atmosphere {
	  int n_components;
	  double infrared_blocking;
	  double transport_coeff;
	  double albedo;
	  double mean_molecular_weight;
	  double mean_c_p;
	  double scale_height;
	  double adiabatic_lapse_rate;
	  double mean_surface_temperature;
	  double min_surface_temperature;
	  double mean_radiative_temperature;
	  double surface_pressure;
	  double column_mass;
	  double surface_gravity;
	  Component components[10];
	  Gases gas_properties;

	  std::string exclusive_component;

	  double* atmosphere_O3_profile;

	  double compute_chapman_function(int, double);
	  double compute_chapman_function(int, double, double);

	public:
	  double get_infrared_blocking (void) {return infrared_blocking;}
	  void set_infrared_blocking (double set_value) {infrared_blocking = set_value;}
	  double get_transport_coeff (void) {return transport_coeff;}
	  double get_column_mass (void) {return column_mass;}
	  double get_scale_height(void) {return scale_height;}
	  double get_lapse_rate(void) {return adiabatic_lapse_rate;}
	  double get_albedo(void) {return albedo;}
	  double get_transmission (double);
	  double get_transmission (double, double);
	  double get_uv_transmission(double);
	  double get_uv_transmission(double, double);
	  double get_surface_pressure();
	  double get_cp();
	  double get_absorption_by_altitude (double lambda, double altitude, double delta_alt);
	  void set_transport_coeff (double set_value) {transport_coeff = set_value;}
	  void set_albedo (double set_value) {albedo = set_value;}
	  void set_mean_surface_temperature (double set_value) {mean_surface_temperature = set_value;}
	  void set_minimum_surface_temperature (double set_value) {min_surface_temperature = set_value;}
	  void set_mean_radiative_temperature (double set_value) {mean_radiative_temperature = set_value;}
	  void set_surface_gravity (double set_value) {surface_gravity = set_value;}
	  void set_surface_pressure (double);
	  void add_component (std::string, double fraction);
	  void consider_only_component(std::string name) {exclusive_component = name; gas_properties.set_exclusive(name); }
	  void compute_mixture(void);
	  void check_phases(void);
	  void init_ozone_profile(int);
	  void list_composition(void);
	  void list_properties(void);

	  double* compute_chapman_heating_profile(int, double, double);
	  double* compute_chapman_o3_profile(int, double, double);
};
