// units.hxx -- routines to manage unit conversion
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef UNITS_H
#define UNITS_H

#include <string>

class Units {

	long double conversion_factor_length_in;
	long double conversion_factor_length_out;
	long double conversion_factor_mass_in;
	long double conversion_factor_mass_out;
	long double conversion_factor_force_in;
	long double conversion_factor_force_out;
	std::string km_nm;
	std::string m_ft;
	std::string kg_lb;

	int input_unit_system;
	int output_unit_system;

	public:

	
	void set_units (int flag);
 	long double convert_length_input (long double input);
 	long double convert_length_output (long double output);
		
	long double convert_km_nm_input(long double input);
	long double convert_km_nm_output(long double output);

	long double convert_mass_input(long double input);
	long double convert_mass_output(long double output);

	long double convert_force_input(long double input);
	long double convert_force_output(long double output);

	long double parse_time(std::string timestring);

	std::string get_km_nm();
	std::string get_m_ft_s();
	std::string get_m_ft();
	std::string get_kg_lb();
	std::string get_N_lb();
	std::string assemble_timestring(long double time);

};


#endif
