// units.cxx -- routines to manage unit conversion
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#include <iostream>
#include <stdlib.h>
#include <math.h>

#include "units.hxx"

using namespace std;


void Units::set_units (int flag)
{
string unit_designation;



if (flag == 0)
	{
	conversion_factor_length_in = 1.0;
	conversion_factor_length_out = 1.0;
	conversion_factor_mass_in = 1.0;
	conversion_factor_mass_out = 1.0;
	conversion_factor_force_in = 1.0;
	conversion_factor_force_out = 1.0;
	unit_designation = "SI";
	input_unit_system = 0;
	output_unit_system = 0;
	}
else if (flag == 1)
	{
	conversion_factor_length_in = 0.3048;
	conversion_factor_length_out = 1.0/ conversion_factor_length_in;
	conversion_factor_mass_in = 0.45359237;
	conversion_factor_mass_out = 1.0/conversion_factor_mass_in;
	conversion_factor_force_in = 4.448221615;
	conversion_factor_force_out = 1.0/conversion_factor_force_in;
	unit_designation = "imperial";
	input_unit_system = 1;
	output_unit_system = 1;
	}

cout << "Using " << unit_designation << " units." << endl;

}

long double Units::convert_length_input (long double input)
{

return conversion_factor_length_in * input;

}

long double Units::convert_length_output (long double output)
{

return conversion_factor_length_out * output;

}


long double Units::convert_mass_input (long double input)
{
return conversion_factor_mass_in * input;
}

long double Units::convert_mass_output (long double output)
{
return conversion_factor_mass_out * output;
}

long double Units::convert_force_input (long double input)
{
return conversion_factor_force_in * input;
}

long double Units::convert_force_output (long double output)
{
return conversion_factor_force_out * output;
}

long double Units::convert_km_nm_output(long double output)
{
if (output_unit_system == 0)
	{return output/1000.0;}
else
	{return output/1852.0;}
}

long double Units::convert_km_nm_input(long double input)
{
if (input_unit_system == 0)
	{return input * 1000.0;}
else
	{return input * 1852.0;}
}

string Units::get_km_nm ()
{
if (output_unit_system == 0) {return "km";}
else {return "nm";}

}

string Units::get_kg_lb ()
{
if (output_unit_system == 0) {return "kg";}
else {return "lb";}

}

string Units::get_N_lb ()
{
if (output_unit_system == 0) {return "N";}
else {return "lb";}

}

string Units::get_m_ft ()
{
if (output_unit_system == 0) {return "m";}
else {return "ft";}

}

string Units::get_m_ft_s ()
{
if (output_unit_system == 0) {return "m/s";}
else {return "ft/s";}

}

long double Units::parse_time(string timestring)
{

int tenth = 0;

int day = (int)(timestring.at(0) - '0') * 100 + (int)(timestring.at(1)- '0' ) * 10 + (int)(timestring.at(2)- '0');  

int hour =  (int)(timestring.at(4)- '0') * 10 + (int)(timestring.at(5)- '0');
int minute =  (int)(timestring.at(7)- '0') * 10 + (int)(timestring.at(8)- '0');
int second =  (int)(timestring.at(10)- '0') * 10 + (int)(timestring.at(11)- '0');    



if (timestring.length() > 12)
	{
	tenth = (int)(timestring.at(13)- '0');
	}

return 86400.0 * day + 3600.0 * hour + 60.0 * minute + second + 0.1 * tenth;

}


string Units::assemble_timestring(long double time)
{
string outstring;

int days = (int) time/86400.0;
time -= days * 86400.0;


outstring.push_back('0' + (int)(days / 100));
days = days % 100;
outstring.push_back('0' + (days / 10));
days = days % 10;
outstring.push_back('0' + days);
outstring.push_back('/');

int hours = (int) time/3600.0;
time -= hours * 3600.0;

outstring.push_back('0' + (hours / 10));
hours = hours % 10;
outstring.push_back('0' + hours);
outstring.push_back(':');

int minutes = (int) time/60.0;
time -= minutes * 60.0;

outstring.push_back('0' + (minutes / 10));
minutes = minutes % 10;
outstring.push_back('0' + minutes);
outstring.push_back(':');

int seconds = (int) time;
time -= seconds * 1.0;

outstring.push_back('0' + (seconds / 10));
seconds = seconds % 10;
outstring.push_back('0' + seconds);

if (time != 0.0)
	{
	int tenth = (int) (time/0.1);
	if (tenth > 0)
		{
		outstring.push_back('.');
		outstring.push_back('0' + tenth);
		}
	}

return outstring;
}
