// site.hxx -- routines to compute ground site spherical trigonometry
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#ifndef SITE_H
#define SITE_H

#include <string>




class Site {

	long double lat;
	long double lon;

	long double unit_x;
	long double unit_y;
	long double unit_z;

	long double unit_vx;
	long double unit_vy;
	long double unit_vz;

	bool defined_flag;	

	std::string name;
	
	public:

	void init (long double lat, long double lon, std::string name);
	void init_by_name (std::string name);
	void apply_course_distance(long double course, long double distance);
	void set_launch_site(long double met, long double s_lat, long double s_lon);

	long double get_lat();
	long double get_lon();

	long double get_unit_x();
	long double get_unit_y();
	long double get_unit_z();

	long double get_unit_vx();
	long double get_unit_vy();
	long double get_unit_vz();

	long double distance_from(long double lat, long double lon);
	long double bearing_from(long double lat, long double lon);
	bool is_defined();
	bool is_known(std::string name);

};




#endif
