// rendezvous_target.hxx -- routines to forward a spacecraft state vector
// and obtain its properties
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301




#include <string>

#include "units.hxx"
#include "options.hxx"
#include "celestial_body.hxx"


class RendezvousTarget {
	long double x;
	long double y;
	long double z;

	long double vx;
	long double vy;
	long double vz;

	long double stored_x;
	long double stored_y;
	long double stored_z;

	long double stored_vx;
	long double stored_vy;
	long double stored_vz;

	long double semi_major;
	long double orbital_period;

	long double stored_earth_rotation_angle;

	long double gx;
	long double gy;
	long double gz;

	long double dt;

	long double earth_rotation_angle;


	int gravity_model;
	int earth_model;
	int num_bodies;

	void compute_gravity();
	void compute_earth_rotation();
	void compute_elements();

	double get_latitude_rad();
	long double get_bearing(long double lat2, long double lon2);
	long double get_ang_distance(long double lat2, long double lon2);
	long double get_delta_crosstrack(long double lat2, long double lon2, long double course2);


	long double earth_radius();

	CelestialBody body_array[5];


	public:

	void init (Options options);
	void set_pos(long double x, long double y, long double z);
	void set_vel(long double vx, long double vy, long double vz);

	void store();
	void reset();

	void do_timestep();

	double get_lon();
	double get_lat();
	double get_alt();
	double get_x();
	double get_y();
	double get_z();
	double get_vx();
	double get_vy();
	double get_vz();
	double get_prox_x (long double x, long double y, long double z, long double vx, long double vy, long double vz);
	double get_prox_y (long double x, long double y, long double z, long double vx, long double vy, long double vz);
	double get_prox_z (long double x, long double y, long double z, long double vx, long double vy, long double vz);
	double get_prox_vx (long double x, long double y, long double z, long double vx, long double vy, long double vz);
	double get_prox_vy (long double x, long double y, long double z, long double vx, long double vy, long double vz);
	double get_prox_vz (long double x, long double y, long double z, long double vx, long double vy, long double vz);
	double get_prox_x (long double lat, long double lon, long double course);
	double get_prox_y (long double lat, long double lon, long double course);
	double get_orbital_period();

};
