
// plot.cxx - routines to create plot format output
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <iostream>
#include <iomanip>
#include <fstream>
#include <stdlib.h>
#include <string>

using namespace std;

#include "plot.hxx"



void PlotTools::plot2d (double x[], double y[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;
	resfile << setprecision(12) ;
	resfile << x[i] << " " << y[i]  << endl;
	}


    resfile.close();
    cout << "2d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}

void PlotTools::plot3d (double x[], double y[], double z[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;
	resfile << setprecision(12) ;
	resfile << x[i] << " " << y[i]  << " " << z[i] << endl;
	}


    resfile.close();
    cout << "3d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}
