void file_parser (string config_file)
{


string element, mode, block, name, key;
double value;

int key_flag = 0;

options.state_vector_vx = -1.0;
options.state_vector_vy = -1.0;
options.state_vector_vz = -1.0;

options.state_vector_x = -1.0;
options.state_vector_x = -1.0;
options.state_vector_x = -1.0;

options.position_lat = 0.0;
options.position_lon = 0.0;
options.position_alt = 150000.0;
options.position_heading = 90.0;
options.position_vup = 0.0;
options.position_vtot = 7800.0;
options.position_set = false;

options.initial_met = 0.0;

options.timestep = 0.01;

options.plot2d_filename = "plot_2d.dat";

options.plot2d_x_option = 0;
options.plot2d_y_option = 1;

options.plot3d_filename = "plot_3d.dat";

options.plot3d_x_option = 0;
options.plot3d_y_option = 1;
options.plot3d_z_option = 2;

options.state_vector_position_defined = 0;
options.state_vector_velocity_defined = 0;
options.state_vector_valid = 0;

options.unit_flag = 0;
options.time_format_flag = 0;
options.gravity_model = 0;
options.earth_model = 0;
options.burn_model = 0;

options.max_time = 8000.0;

options.num_burns = 0;

options.landing_site_set = false;
options.launch_site_set = false;

options.plot2d_flag = false;
options.plot2d_resolution = 500;

options.plot3d_flag = false;
options.plot3d_resolution = 500;

options.fit_log = false;

options.fit_max_iterations = 100;

options.list_initial_sv = false;
options.list_final_sv = false;
options.list_initial_orbital = false;
options.list_final_orbital = false;
options.list_initial_pos = false;
options.list_final_pos = false;
options.list_ei_sv = false;
options.list_ei_orbital = false;
options.list_ei_pos = false;
options.list_initial_bodies = false;
options.list_final_bodies = false;


options.craft_acceleration = 0.469076747839749;
options.craft_mass = 0.0;
options.craft_mass_propellant = 0.0;
options.craft_mass_dry = 0.0;
options.craft_thrust = 0.0;
options.craft_isp = 0.0;
options.craft_defined = false;
options.craft_acceleration_defined = false;

options.num_bodies = 0;

for (int i=0; i< 10; i++)
	{
	options.burn_trig_in_plane[i] = true;
	options.burn_lambert_offset_x[i] = 0;
	options.burn_lambert_offset_y[i] = 0;
	options.burn_lambert_offset_z[i] = 0;
	options.burn_lambert_fit_y[i] = true;
	options.burn_lambert_automatic_burn2[i] = true;
	}


options.target_flag = 0;
options.tgt_position_set = false;

options.tgt_vx = -1.0;
options.tgt_vy = -1.0;
options.tgt_vz = -1.0;

options.tgt_x = -1.0;
options.tgt_x = -1.0;
options.tgt_x = -1.0;

options.tgt_gravity_model = -1;



block = "void";



  ifstream cfgfile (config_file.c_str());
  if (cfgfile.is_open())
  {
    while (element !="end")
    {
      cfgfile >> element;



      //cout << element << " " << key_flag << endl;

      	if (key_flag == 1)
		{
		//cout << "reading value: " << element << endl;
		value = atof (element.c_str());
		}

   	if (key_flag == 0)
		{
		//cout << "Key flag is 0" << endl;


 		if (element == "units") {key = "units"; key_flag = 2;}
		else if (element == "gravity_model") {key = "gravity_model"; key_flag = 2;}
		else if (element == "earth_model") {key = "earth_model"; key_flag = 2;}
		else if (element == "burn_model") {key = "burn_model"; key_flag = 2;}
		else if (element == "time_format") {key = "time_format"; key_flag = 2;}
		else if (element == "fit") {key = "fit"; key_flag = 2;}
		else if (element == "met") {key = "met"; key_flag = 2;}
		else if ((element == "file") && (block == "plot2d")) {key = "file"; key_flag = 2; options.plot2d_flag = true;}
		else if ((element == "x") && (block == "plot2d")) {key = "x"; key_flag = 2;}
		else if ((element == "y") && (block == "plot2d")) {key = "y"; key_flag = 2;}
		else if ((element == "file") && (block == "plot3d")) {key = "file"; key_flag = 2; options.plot3d_flag = true;}
		else if ((element == "x") && (block == "plot3d")) {key = "x"; key_flag = 2;}
		else if ((element == "y") && (block == "plot3d")) {key = "y"; key_flag = 2;}
		else if ((element == "z") && (block == "plot3d")) {key = "z"; key_flag = 2;}
		else if ((element == "name") && (block == "burn_peg7")) {key = "name"; key_flag = 2;}
		else if ((element == "name") && (block == "burn_peg4")) {key = "name"; key_flag = 2;}
		else if ((element == "name") && (block == "burn_low_thrust")) {key = "name"; key_flag = 2;}
		else if ((element == "name") && (block == "burn_lambert")) {key = "name"; key_flag = 2;}
		else if ((element == "name") && (block == "celestial_body")) {key = "name"; key_flag = 2;}
		else if ((element == "trig_in_plane") && (block == "burn_low_thrust")) {key = "trig_in_plane"; key_flag = 2;}
		else if (((element == "tig") || (element == "TIG")) && (block == "burn_peg7")) {key = "tig"; key_flag = 2;}
		else if (((element == "tig") || (element == "TIG")) && (block == "burn_peg4")) {key = "tig"; key_flag = 2;}
		else if (((element == "tig") || (element == "TIG")) && (block == "burn_low_thrust")) {key = "tig"; key_flag = 2;}
		else if (((element == "tig") || (element == "TIG") || (element == "tig1")) && (block == "burn_lambert")) {key = "tig"; key_flag = 2;}
		else if ((element == "optimize") && (block == "burn_peg4")) {key = "optimize"; key_flag = 2;}
		else if ((element == "disable") && (block == "burn_lambert")) {key = "disable"; key_flag = 2;}
		else if ((element == "name") && (block == "landing_site")) {key = "name"; key_flag = 2;}
		else if ((element == "name") && (block == "launch_site")) {key = "name"; key_flag = 2;}
		else if (element == "input") {mode = "input"; block = "void";}
		else if (element == "output") {mode = "output"; block = "void";}
		else if ((element == "state_vector") && (mode == "input")) { block = "state_vector";}
		else if ((element == "target_state_vector") && (mode == "input")) { block = "target_state_vector"; options.target_flag = 1;}
		else if ((element == "target_position") && (mode == "input")) 
			{ block = "target_position"; options.tgt_position_set = true; options.target_flag = 1;}
		else if (element == "landing_site") {block = "landing_site"; options.landing_site_set = true;}
		else if (element == "launch_site") {block = "launch_site"; options.launch_site_set = true; }
		else if (element == "spacecraft") {block = "spacecraft"; }
		else if ((element == "position") && (mode == "input")) {block = "position"; options.position_set = true;}
		else if (element == "plot2d") {block = "plot2d";}
		else if (element == "plot3d") {block = "plot3d";}
		else if (element == "celestial_body") {block = "celestial_body"; options.num_bodies +=1;}
		else if (element == "ephemeris") {key = "ephemeris"; key_flag = 2;}
		else if (element == "list") {block = "list";}
		else if ((element == "state_vector") && (block == "list")) {key = "state_vector"; key_flag = 2;}
		else if ((element == "position") && (block == "list")) {key = "position"; key_flag = 2;}
		else if ((element == "orbital") && (block == "list")) {key = "orbital"; key_flag = 2;}
		else if ((element == "bodies") && (block == "list")) {key = "bodies"; key_flag = 2;}
		else if ((element == "lagrange") && (block == "list")) {key = "lagrange"; key_flag = 2;}
		else if ((element == "target_state_vector") && (block == "list")) {key = "target_state_vector"; key_flag = 2;}
		else if (element == "burn_peg7") { block = "burn_peg7"; options.burn_type[options.num_burns] = 0; options.num_burns +=1;}
		else if (element == "burn_lambert") { block = "burn_lambert"; options.burn_type[options.num_burns] = 5; options.num_burns +=1;}
		else if (element == "burn_low_thrust") { block = "burn_low_thrust"; options.burn_type[options.num_burns] = 4; options.num_burns +=1;}
		else if (element == "burn_peg4") { block = "burn_peg4"; options.burn_type[options.num_burns] = 1; options.num_burns +=1;}
		else if (element == "config") {block = "config";}
		else {key = element; key_flag = 1;}
			

		}
	else if (key_flag == 1)
		{
		//cout << "parsing value: " << value << endl;
		if (block == "state_vector")
			{
			if (key == "vx") {options.state_vector_vx = value;}
			else if (key == "vy") {options.state_vector_vy = value;}
			else if (key == "vz") {options.state_vector_vz = value;}
			else if (key == "x") {options.state_vector_x = value;}
			else if (key == "y") {options.state_vector_y = value;}
			else if (key == "z") {options.state_vector_z = value;}
			//cout << "Key is now: " << key << " value: " << value << endl;
			}
		else if (block == "target_state_vector")
			{
			if (key == "vx") {options.tgt_vx = value;}
			else if (key == "vy") {options.tgt_vy = value;}
			else if (key == "vz") {options.tgt_vz = value;}
			else if (key == "x") {options.tgt_x = value;}
			else if (key == "y") {options.tgt_y = value;}
			else if (key == "z") {options.tgt_z = value;}
			}
		else if (block == "burn_peg7")
			{
			if ((key == "dv_prograde") || (key == "dx")) {options.burn_delta_v_prograde[options.num_burns-1] = value;}
			else if ((key == "dv_radial") || (key == "dz")) {options.burn_delta_v_radial[options.num_burns-1] = value;}
			else if ((key == "dv_normal")|| (key == "dy")) {options.burn_delta_v_normal[options.num_burns-1] = value;}	
			else if (key == "time") {options.burn_time[options.num_burns-1] = value;}	
			}
		else if (block == "burn_lambert")
			{
			if ((key == "offset_x") || (key == "dx")) {options.burn_lambert_offset_x[options.num_burns-1] = value;}
			else if ((key == "offset_y") || (key == "dz")) {options.burn_lambert_offset_y[options.num_burns-1] = value;}
			else if ((key == "offset_z")|| (key == "dy")) {options.burn_lambert_offset_z[options.num_burns-1] = value;}	
			else if ((key == "time") || (key == "t1")) {options.burn_time[options.num_burns-1] = value;}	
			else if (key == "t2") {options.burn_lambert_t2[options.num_burns-1] = value;}	
			}
		else if (block == "burn_low_thrust")
			{
			if ((key == "dv_prograde") || (key == "dx")) {options.burn_delta_v_prograde[options.num_burns-1] = value;}
			else if ((key == "dv_radial") || (key == "dz")) {options.burn_delta_v_radial[options.num_burns-1] = value;}
			else if ((key == "dv_normal")|| (key == "dy")) {options.burn_delta_v_normal[options.num_burns-1] = value;}	
			else if (key == "time") {options.burn_time[options.num_burns-1] = value;}
			else if (key == "tvec_x") {options.burn_trig_x[options.num_burns-1] = value;}	
			else if (key == "tvec_y") {options.burn_trig_y[options.num_burns-1] = value;}		
			else if (key == "tvec_z") {options.burn_trig_z[options.num_burns-1] = value;}	
			else if (key == "tolerance") {options.burn_trig_tolerance[options.num_burns-1] = value;}
			}
		else if (block == "burn_peg4")
			{
			if (key == "c1") {options.burn_c1[options.num_burns-1] = value;}
			else if (key == "c2") {options.burn_c2[options.num_burns-1] = value;}
			else if (key == "thetaT") {options.burn_thetaT[options.num_burns-1] = value;}
			else if (key == "H") {options.burn_H[options.num_burns-1] = value;}
			else if (key == "time") {options.burn_time[options.num_burns-1] = value;}
			else if (key == "rei") {options.burn_rei[options.num_burns-1] = value; options.burn_type[options.num_burns-1] = 2;}
			else if (key == "ops") {options.burn_ops[options.num_burns-1] = static_cast<int>(value); }
			}
		else if (block == "config")
			{
			if (key == "plot2d_resolution") {options.plot2d_resolution = static_cast<int>(value);}
			else if (key == "plot3d_resolution") {options.plot3d_resolution = static_cast<int>(value);}
			else if (key == "max_time") {options.max_time = value;}
			else if (key == "timestep") {options.timestep = value;}
			else if (key == "fit_max_iterations") {options.fit_max_iterations = static_cast<int>(value);}
			}
		else if (block == "position")
			{
			if (key == "lat") {options.position_lat = value;}
			else if (key == "lon") {options.position_lon = value;}
			else if (key == "alt") {options.position_alt = value;}
			else if (key == "heading") {options.position_heading = value;}
			else if (key == "vup") {options.position_vup = value;}
			else if (key == "vtot") {options.position_vtot = value;}
			}
		else if (block == "target_position")
			{
			if (key == "lat") {options.tgt_lat = value;}
			else if (key == "lon") {options.tgt_lon = value;}
			else if (key == "alt") {options.tgt_alt = value;}
			else if (key == "heading") {options.tgt_heading = value;}
			else if (key == "vup") {options.tgt_vup = value;}
			else if (key == "vtot") {options.tgt_vtot = value;}
			}
		else if (block == "landing_site")
			{
			if (key == "lat") {options.landing_site_lat = value;}
			else if (key == "lon") {options.landing_site_lon = value;}
			}
		else if (block == "launch_site")
			{
			if (key == "lat") {options.launch_site_lat = value;}
			else if (key == "lon") {options.launch_site_lon = value;}
			}
		else if (block == "spacecraft")
			{
			if (key == "acceleration") {options.craft_acceleration = value; options.craft_acceleration_defined = true;}
			else if (key == "mass") {options.craft_mass = static_cast <long double> (value);}
			else if (key == "mass_dry") {options.craft_mass_dry = static_cast <long double> (value);}
			else if (key == "cross_section_area") {options.craft_area = static_cast <long double> (value);}
			else if (key == "propellant_mass") {options.craft_mass_propellant = static_cast <long double> (value);}
			else if ((key == "isp") || (key == "ISP")) {options.craft_isp = static_cast <long double> (value);}
			else if (key == "thrust") {options.craft_thrust = static_cast <long double> (value);} 
			}
		else if (block == "celestial_body")
			{
			if (key == "GM") {options.body_GM[options.num_bodies -1] = value; }
			}	

		key_flag = 0;
		}
	else if (key_flag == 2)
		{

		if (block == "config")
			{
			if (key == "units")
				{
				if (element == "imperial")
					{
					options.unit_flag = 1;
					}
				else if ((element == "si") || (element == "SI"))
					{
					options.unit_flag = 0;
					}
				}
			else if (key == "time_format")
				{
				if (element == "plain")
					{
					options.time_format_flag = 0;
					}
				else if ((element == "met") || (element == "MET"))
					{
					options.time_format_flag = 1;
					}
				}
			else if (key == "gravity_model")
				{
				if (element == "spherical")
					{
					options.gravity_model = 0;
					}
				else if (element == "J2")
					{
					options.gravity_model = 1;
					}
				else if (element == "J3")
					{
					options.gravity_model = 2;
					}
				}
			else if (key == "earth_model")
				{
				if (element == "spherical")
					{
					options.earth_model = 0;
					}
				else if (element == "IERS")
					{
					options.earth_model = 1;
					}
				}
			else if (key == "burn_model")
				{
				if (element == "impulse")
					{
					options.burn_model = 0;
					}
				else if (element == "constant")
					{
					options.burn_model = 1;
					}
				else if (element == "rocket_engine")
					{
					options.burn_model = 2;
					}
				}
			else if (key == "fit")
				{
				if (element == "verbose")
					{
					options.fit_log = true;
					}
				else if (element == "silent")
					{
					options.fit_log = false;
					}
				}
			}
		else if (block == "state_vector")
			{
			if (key == "met")
				{
				if (options.time_format_flag == 0)
					{
					options.initial_met = atof (element.c_str());
					}
				else if (options.time_format_flag == 1)
					{
					options.initial_met = converter.parse_time(element);
					}
				}

			}
		else if (block == "position")
			{
			if (key == "met")
				{
				if (options.time_format_flag == 0)
					{
					options.initial_met = atof (element.c_str());
					}
				else if (options.time_format_flag == 1)
					{
					options.initial_met = converter.parse_time(element);
					}
				}

			}
		else if (block == "target_state_vector")
			{

			if (key == "gravity_model")
				{
				if (element == "spherical")
					{
					options.tgt_gravity_model = 0;
					}
				else if (element == "J2")
					{
					options.tgt_gravity_model = 1;
					}
				if (element == "J3")
					{
					options.tgt_gravity_model = 2;
					}

				}
			}
		else if (block == "target_position")
			{

			if (key == "gravity_model")
				{
				if (element == "spherical")
					{
					options.tgt_gravity_model = 0;
					}
				else if (element == "J2")
					{
					options.tgt_gravity_model = 1;
					}
				if (element == "J3")
					{
					options.tgt_gravity_model = 2;
					}

				}
			}
		else if (block == "burn_peg7")
			{
			if (key == "name")
				{
				options.burn_name[options.num_burns - 1] = element;
				}
			else if ((key == "tig") || (key == "TIG"))
				{
				cout << "Parsing time - initial met: " << options.initial_met << endl;
				options.burn_time[options.num_burns -1] = converter.parse_time(element) - options.initial_met;
				}
			}
		else if (block == "burn_lambert")
			{
			if (key == "name")
				{
				options.burn_name[options.num_burns - 1] = element;
				}
			else if ((key == "tig") || (key == "TIG") || (key == "tig1") || (key == "TIG1"))
				{
				cout << "Parsing time - initial met: " << options.initial_met << endl;
				options.burn_time[options.num_burns -1] = converter.parse_time(element) - options.initial_met;
				}
			else if ((key == "tig2") || (key == "TIG2"))
				{
				cout << "Parsing time - initial met: " << options.initial_met << endl;
				options.burn_lambert_t2[options.num_burns -1] = converter.parse_time(element) - options.initial_met;
				}
			else if (key == "disable")
				{
				if (element == "y_fit")
					{
					options.burn_lambert_fit_y[options.num_burns -1] = false;
					}
				else if ((element == "auto_burn2") || (element == "automatic_burn2"))
					{
					options.burn_lambert_automatic_burn2[options.num_burns -1] = false;
					//options.num_burns -=1;
					}

				}

			}
		else if (block == "burn_low_thrust")
			{
			if (key == "name")
				{
				options.burn_name[options.num_burns - 1] = element;
				}
			else if ((key == "tig") || (key == "TIG"))
				{
				options.burn_time[options.num_burns -1] = converter.parse_time(element) - options.initial_met;
				}
			else if (key == "trig_in_plane")	
				{
				if (element == "disable")
					{
					options.burn_trig_in_plane[options.num_burns -1] = false;
					cout << "Option plane set to false!" << endl;
					}
				else
					{
					options.burn_trig_in_plane[options.num_burns -1] = true;
					}

				}		
			}
		else if (block == "burn_peg4")
			{
			if (key == "name")
				{
				options.burn_name[options.num_burns - 1] = element;
				}
			else if ((key == "tig") || (key == "TIG"))
				{
				options.burn_time[options.num_burns -1] = converter.parse_time(element) - options.initial_met;
				}
			else if (key == "optimize")
				{
				if ((element == "tig")||(element == "time"))
					{
					options.burn_type[options.num_burns-1] = 2;
					options.burn_rei[options.num_burns-1] = 0.0;
					}
				else if (element == "theta")
					{
					options.burn_type[options.num_burns-1] = 3;
					}
				}

				
			}
		else if (block == "landing_site")
			{
			if (key == "name")
				{
				options.landing_site_name = element;
				}
			}
		else if (block == "launch_site")
			{
			if (key == "name")
				{
				options.launch_site_name = element;
				}
			}
		else if (block == "celestial_body")
			{
			if (key == "name")
				{
				options.body_name[options.num_bodies -1] = element;
				}
			else if (key == "ephemeris")
				{
				options.body_ephemeris_file[options.num_bodies -1] = element;
				}

			}
		else if (block == "list")
			{
			if (key == "state_vector")
				{
				if  (element == "initial") {options.list_initial_sv = true;}
				else if (element == "final") {options.list_final_sv = true;}	
				else if ((element == "ei") || (element == "entry_interface")){options.list_ei_sv = true;}	
				}
			else if (key == "orbital")
				{
				if  (element == "initial") {options.list_initial_orbital = true;}
				else if (element == "final") {options.list_final_orbital = true;}	
				else if ((element == "ei") || (element == "entry_interface")) {options.list_ei_orbital = true;}				
				}
			else if (key == "position")
				{
				if  (element == "initial") {options.list_initial_pos = true;}
				else if (element == "final") {options.list_final_pos = true;}
				else if ((element == "ei") || (element == "entry_interface")) {options.list_ei_pos = true;}	
				}
			else if (key == "bodies")
				{
				if  (element == "initial") {options.list_initial_bodies = true;}
				else if (element == "final") {options.list_final_bodies = true;}	
				}
			else if (key == "lagrange")
				{
				if  (element == "initial") {options.list_initial_lagrange = true;}
				else if (element == "final") {options.list_final_lagrange = true;}	
				}
			else if (key == "target_state_vector")
				{
				if  (element == "initial") {options.list_initial_target_sv = true;}
				else if (element == "final") {options.list_final_target_sv = true;}	
				}
			}

		else if (block == "plot2d")
			{
			if (key == "file")
				{
				options.plot2d_filename = element;
				}
			else if (key == "x")
				{
				if (element == "time")
					{options.plot2d_x_option = 0;}
				else if (element == "x")
					{options.plot2d_x_option = 1;}
				else if (element == "y")
					{options.plot2d_x_option = 2;}
				else if (element == "z")
					{options.plot2d_x_option = 3;}
				else if ((element == "altitude") || (element == "alt"))
					{options.plot2d_x_option = 4;}
				else if (element == "semi_major")
					{options.plot2d_x_option = 5;}
				else if (element == "eccentricity")
					{options.plot2d_x_option = 6;}
				else if (element == "inclination")
					{options.plot2d_x_option = 7;}
				else if (element == "ascending_node")
					{options.plot2d_x_option = 8;}
				else if (element == "argument_of_periapsis")
					{options.plot2d_x_option = 9;}
				else if (element == "true_anomaly")
					{options.plot2d_x_option = 10;}
				else if ((element == "latitude") || (element == "lat"))
					{options.plot2d_x_option = 11;}
				else if ((element == "longitude") || (element == "lon"))
					{options.plot2d_x_option = 12;}
				else if (element == "radius") 
					{options.plot2d_x_option = 13;}
				else if (element == "vx") 
					{options.plot2d_x_option = 14;}
				else if (element == "vy") 
					{options.plot2d_x_option = 15;}
				else if (element == "vz") 
					{options.plot2d_x_option = 16;}
				else if (element == "vtot") 
					{options.plot2d_x_option = 17;}
				else if (element == "x1") 
					{options.plot2d_x_option = 18;}
				else if (element == "y1") 
					{options.plot2d_x_option = 19;}
				else if (element == "z1") 
					{options.plot2d_x_option = 20;}
				else if (element == "vx1") 
					{options.plot2d_x_option = 21;}
				else if (element == "vy1") 
					{options.plot2d_x_option = 22;}
				else if (element == "vz1") 
					{options.plot2d_x_option = 23;}
				else if (element == "body_x") 
					{options.plot2d_x_option = 24;}
				else if (element == "body_y") 
					{options.plot2d_x_option = 25;}
				else if (element == "body_z") 
					{options.plot2d_x_option = 26;}
				else if (element == "radius1") 
					{options.plot2d_x_option = 27;}
				else if (element == "course")
					{options.plot2d_x_option = 28;}
				else if (element == "target_x")
					{options.plot2d_x_option = 40;}
				else if (element == "target_y")
					{options.plot2d_x_option = 41;}
				else if (element == "target_z")
					{options.plot2d_x_option = 42;}
				else if (element == "target_vx")
					{options.plot2d_x_option = 43;}
				else if (element == "target_vy")
					{options.plot2d_x_option = 44;}
				else if (element == "target_vz")
					{options.plot2d_x_option = 45;}
				else if ((element == "target_lat") || (element == "target_latitude"))
					{options.plot2d_x_option = 46;}
				else if (element == "target_lon")
					{options.plot2d_x_option = 47;}
				else if ((element == "target_alt") || (element == "target_altitude"))
					{options.plot2d_x_option = 48;}
				else if (element == "target_prox_x")
					{options.plot2d_x_option = 49;}
				else if (element == "target_prox_y")
					{options.plot2d_x_option = 50;}
				else if (element == "target_prox_z")
					{options.plot2d_x_option = 51;}
				else if (element == "target_prox_vx")
					{options.plot2d_x_option = 52;}
				else if (element == "target_prox_vy")
					{options.plot2d_x_option = 53;}
				else if (element == "target_prox_vz")
					{options.plot2d_x_option = 54;}
				}
			else if (key == "y")
				{
				if (element == "time")
					{options.plot2d_y_option = 0;}
				else if (element == "x")
					{options.plot2d_y_option = 1;}
				else if (element == "y")
					{options.plot2d_y_option = 2;}
				else if (element == "z")
					{options.plot2d_y_option = 3;}
				else if ((element == "altitude") || (element == "alt"))
					{options.plot2d_y_option = 4;}
				else if (element == "semi_major")
					{options.plot2d_y_option = 5;}
				else if (element == "eccentricity")
					{options.plot2d_y_option = 6;}
				else if (element == "inclination")
					{options.plot2d_y_option = 7;}
				else if (element == "ascending_node")
					{options.plot2d_y_option = 8;}
				else if (element == "argument_of_periapsis")
					{options.plot2d_y_option = 9;}
				else if (element == "true_anomaly")
					{options.plot2d_y_option = 10;}
				else if ((element == "latitude") || (element == "lat"))
					{options.plot2d_y_option = 11;}
				else if ((element == "longitude") || (element == "lon"))
					{options.plot2d_y_option = 12;}
				else if (element == "radius") 
					{options.plot2d_y_option = 13;}
				else if (element == "vx") 
					{options.plot2d_y_option = 14;}
				else if (element == "vy") 
					{options.plot2d_y_option = 15;}
				else if (element == "vz") 
					{options.plot2d_y_option = 16;}
				else if (element == "vtot") 
					{options.plot2d_y_option = 17;}
				else if (element == "x1") 
					{options.plot2d_y_option = 18;}
				else if (element == "y1") 
					{options.plot2d_y_option = 19;}
				else if (element == "z1") 
					{options.plot2d_y_option = 20;}
				else if (element == "vx1") 
					{options.plot2d_y_option = 21;}
				else if (element == "vy1") 
					{options.plot2d_y_option = 22;}
				else if (element == "vz1") 
					{options.plot2d_y_option = 23;}
				else if (element == "body_x") 
					{options.plot2d_y_option = 24;}
				else if (element == "body_y") 
					{options.plot2d_y_option = 25;}
				else if (element == "body_z") 
					{options.plot2d_y_option = 26;}
				else if (element == "radius1") 
					{options.plot2d_y_option = 27;}
				else if (element == "course")
					{options.plot2d_y_option = 28;}
				else if (element == "target_x")
					{options.plot2d_y_option = 40;}
				else if (element == "target_y")
					{options.plot2d_y_option = 41;}
				else if (element == "target_z")
					{options.plot2d_y_option = 42;}
				else if (element == "target_vx")
					{options.plot2d_y_option = 43;}
				else if (element == "target_vy")
					{options.plot2d_y_option = 44;}
				else if (element == "target_vz")
					{options.plot2d_y_option = 45;}
				else if ((element == "target_lat") || (element == "target_latitude"))
					{options.plot2d_y_option = 46;}
				else if (element == "target_lon")
					{options.plot2d_y_option = 47;}
				else if ((element == "target_alt") || (element == "target_altitude"))
					{options.plot2d_y_option = 48;}
				else if (element == "target_prox_x")
					{options.plot2d_y_option = 49;}
				else if (element == "target_prox_y")
					{options.plot2d_y_option = 50;}
				else if (element == "target_prox_z")
					{options.plot2d_y_option = 51;}
				else if (element == "target_prox_vx")
					{options.plot2d_y_option = 52;}
				else if (element == "target_prox_vy")
					{options.plot2d_y_option = 53;}
				else if (element == "target_prox_vz")
					{options.plot2d_y_option = 54;}
				}


			}
		else if (block == "plot3d")
			{
			if (key == "file")
				{
				options.plot3d_filename = element;
				}
			else if (key == "x")
				{
				if (element == "time")
					{options.plot3d_x_option = 0;}
				else if (element == "x")
					{options.plot3d_x_option = 1;}
				else if (element == "y")
					{options.plot3d_x_option = 2;}
				else if (element == "z")
					{options.plot3d_x_option = 3;}
				else if ((element == "altitude") || (element == "alt"))
					{options.plot3d_x_option = 4;}
				else if (element == "semi_major")
					{options.plot3d_x_option = 5;}
				else if (element == "eccentricity")
					{options.plot3d_x_option = 6;}
				else if (element == "inclination")
					{options.plot3d_x_option = 7;}
				else if (element == "ascending_node")
					{options.plot3d_x_option = 8;}
				else if (element == "argument_of_periapsis")
					{options.plot3d_x_option = 9;}
				else if (element == "true_anomaly")
					{options.plot3d_x_option = 10;}
				else if ((element == "latitude") || (element == "lat"))
					{options.plot3d_x_option = 11;}
				else if ((element == "longitude") || (element == "lon"))
					{options.plot3d_x_option = 12;}
				else if (element == "radius") 
					{options.plot3d_x_option = 13;}
				else if (element == "vx") 
					{options.plot3d_x_option = 14;}
				else if (element == "vy") 
					{options.plot3d_x_option = 15;}
				else if (element == "vz") 
					{options.plot3d_x_option = 16;}
				else if (element == "vtot") 
					{options.plot3d_x_option = 17;}
				else if (element == "x1") 
					{options.plot3d_x_option = 18;}
				else if (element == "y1") 
					{options.plot3d_x_option = 19;}
				else if (element == "z1") 
					{options.plot3d_x_option = 20;}
				else if (element == "vx1") 
					{options.plot3d_x_option = 21;}
				else if (element == "vy1") 
					{options.plot3d_x_option = 22;}
				else if (element == "vz1") 
					{options.plot3d_x_option = 23;}
				else if (element == "body_x") 
					{options.plot3d_x_option = 24;}
				else if (element == "body_y") 
					{options.plot3d_x_option = 25;}
				else if (element == "body_z") 
					{options.plot3d_x_option = 26;}
				else if (element == "radius1") 
					{options.plot3d_x_option = 27;}
				else if (element == "target_x")
					{options.plot3d_x_option = 40;}
				else if (element == "target_y")
					{options.plot3d_x_option = 41;}
				else if (element == "target_z")
					{options.plot3d_x_option = 42;}
				else if (element == "target_vx")
					{options.plot3d_x_option = 43;}
				else if (element == "target_vy")
					{options.plot3d_x_option = 44;}
				else if (element == "target_vz")
					{options.plot3d_x_option = 45;}
				else if ((element == "target_lat") || (element == "target_latitude"))
					{options.plot3d_x_option = 46;}
				else if (element == "target_lon")
					{options.plot3d_x_option = 47;}
				else if ((element == "target_alt") || (element == "target_altitude"))
					{options.plot3d_x_option = 48;}
				else if (element == "target_prox_x")
					{options.plot3d_x_option = 49;}
				else if (element == "target_prox_y")
					{options.plot3d_x_option = 50;}
				else if (element == "target_prox_z")
					{options.plot3d_x_option = 51;}
				else if (element == "target_prox_vx")
					{options.plot3d_x_option = 52;}
				else if (element == "target_prox_vy")
					{options.plot3d_x_option = 53;}
				else if (element == "target_prox_vz")
					{options.plot3d_x_option = 54;}
				}
			else if (key == "y")
				{
				if (element == "time")
					{options.plot3d_y_option = 0;}
				else if (element == "x")
					{options.plot3d_y_option = 1;}
				else if (element == "y")
					{options.plot3d_y_option = 2;}
				else if (element == "z")
					{options.plot3d_y_option = 3;}
				else if ((element == "altitude") || (element == "alt"))
					{options.plot3d_y_option = 4;}
				else if (element == "semi_major")
					{options.plot3d_y_option = 5;}
				else if (element == "eccentricity")
					{options.plot3d_y_option = 6;}
				else if (element == "inclination")
					{options.plot3d_y_option = 7;}
				else if (element == "ascending_node")
					{options.plot3d_y_option = 8;}
				else if (element == "argument_of_periapsis")
					{options.plot3d_y_option = 9;}
				else if (element == "true_anomaly")
					{options.plot3d_y_option = 10;}
				else if ((element == "latitude") || (element == "lat"))
					{options.plot3d_y_option = 11;}
				else if ((element == "longitude") || (element == "lon"))
					{options.plot3d_y_option = 12;}
				else if (element == "radius") 
					{options.plot3d_y_option = 13;}
				else if (element == "vx") 
					{options.plot3d_y_option = 14;}
				else if (element == "vy") 
					{options.plot3d_y_option = 15;}
				else if (element == "vz") 
					{options.plot3d_y_option = 16;}
				else if (element == "vtot") 
					{options.plot3d_y_option = 17;}
				else if (element == "x1") 
					{options.plot3d_y_option = 18;}
				else if (element == "y1") 
					{options.plot3d_y_option = 19;}
				else if (element == "z1") 
					{options.plot3d_y_option = 20;}
				else if (element == "vx1") 
					{options.plot3d_y_option = 21;}
				else if (element == "vy1") 
					{options.plot3d_y_option = 22;}
				else if (element == "vz1") 
					{options.plot3d_y_option = 23;}
				else if (element == "body_x") 
					{options.plot3d_y_option = 24;}
				else if (element == "body_y") 
					{options.plot3d_y_option = 25;}
				else if (element == "body_z") 
					{options.plot3d_y_option = 26;}
				else if (element == "radius1") 
					{options.plot3d_y_option = 27;}
				else if (element == "target_x")
					{options.plot3d_y_option = 40;}
				else if (element == "target_y")
					{options.plot3d_y_option = 41;}
				else if (element == "target_z")
					{options.plot3d_y_option = 42;}
				else if (element == "target_vx")
					{options.plot3d_y_option = 43;}
				else if (element == "target_vy")
					{options.plot3d_y_option = 44;}
				else if (element == "target_vz")
					{options.plot3d_y_option = 45;}
				else if ((element == "target_lat") || (element == "target_latitude"))
					{options.plot3d_y_option = 46;}
				else if (element == "target_lon")
					{options.plot3d_y_option = 47;}
				else if ((element == "target_alt") || (element == "target_altitude"))
					{options.plot3d_y_option = 48;}
				else if (element == "target_prox_x")
					{options.plot3d_y_option = 49;}
				else if (element == "target_prox_y")
					{options.plot3d_y_option = 50;}
				else if (element == "target_prox_z")
					{options.plot3d_y_option = 51;}
				else if (element == "target_prox_vx")
					{options.plot3d_y_option = 52;}
				else if (element == "target_prox_vy")
					{options.plot3d_y_option = 53;}
				else if (element == "target_prox_vz")
					{options.plot3d_y_option = 54;}
				}
			else if (key == "z")
				{
				if (element == "time")
					{options.plot3d_z_option = 0;}
				else if (element == "x")
					{options.plot3d_z_option = 1;}
				else if (element == "y")
					{options.plot3d_z_option = 2;}
				else if (element == "z")
					{options.plot3d_z_option = 3;}
				else if ((element == "altitude") || (element == "alt"))
					{options.plot3d_z_option = 4;}
				else if (element == "semi_major")
					{options.plot3d_z_option = 5;}
				else if (element == "eccentricity")
					{options.plot3d_z_option = 6;}
				else if (element == "inclination")
					{options.plot3d_z_option = 7;}
				else if (element == "ascending_node")
					{options.plot3d_z_option = 8;}
				else if (element == "argument_of_periapsis")
					{options.plot3d_z_option = 9;}
				else if (element == "true_anomaly")
					{options.plot3d_z_option = 10;}
				else if ((element == "latitude") || (element == "lat"))
					{options.plot3d_z_option = 11;}
				else if ((element == "longitude") || (element == "lon"))
					{options.plot3d_z_option = 12;}
				else if (element == "radius") 
					{options.plot3d_z_option = 13;}
				else if (element == "vx") 
					{options.plot3d_z_option = 14;}
				else if (element == "vy") 
					{options.plot3d_z_option = 15;}
				else if (element == "vz") 
					{options.plot3d_z_option = 16;}
				else if (element == "vtot") 
					{options.plot3d_z_option = 17;}
				else if (element == "x1") 
					{options.plot3d_z_option = 18;}
				else if (element == "y1") 
					{options.plot3d_z_option = 19;}
				else if (element == "z1") 
					{options.plot3d_z_option = 20;}
				else if (element == "vx1") 
					{options.plot3d_z_option = 21;}
				else if (element == "vy1") 
					{options.plot3d_z_option = 22;}
				else if (element == "vz1") 
					{options.plot3d_z_option = 23;}
				else if (element == "body_x") 
					{options.plot3d_z_option = 24;}
				else if (element == "body_y") 
					{options.plot3d_z_option = 25;}
				else if (element == "body_z") 
					{options.plot3d_z_option = 26;}
				else if (element == "radius1") 
					{options.plot3d_z_option = 27;}
				else if (element == "target_x")
					{options.plot3d_z_option = 40;}
				else if (element == "target_y")
					{options.plot3d_z_option = 41;}
				else if (element == "target_z")
					{options.plot3d_z_option = 42;}
				else if (element == "target_vx")
					{options.plot3d_z_option = 43;}
				else if (element == "target_vy")
					{options.plot3d_z_option = 44;}
				else if (element == "target_vz")
					{options.plot3d_z_option = 45;}
				else if ((element == "target_lat") || (element == "target_latitude"))
					{options.plot3d_z_option = 46;}
				else if (element == "target_lon")
					{options.plot3d_z_option = 47;}
				else if ((element == "target_alt") || (element == "target_altitude"))
					{options.plot3d_z_option = 48;}
				else if (element == "target_prox_x")
					{options.plot3d_z_option = 49;}
				else if (element == "target_prox_y")
					{options.plot3d_z_option = 50;}
				else if (element == "target_prox_z")
					{options.plot3d_z_option = 51;}
				else if (element == "target_prox_vx")
					{options.plot3d_z_option = 52;}
				else if (element == "target_prox_vy")
					{options.plot3d_z_option = 53;}
				else if (element == "target_prox_vz")
					{options.plot3d_z_option = 54;}
				}


			}

		key_flag = 0;
		}

	

    }
    cfgfile.close();

	
    converter.set_units(options.unit_flag);




    if (((options.craft_mass > 0.0) || (options.craft_mass_dry > 0.0)) && (options.craft_mass_propellant > 0.0) && (options.craft_thrust > 0.0) && (options.craft_isp > 0.0))
	{
	options.craft_defined = true;

	if (options.craft_mass > 0.0)
		{
		options.craft_mass_dry = options.craft_mass - options.craft_mass_propellant;
		}
	else
		{
		options.craft_mass = options.craft_mass_dry + options.craft_mass_propellant;
		}
	}

   if (options.num_bodies > 0)
	{
	for (int i=0; i< options.num_bodies; i++)
		{
		statevec.add_body(options.body_name[i], options.body_ephemeris_file[i], options.body_GM[i]);
		}

	}


    statevec.init(converter, options);
	


    if (options.position_set)
	{
	double radius = converter.convert_length_output(statevec.get_earth_radius(options.position_lat)) + options.position_alt;


	long double x = radius * cos(options.position_lat * deg_to_rad) * cos(options.position_lon * deg_to_rad);
	long double y = radius * cos(options.position_lat * deg_to_rad) * sin(options.position_lon * deg_to_rad);
	long double z = radius * sin (options.position_lat * deg_to_rad);
	

	statevec.set_pos(x,y,z);

	long double radial_norm = sqrt(x*x + y*y + z*z);
	long double unit_radial_x = x/radial_norm;
	long double unit_radial_y = y/radial_norm;
	long double unit_radial_z = z/radial_norm;

	long double unit_east_x = -unit_radial_y;
	long double unit_east_y = unit_radial_x;
	long double unit_east_z = 0.0;

	long double unit_east_norm = sqrt(unit_east_x * unit_east_x + unit_east_y * unit_east_y);
	unit_east_x /= unit_east_norm;
	unit_east_y /= unit_east_norm;

	long double unit_north_x = unit_radial_y * unit_east_z - unit_radial_z * unit_east_y;
	long double unit_north_y = unit_radial_z * unit_east_x - unit_radial_x * unit_east_z;
	long double unit_north_z = unit_radial_x * unit_east_y - unit_radial_y * unit_east_x;

	long double v_east = options.position_vtot * sin(options.position_heading * deg_to_rad);
	long double v_north = options.position_vtot * cos(options.position_heading * deg_to_rad);
	long double vup =  options.position_vup;

	//cout << "v_east: " << v_east << "v_north: " << v_north << endl;

	long double vx = unit_radial_x * vup + unit_east_x * v_east + unit_north_x * v_north;
	long double vy = unit_radial_y * vup + unit_east_y * v_east + unit_north_y * v_north;
	long double vz = unit_radial_z * vup + unit_east_z * v_east + unit_north_z * v_north;

	statevec.set_vel(vx, vy, vz);

	options.state_vector_position_defined = 1;
	options.state_vector_velocity_defined = 1;
	}
    else if ((options.state_vector_x != -1.0) && (options.state_vector_y != -1.0) && (options.state_vector_z != -1.0))
	{
	statevec.set_pos(options.state_vector_x, options.state_vector_y, options.state_vector_z);
	options.state_vector_position_defined = 1;
	}


    if ((options.state_vector_vx != -1.0) && (options.state_vector_vy != -1.0) && (options.state_vector_vz != -1.0))
	{
	statevec.set_vel(options.state_vector_vx, options.state_vector_vy, options.state_vector_vz);
	options.state_vector_velocity_defined = 1;
	}
	

   if ((options.state_vector_position_defined == 1) && (options.state_vector_velocity_defined == 1))
	{
	options.state_vector_valid = 1;
	}
   else
	{
	cout << "No valid state vector defined - aborting... " << endl;
	exit(0);
	}



    if (options.target_flag == 1)
	{
	statevec.target_init(options);
	


	    if (options.tgt_position_set) 
		{
		double radius = converter.convert_length_output(statevec.get_earth_radius(options.tgt_lat)) + options.tgt_alt;


		long double x = radius * cos(options.tgt_lat * deg_to_rad) * cos(options.tgt_lon * deg_to_rad);
		long double y = radius * cos(options.tgt_lat * deg_to_rad) * sin(options.tgt_lon * deg_to_rad);
		long double z = radius * sin (options.tgt_lat * deg_to_rad);
	

		statevec.target_set_pos(x,y,z);

		long double radial_norm = sqrt(x*x + y*y + z*z);
		long double unit_radial_x = x/radial_norm;
		long double unit_radial_y = y/radial_norm;
		long double unit_radial_z = z/radial_norm;

		long double unit_east_x = -unit_radial_y;
		long double unit_east_y = unit_radial_x;
		long double unit_east_z = 0.0;

		long double unit_east_norm = sqrt(unit_east_x * unit_east_x + unit_east_y * unit_east_y);
		unit_east_x /= unit_east_norm;
		unit_east_y /= unit_east_norm;

		long double unit_north_x = unit_radial_y * unit_east_z - unit_radial_z * unit_east_y;
		long double unit_north_y = unit_radial_z * unit_east_x - unit_radial_x * unit_east_z;
		long double unit_north_z = unit_radial_x * unit_east_y - unit_radial_y * unit_east_x;

		long double v_east = options.tgt_vtot * sin(options.tgt_heading * deg_to_rad);
		long double v_north = options.tgt_vtot * cos(options.tgt_heading * deg_to_rad);
		long double vup =  options.tgt_vup;

		//cout << "v_east: " << v_east << "v_north: " << v_north << endl;

		long double vx = unit_radial_x * vup + unit_east_x * v_east + unit_north_x * v_north;
		long double vy = unit_radial_y * vup + unit_east_y * v_east + unit_north_y * v_north;
		long double vz = unit_radial_z * vup + unit_east_z * v_east + unit_north_z * v_north;

		statevec.target_set_vel(vx, vy, vz);


		}
	    else if ((options.tgt_x != -1.0) && (options.tgt_y != -1.0) && (options.tgt_z != -1.0))
		{
		statevec.target_set_pos(options.tgt_x, options.tgt_y, options.tgt_z);
		statevec.target_set_vel(options.tgt_vx, options.tgt_vy, options.tgt_vz);
		}

	}


   if (options.num_burns > 0)
	{
	for (int i=0; i< options.num_burns; i++)
		{
		if (options.burn_type[i] == 0) // PEG-7
			{

			statevec.add_peg7_burn(options.burn_time[i], options.burn_delta_v_prograde[i], options.burn_delta_v_radial[i], options.burn_delta_v_normal[i], options.burn_name[i]);
			}
		else if (options.burn_type[i] == 1) // PEG-4
			{
			
			if (options.burn_H[i] < 100000.0)//input is in nm or km
				{
				if (options.unit_flag == 0) {options.burn_H[i] *= 1000.0;}
				else if (options.unit_flag == 1) {options.burn_H[i] *=6076.11548556;}
				}

			statevec.add_peg4_burn(options.burn_time[i], options.burn_thetaT[i], options.burn_H[i], options.burn_c1[i], options.burn_c2[i], options.burn_name[i],0);

			if (options.burn_ops[i] == 1) {statevec.set_burn_ops(i, options.burn_ops[i]);}

			}
		else if (options.burn_type[i] == 2) // optimized PEG-4
			{
			if (options.burn_H[i] < 100000.0)//input is in nm or km
				{
				if (options.unit_flag == 0) {options.burn_H[i] *= 1000.0;}
				else if (options.unit_flag == 1) {options.burn_H[i] *=6076.11548556;}
				}


			statevec.add_peg4_burn_optimized(options.burn_time[i], options.burn_thetaT[i], options.burn_H[i], options.burn_c1[i], options.burn_c2[i], options.burn_rei[i], options.burn_name[i]);

			if (options.burn_ops[i] == 1) {statevec.set_burn_ops(i, options.burn_ops[i]);}


			}
		else if (options.burn_type[i] == 3) // PEG-4 with free angle
			{
			
			if (options.burn_H[i] < 100000.0)//input is in nm or km
				{
				if (options.unit_flag == 0) {options.burn_H[i] *= 1000.0;}
				else if (options.unit_flag == 1) {options.burn_H[i] *=6076.11548556;}
				}

			statevec.add_peg4_burn(options.burn_time[i], options.burn_thetaT[i], options.burn_H[i], options.burn_c1[i], options.burn_c2[i], options.burn_name[i], 1);

			if (options.burn_ops[i] == 1) {statevec.set_burn_ops(i, options.burn_ops[i]);}
			}
		else if (options.burn_type[i] == 4) // low thrust
			{
			statevec.add_low_thrust_burn(options.burn_time[i], options.burn_delta_v_prograde[i], options.burn_delta_v_radial[i], options.burn_delta_v_normal[i], options.burn_trig_x[i], options.burn_trig_y[i], options.burn_trig_z[i], options.burn_trig_tolerance[i], options.burn_name[i]);

			if (options.burn_trig_in_plane[i] == false)
				{
				statevec.set_burn_plane_flag(i, false);
				}
			}

		else if (options.burn_type[i] == 5) // lambert
			{
			statevec.add_lambert_burn(options.burn_time[i], options.burn_lambert_t2[i], options.burn_lambert_offset_x[i], options.burn_lambert_offset_y[i], options.burn_lambert_offset_z[i],options.burn_lambert_fit_y[i], options.burn_lambert_automatic_burn2[i],   options.burn_name[i]);


			}



		else
			{
			cout << "Requested burn type not implemented - aborting..." << endl;
			exit(0);
			}
		}
	}








  }

  else cout << "Unable to open file " << config_file << " !" << endl;
}

