// options.hxx - options settable by the command line parser
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef OPTIONS_H
#define OPTIONS_H


class Options {
	public:

	//general config

	int unit_flag;
	int time_format_flag;
	int gravity_model;
	int earth_model;
	int burn_model;
	int fit_max_iterations;

	bool fit_log;

	long double max_time;
	long double timestep;
	

 	//initial state vector
	long double state_vector_x;
	long double state_vector_y;
	long double state_vector_z;

	long double state_vector_vx;
	long double state_vector_vy;
	long double state_vector_vz;

	long double position_lat;
	long double position_lon;
	long double position_alt;

	long double position_heading;
	long double position_vtot;
	long double position_vup;
	
	long double initial_met;

	bool position_set;

	int state_vector_valid;
	int state_vector_position_defined;
	int state_vector_velocity_defined;

	//spacecraft properties

	long double craft_mass;
	long double craft_area;
	long double craft_acceleration;
	long double craft_mass_propellant;
	long double craft_mass_dry;
	long double craft_isp;
	long double craft_thrust;
	bool craft_defined;
	bool craft_acceleration_defined;

	//landing site properties
	long double landing_site_lat;
	long double landing_site_lon;
	std::string landing_site_name;
	bool landing_site_set;

	//launch site properties
	long double launch_site_lat;
	long double launch_site_lon;
	std::string launch_site_name;
	bool launch_site_set;

	//plot properties
	bool plot2d_flag;
	std::string plot2d_filename;
	int plot2d_x_option;
	int plot2d_y_option;
	int plot2d_resolution;

	bool plot3d_flag;
	std::string plot3d_filename;
	int plot3d_x_option;
	int plot3d_y_option;
	int plot3d_z_option;
	int plot3d_resolution;

	//list properties
	bool list_initial_sv;
	bool list_final_sv;
	bool list_initial_orbital;
	bool list_final_orbital;
	bool list_initial_pos;
	bool list_final_pos;
	bool list_ei_orbital;
	bool list_ei_sv;
	bool list_ei_pos;
	bool list_initial_bodies;
	bool list_final_bodies;
	bool list_initial_lagrange;
	bool list_final_lagrange;
	bool list_initial_target_sv;
	bool list_final_target_sv;

	//burn properties
	int num_burns;

	int burn_type[10];
	std::string burn_name[10];

	long double burn_delta_v_prograde[10];
	long double burn_delta_v_radial[10];
	long double burn_delta_v_normal[10];
	long double burn_time[10];

	long double burn_c1[10];
	long double burn_c2[10];
	long double burn_thetaT[10];
	long double burn_H[10];
	long double burn_rei[10];

	long double burn_lambert_t2[10];
	long double burn_lambert_offset_x[10];
	long double burn_lambert_offset_y[10];
	long double burn_lambert_offset_z[10];

	long double burn_trig_x[10];
	long double burn_trig_y[10];
	long double burn_trig_z[10];
	long double burn_trig_tolerance[10];
	bool burn_trig_in_plane[10];

	bool burn_lambert_fit_y[10];
	bool burn_lambert_automatic_burn2[10];

	int burn_ops[10];


	// celestial body properties

	int num_bodies;

	std::string body_name[5];
	std::string body_ephemeris_file[5];
	long double body_GM[5];


	// rendezvous target

	int target_flag;

	std::string target_name;
	long double tgt_lat;
	long double tgt_lon;
	long double tgt_alt;
	long double tgt_heading;
	long double tgt_vup;
	long double tgt_vtot;
	long double tgt_x;
	long double tgt_y;
	long double tgt_z;
	long double tgt_vx;
	long double tgt_vy;	
	long double tgt_vz;


	bool tgt_position_set;

	int tgt_gravity_model;


};

#endif
