// math_helpers.cxx -- routines to do simple math
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef MATHHELPERS_H
#define MATHHELPERS_H

namespace MathHelpers {

long double dot_product (long double vec1[], long double vec2[]);
long double norm (long double vec[]);

long double cross_product_x (long double vec1[3], long double vec2[3]);
long double cross_product_y (long double vec1[3], long double vec2[3]);
long double cross_product_z (long double vec1[3], long double vec2[3]);

long double orthogonalize_x ( long double vec1[3], long double vec2[3]);
long double orthogonalize_y ( long double vec1[3], long double vec2[3]);
long double orthogonalize_z ( long double vec1[3], long double vec2[3]);



long double sgn(long double x);


class Spline {

	int size;

	long double x[1001];
	long double a[1001];
	long double b[1000];
	long double d[1000];
	long double h[1000];
	long double mu[1000];
	long double c[1001];
	long double l[1001];
	long double z[1001];
	long double alpha[999];

	public:

	void init (int k, long double x_in[1001], long double y_in[1001]);
	long double interpolate(long double x_in, int i);
	long double interpolate(long double x_in);

};

}



#endif
