// low_orbit.cxx -- a program to simulate orbital maneuvering in Low Earth Orbit
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#include <iostream>
#include <fstream>
#include <string>
#include <stdlib.h>
#include <math.h>

using namespace std;

#include "options.hxx"
#include "state_vector.hxx"
#include "plot.hxx"
#include "burn.hxx"
#include "celestial_body.hxx"


#include "constants.hxx"



Options options;
PlotTools plot;
Units converter;
StateVector statevec;


#include "parser.cxx"


string commandline_parser (int argc, char *argv[]) 
{ 
string config_file;

if (argc != 2)
	{
	cout <<"Please specify a configuration file!" << endl;
	}
else
	{
	config_file = argv[1];
	cout << "Reading " << config_file << " for configuration." << endl;
	}

return config_file;

}



int main (int argc, char *argv[] ) 
{
string config_file;

  config_file = commandline_parser (argc, argv);

  file_parser(config_file);


 

	
  if (options.list_initial_sv)
  	{statevec.list();}
  
  if (options.list_initial_pos)
	{statevec.list_position();}

  if (options.list_initial_orbital)
	{statevec.list_orbital();}

  if (options.list_initial_bodies)
	{statevec.list_bodies();}

  if (options.list_initial_lagrange)
	{statevec.list_lagrange();}

  if (options.list_initial_target_sv)
	{statevec.list_target_sv();}

  statevec.evolve_to (options.max_time);



  if (options.list_final_sv)
  	{statevec.list();}
  
  if (options.list_final_pos)
	{statevec.list_position();}

  if (options.list_final_orbital)
	{statevec.list_orbital();}

  if (options.list_final_bodies)
	{statevec.list_bodies();}

  if (options.list_final_lagrange)
	{statevec.list_lagrange();}

  if (options.list_final_target_sv)
	{statevec.list_target_sv();}

  if (options.plot2d_flag)
  	{
	plot.plot2d(statevec.plot2d_x, statevec.plot2d_y, statevec.plot2d_index, options.plot2d_filename);
	}

  if (options.plot3d_flag)
  	{
	plot.plot3d(statevec.plot3d_x, statevec.plot3d_y, statevec.plot3d_z, statevec.plot3d_index, options.plot3d_filename);
	}


}
