// constants.cxx -- constants and routines to return them
//
// Written by Thorsten Renk, started 2018
//
// Copyright (C) 2018  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef CONSTANTS_H
#define CONSTANTS_H


const double G = 6.6738e-11; // gravitational constant
const double c_light = 299792458.0; // speed of light
const double M_solar = 1.98855e30; // solar mass
const double L_solar = 3.846e26; // solar power output 
const double k_B = 1.380e-23; // Boltzmann constant
const double h_planck = 6.626e-34; // Planck constant
const double sigma_SB = 5.67e-8; // Stefan-Boltzmann constant
const double pi = 3.1415926535; // Pi
const double M_earth = 5.97237e24; // Earth mass
const double R_earth = 6371000; // Earth radius
const double AU = 149597871000.0; // Astronomical unit
const double amu = 1.660539e-27; // atomic mass unit
const double p_surface_earth = 101325.0; // Earth atmosphere surface pressure in N/m^2
const double earth_rotation_speed = 0.0041780741323598; //Earth angular rotation in deg/s


const long double GM = 398600441800000.0; // Earth GM product in m^3/s^2
const long double GM_Earth = 398600441800000.0; // Earth GM product in m^3/s^2
const long double J2 = 1.755e25; // Earth non-linear gravity second harmonic parameter
const long double J3 = -2.532e29; // Earth non-linear gravity third harmonic parameter 
const long double R_eq = 6378136.60; // Earth equatorial radius
const long double R_polar = 6356751.90; // Earth polar radius



const double deg_to_rad = 0.01745329;
const double rad_to_deg = 57.29578;
const double Pa_to_mbar = 0.01;


#endif
