// seed.hxx -- class to define an epidemic seeding with external contagion
//
// Written by Thorsten Renk, started 2020
//
// Copyright (C) 2020 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef SEED_H
#define SEED_H





class Seed {

	
	int time;
	int number;
	int tag_index;

	double p_transmission;

	public:

	void init(int time, int number, double p_transmission, int tag_index);
	bool check(int time);

	int get_number();
	int get_tag_index();
	double get_p_transmission();	
	

};

#endif
