// seed.cxx -- class to define an epidemic seeding with external contagion
//
// Written by Thorsten Renk, started 2020
//
// Copyright (C) 2020 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <math.h>
#include <cmath>
#include <iostream>

#include "seed.hxx"

using namespace std;

void Seed::init(int time_in, int number_in, double p_transmission_in, int tag_index_in)
{

time = time_in;
number = number_in;
tag_index = tag_index_in;
p_transmission = p_transmission_in;
}

bool Seed::check(int time_in)
{
if (time == time_in) {return true;}
else {return false;}
}

int Seed::get_number()
{
return number;
}

int Seed::get_tag_index()
{
return tag_index;
}

double Seed::get_p_transmission()
{
return p_transmission;
}


