
// plot.cxx - routines to create plot format output
//
// Written by Thorsten Renk, started 2017
//
// Copyright (C) 2017  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <iostream>
#include <iomanip>
#include <fstream>
#include <cstdlib>
#include <string>

using namespace std;

#include "plot.hxx"



void PlotTools::plot2d (double x[], double y[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;
	resfile << setprecision(12) ;
	resfile << x[i] << " " << y[i]  << endl;
	}


    resfile.close();
    cout << "2d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}

void PlotTools::plot2d (int x[], int y[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;

	resfile << x[i] << " " << y[i]  << endl;
	}


    resfile.close();
    cout << "2d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}


void PlotTools::plot3d (int x[], int y[], int z[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;

	resfile << x[i] << " " << y[i] << " " << z[i] << endl;
	}


    resfile.close();
    cout << "2d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}


void PlotTools::plot4d (int x[], int y[], int z[], int z1[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;

	resfile << x[i] << " " << y[i] << " " << z[i] << " " << z1[i] << endl;
	}


    resfile.close();
    cout << "2d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}


void PlotTools::plot3d (double x[], double y[], double z[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;
	resfile << setprecision(12) ;
	resfile << x[i] << " " << y[i]  << " " << z[i] << endl;
	}


    resfile.close();
    cout << "3d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}

void PlotTools::plot4d (double x[], double y[], double z[], double z1[], int npoints, string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< npoints; i=i+1)

	{
	//cout << i << endl;
	resfile << setprecision(12) ;
	resfile << x[i] << " " << y[i]  << " " << z[i] << " " << z1[i] << endl;
	}


    resfile.close();
    cout << "4d plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;
}



void PlotTools::plot_sgnu(double **array, int row, int col, std::string filename)
{

ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  
  for (int i = 0; i< row; i=i+1)

	{
	for (int j=0; j< col; j++)
		{
		resfile << setprecision(12) ;
		resfile << i << " " << j  << " " << array[i][j] << endl;
		}	
	resfile << endl;

	}


    resfile.close();
    cout << "2d surface plot written to " << filename << "!" << endl;

  }
 else cout << "Unable to open file " << filename << " !" << endl;


}


void PlotTools::plot_mtv(double array[], int row, int col, std::string filename)

{
int flag;

int i,j, xsize, ysize;
double x_min, x_max, x, y_min, y_max, y;
double r, phi;

xsize = row;
ysize = col;

x_min = 0;
x_max = row;

y_min = 0;
y_max = col;

cout << "MTV plot to " << filename << endl;


ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  resfile << "$DATA=CONTOUR" << endl;
  resfile << "%contstyle=2" << endl;
  resfile << "%nx=" << ysize << endl;
  resfile << "%ny=" << xsize << endl;
  resfile << "%xmax=" << x_max << endl;
  resfile << "%xmin=" << x_min << endl;
  resfile << "%ymax=" << y_max << endl;
  resfile << "%ymin=" << y_min << endl;
  resfile << "%nsteps=20" << endl;

  for (int i = 0; i< row; i=i+1)
	{
	for(j=0; j<col; j++)
		{
		resfile << array[i*row + j] << endl;
		
		}
	}


    resfile.close();

  }
 else cout << "Unable to open file " << "surface_plot.mtv" << " !" << endl;

}

void PlotTools::plot_mtv(double array[], int row, int col, double z_min, double z_max, std::string filename)

{
int flag;

int i,j, xsize, ysize;
double x_min, x_max, x, y_min, y_max, y;
double r, phi;

xsize = row;
ysize = col;

x_min = 0;
x_max = row;

y_min = 0;
y_max = col;

cout << "MTV plot to " << filename << endl;


ofstream resfile (filename.c_str());
  if (resfile.is_open())
  {
  resfile << "$DATA=CONTOUR" << endl;
  resfile << "%contstyle=2" << endl;
  resfile << "%nx=" << ysize << endl;
  resfile << "%ny=" << xsize << endl;
  resfile << "%xmax=" << x_max << endl;
  resfile << "%xmin=" << x_min << endl;
  resfile << "%ymax=" << y_max << endl;
  resfile << "%ymin=" << y_min << endl;
  resfile << "%zmax=" << z_max << endl;
  resfile << "%zmin=" << z_min << endl;
  resfile << "%cmax=" << z_max << endl;
  resfile << "%cmin=" << z_min << endl;
  resfile << "%nsteps=20" << endl;

  for (int i = 0; i< row; i=i+1)
	{
	for(j=0; j<col; j++)
		{
		resfile << array[i*row + j] << endl;
		
		}
	}


    resfile.close();

  }
 else cout << "Unable to open file " << "surface_plot.mtv" << " !" << endl;

}

