void file_parser (string config_file)
{


string element, mode, block, name, key;
double value;

int key_flag = 0;
int class_counter = 0;
int measure_counter = 0;
int seeding_counter = 0;

block = "void";

options.immune_fraction = 0.0;
options.filename_base = "epidemic";
options.random_seed_set = false;
options.snapshot_interval_set = false;
options.incubation_time = 0;
options.incubation_time_uncertainty = 0;
options.recovery_time_uncertainty = 0;
options.includes_vaccination = false;


  ifstream cfgfile (config_file.c_str());
  if (cfgfile.is_open())
  {
    while (element !="end")
    {
      cfgfile >> element;



      //cout << element << " " << key_flag << endl;

      	if (key_flag == 1)
		{
		//cout << "reading value: " << element << endl;
		value = atof (element.c_str());
		}

   	if (key_flag == 0)
		{
		//cout << "Key flag is 0" << endl;


 		if (element == "filename_base") {key = "filename_base"; key_flag = 2;}
		else if (element == "disease") {block = "disease"; }
		else if (element == "simulation") {block = "simulation"; }
		else if (element == "population") {block = "population"; }
		else if (element == "measures") {block = "measures"; }
		else if (element == "seedings") {block = "seedings"; }
		else if (element == "class") {block = "class"; class_counter++;}
		else if (element == "measure") {block = "measure"; measure_counter++;}
		else if (element == "seeding") {block = "seeding"; seeding_counter++;}
		else {key = element; key_flag = 1;}
			

		}
	else if (key_flag == 1)
		{
		//cout << "parsing value: " << value << endl;
		if (block == "disease")
			{
			if (key == "recovery_time") {options.recovery_time = static_cast<int>(value);}
			if (key == "recovery_time_pm") {options.recovery_time_uncertainty = static_cast<int>(value);}
			if (key == "incubation_time") {options.incubation_time = static_cast<int>(value);}
			if (key == "incubation_time_pm") {options.incubation_time_uncertainty = static_cast<int>(value);}
			else if (key == "p_transmission") {options.transmission_probability = value;}
			//cout << "Key is now: " << key << " value: " << value << endl;
			}
		else if (block == "population")
			{
			if (key == "grid_size") {options.grid_size = static_cast<int>(value);}
			else if (key == "num_classes") 
				{
				options.num_classes = static_cast<int>(value);
				options.mobility = new int [options.num_classes];
				options.p_mobility = new double [options.num_classes];
				options.fraction = new double [options.num_classes];
				options.intfraction = new double [options.num_classes];
				}
			else if (key == "immune_fraction") {options.immune_fraction = value;} 
			}
		else if (block == "simulation")
			{
			if (key == "num_timesteps") {options.num_timesteps = static_cast<int>(value);}
			else if (key == "snapshot_interval") {options.snapshot_interval = static_cast<int>(value); options.snapshot_interval_set = true;}
			else if (key == "random_seed") {options.random_seed = static_cast<int>(value); options.random_seed_set = true;}
			}
		else if (block == "class")
			{
			if (key == "mobility") {options.mobility[class_counter-1] = static_cast<int>(value);}
			else if (key == "p_mobility") {options.p_mobility[class_counter-1] = value;}
			else if (key == "fraction") {options.fraction[class_counter-1] = value;}
			}
		else if (block == "measures")
			{
			if (key == "num_measures")
				{
				options.num_measures = static_cast<int>(value);
				options.m_transmission = new double [options.num_measures];
				options.m_p_factor = new double [options.num_measures];
				options.m_mobility = new int [options.num_measures];
				options.m_effectiveness = new double [options.num_measures];
				options.m_start = new int [options.num_measures];
				options.m_duration = new int [options.num_measures];
				options.m_num_vacc = new int [options.num_measures];

				for (int i=0; i< options.num_measures; i++)
					{
					options.m_effectiveness[i] = 1.0;
					options.m_mobility[i] = -1;
					options.m_transmission[i] = -1.0;
					options.m_p_factor[i] = 1.0;
					options.m_num_vacc[i] = 0;
					}
				}
			}
		else if (block == "seedings")
			{
			if (key == "num_seedings")
				{
				options.num_seedings = static_cast<int>(value);
				options.s_transmission = new double [options.num_seedings];
				options.s_time = new int [options.num_seedings];
				options.s_number = new int [options.num_seedings];
				options.s_tag = new int [options.num_seedings];

				for (int i=0; i< options.num_seedings; i++)
					{
					options.s_transmission[i] = 0.0;
					options.s_time[i] = -1;
					options.s_number[i] = 0;
					options.s_tag[i] = 1;
					}
				}
			}
		else if (block == "measure")
			{

			if (key == "start") {options.m_start[measure_counter-1] = static_cast<int>(value);}
			else if (key == "duration") {options.m_duration[measure_counter-1] = static_cast<int>(value);}
			else if (key == "mobility") {options.m_mobility[measure_counter-1] = static_cast<int>(value);}
			else if (key == "transmission") {options.m_transmission[measure_counter-1] = value;}
			else if (key == "transmission_factor") {options.m_p_factor[measure_counter-1] = value;}
			else if (key == "effectiveness") {options.m_effectiveness[measure_counter-1] = value;}
			else if (key == "vaccinations") 
				{
				options.m_num_vacc[measure_counter-1] = static_cast<int>(value);
				options.includes_vaccination = true;
				}
			}
		else if (block == "seeding")
			{
			if (key == "time") {options.s_time[seeding_counter-1] = static_cast<int>(value);}
			else if (key == "number") {options.s_number[seeding_counter-1] = static_cast<int>(value);}
			else if (key == "transmission") {options.s_transmission[seeding_counter-1] = value;}
			else if (key == "tag_index") {options.s_tag[seeding_counter-1] = static_cast<int>(value);}
			}

		key_flag = 0;
		}
	else if (key_flag == 2)
		{
		if (block == "simulation")
			{
			if (key == "filename_base") {options.filename_base = element;}
			}


		key_flag = 0;
		}

	

    }
    cfgfile.close();


    if (options.snapshot_interval_set == false)
	{
	options.snapshot_interval = options.num_timesteps;
	}

    options.intfraction[0] = options.fraction[0];

    for (int i=1; i< options.num_classes; i++)
	{
	options.intfraction[i] = options.intfraction[i-1] + options.fraction[i];
	}

    measures = new Measure [options.num_measures];
    for (int i=0; i<options.num_measures; i++)
	{

	if (options.m_num_vacc[i] == 0)
		{
		measures[i].init(options.m_start[i], options.m_duration[i], options.m_mobility[i], options.m_transmission[i], options.m_effectiveness[i]);
		}
	else
		{
		measures[i].init(options.m_start[i], options.m_duration[i], options.m_mobility[i], options.m_transmission[i], options.m_effectiveness[i], options.m_num_vacc[i]);
		}
	measures[i].set_p_factor(options.m_p_factor[i]);
	}

    seeds = new Seed [options.num_seedings];
    for (int i=0; i<options.num_seedings; i++)
	{
	seeds[i].init(options.s_time[i], options.s_number[i], options.s_transmission[i], options.s_tag[i]);
	}


   //cout << options.fraction[0] << " " << options.fraction[1] << " " << options.fraction[2] << endl;
   //cout << options.mobility[0] << " " << options.mobility[1] << " " << options.mobility[2] << endl;
   //cout << options.p_mobility[0] << " " << options.p_mobility[1] << " " << options.p_mobility[2] << endl;
   //cout << options.intfraction[0] << " " << options.intfraction[1] << " " << options.intfraction[2] << endl;
   //cout << options.filename_base << endl;
  }

  else cout << "Unable to open file " << config_file << " !" << endl;
}
