// options.hxx - options settable by the command line parser
//
// Written by Thorsten Renk, started 2020
//
// Copyright (C) 2020  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef OPTIONS_H
#define OPTIONS_H


class Options {
	public:


	// disease
	int recovery_time;
	int incubation_time;
	int recovery_time_uncertainty;
	int incubation_time_uncertainty;
	double transmission_probability;

	// population
	int grid_size;
	int num_classes;
	double immune_fraction;

	// simulation
	int num_timesteps;
	int snapshot_interval;
	std::string filename_base;
	bool random_seed_set;
	bool snapshot_interval_set;
	int random_seed;

	// mobility
	int *mobility;
	double *p_mobility;
	double *fraction;
	double *intfraction;

	//measures
	int num_measures;
	bool includes_vaccination;
	int *m_start;
	int *m_duration;
	int *m_mobility;
	int *m_num_vacc;
	double *m_transmission;
	double *m_p_factor;
	double *m_effectiveness;

	//seedings
	int num_seedings;
	int *s_time;
	int *s_number;
	int *s_tag;
	double *s_transmission;


};

#endif

