// measure.hxx -- class to define an epidemic restricting measure
//
// Written by Thorsten Renk, started 2020
//
// Copyright (C) 2020 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef MEASURE_H
#define MEASURE_H



#include <string>


class Measure {

	
	int start_time;
	int duration;
	int end_time;

	bool is_active;
	bool is_expired;
	bool restricts_mobility;
	bool restricts_transmission;
	bool includes_vaccination;

	int mobility;
	int num_vaccinations;
	double p_transmission;
	double p_factor;
	double effectivity;

	public:

	void init(int start_time, int duration, int mobility, double p_transmission, double effectivity);
	void init(int start_time, int duration, int mobility, double p_transmission, double effectivity, int n_vacc);
	void check(int time);
	void set_p_factor(double p_factor);

	int get_start_time();
	int get_end_time();

	int get_mobility();
	int get_num_vaccinations();

	bool get_active();
	bool get_expired();
	bool get_transmission_restrict();
	bool get_mobility_restrict();

	double get_p_transmission();	
	double get_p_factor();
	

};

#endif
