// measure.cxx -- class to define an epidemic restricting measure
//
// Written by Thorsten Renk, started 2020
//
// Copyright (C) 2020 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <math.h>
#include <cmath>
#include <iostream>

#include "measure.hxx"

using namespace std;

void Measure::init(int start_in, int duration, int mobility_in, double p_transmission_in, double effectivity_in)
{
is_active = false;
is_expired = false;
restricts_mobility = false;
restricts_transmission = false;
includes_vaccination = false;
num_vaccinations = 0;
p_factor = 1.0;
start_time = start_in;
end_time = start_time + duration;
if (mobility_in >= 0)
	{
	mobility = mobility_in;
	restricts_mobility = true;
	}


if (p_transmission_in >= 0.0)
	{
	p_transmission = p_transmission_in;
	restricts_transmission = true;
	}

effectivity = effectivity_in;
}


void Measure::init(int start_in, int duration, int mobility_in, double p_transmission_in, double effectivity_in, int num_vacc_in)
{
is_active = false;
is_expired = false;
restricts_mobility = false;
restricts_transmission = false;
includes_vaccination = false;
p_factor = 1.0;
start_time = start_in;
end_time = start_time + duration;
if (mobility_in >= 0)
	{
	mobility = mobility_in;
	restricts_mobility = true;
	}


if (p_transmission_in >= 0.0)
	{
	p_transmission = p_transmission_in;
	restricts_transmission = true;
	}

if (num_vacc_in > 0)
	{
	num_vaccinations = num_vacc_in;
	includes_vaccination = true;

	cout << "Vaccination!" << endl;
	}

effectivity = effectivity_in;
}

void Measure::check(int time)
{
if ((is_active == false) && (time == start_time))
	{
	is_active = true;
	//cout << "Measure active!" << endl;
	}
else if ((is_active == true) && (time == end_time))
	{
	is_active = false;
	is_expired = true;
	//cout << "Measure over!" << endl;
	}

}

void Measure::set_p_factor(double p_factor_in)
{
p_factor = p_factor_in;
if (p_factor < 1.0) 
	{
	p_transmission = 1.0;
	restricts_transmission = true;
	}
}

int Measure::get_start_time()
{
return start_time;
}

int Measure::get_end_time()
{
return end_time;
}

int Measure::get_num_vaccinations()
{
return num_vaccinations;
}

bool Measure::get_active()
{
return is_active;
}

bool Measure::get_expired()
{
return is_expired;
}


bool Measure::get_transmission_restrict()
{
return restricts_transmission;
}

bool Measure::get_mobility_restrict()
{
return restricts_mobility;
}

int Measure::get_mobility()
{
return mobility;
}

double Measure::get_p_transmission()
{
return p_transmission;
}

double Measure::get_p_factor()
{
return p_factor;
}


