// carrier.hxx -- class to define a potential epidemic carrier
//
// Written by Thorsten Renk, started 2020
//
// Copyright (C) 2020 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef CARRIER_H
#define CARRIER_H



#include <string>


class Carrier {

	int max_mobility;
	

	int sickness_duration;
	int pre_sickness_duration;
	int recovery_time;
	int incubation_time;
	
	int tag_index;

	bool is_infected;
	bool is_contagious;
	bool is_immune;
	bool is_immune_prior;
	bool is_vaccinated;
	bool is_prior_vaccinated;
	bool is_posterior_vaccinated;

	double transmission_probability;
	double movement_probability;
	

	public:

	void init (int max_mobility, double movement_probability, int recovery_time, int incubation_time, double transmission_probability); 


	void set_infected();
	void force_infected();
	void force_immune();
	void progress_sickness();
	void vaccinate();
	void vaccinate(double p_immune, double rand);
	
	void set_p_transmission (double p_transmission);
	void set_tag_index (int index);

	int get_mobility();
	int get_tag_index();
	double get_transmission();
	bool get_immune();
	bool get_infected();
	bool get_contagious();
	bool get_vaccinated();
	bool get_prior_vaccinated();
	bool get_posterior_vaccinated();


};

#endif
