// carrier.cxx -- class to define a potential epidemic carrier
//
// Written by Thorsten Renk, started 2020
//
// Copyright (C) 2020 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <math.h>
#include <cmath>
#include <iostream>

#include "carrier.hxx"

using namespace std;

void Carrier::init (int max_mobility_in, double movement_probability_in, int recovery_time_in, int incubation_time_in, double transmission_probability_in)
{
is_infected = false;
is_immune = false;
is_immune_prior = false;
is_contagious = false;
is_vaccinated = false;
is_prior_vaccinated = false;
is_posterior_vaccinated = false;
sickness_duration = -1;
pre_sickness_duration = 0;

max_mobility = max_mobility_in;
recovery_time = recovery_time_in;
incubation_time = incubation_time_in;

tag_index = 1;

movement_probability = movement_probability_in;
transmission_probability = transmission_probability_in;


}

void Carrier::force_infected()
{
is_infected = true;
}

void Carrier::force_immune()
{
is_immune_prior = true;
}


void Carrier::set_infected()
{
if ((is_immune == false) && (is_immune_prior == false))
	{is_infected = true;}
}


void Carrier::vaccinate()
{
if (is_vaccinated == false)
	{
	is_vaccinated = true;
	if (is_immune)
		{
		is_posterior_vaccinated = true;
		}
	else	
		{	
		is_immune = true;
		is_prior_vaccinated = true;
		}
	}
}

void Carrier::vaccinate(double p_immune, double rand)
{

if (is_vaccinated == false)
	{

	if (is_immune)
		{
		is_posterior_vaccinated = true;
		}

	if (rand < p_immune)
		{
		is_immune = true;
		is_prior_vaccinated = true;
		}
	is_vaccinated = true;
	}

}


void Carrier::progress_sickness()
{

pre_sickness_duration++;

if (pre_sickness_duration > incubation_time)
	{
	is_contagious = true;

	sickness_duration++;

	if (sickness_duration > recovery_time)
		{
		is_contagious = false;
		is_infected = false;
		is_immune = true;
		}
	}
}

void Carrier::set_p_transmission(double p_transmission)
{
transmission_probability = p_transmission;
}

void Carrier::set_tag_index(int index)
{
tag_index = index;
}


double Carrier::get_transmission()
{
return transmission_probability;
}

bool Carrier::get_infected()
{
return is_infected;
}

bool Carrier::get_contagious()
{
return is_contagious;
}

bool Carrier::get_immune()
{
return is_immune;
}

bool Carrier::get_vaccinated()
{
return is_vaccinated;
}

bool Carrier::get_prior_vaccinated()
{
return is_prior_vaccinated;
}

bool Carrier::get_posterior_vaccinated()
{
return is_posterior_vaccinated;
}

int Carrier::get_mobility()
{
return max_mobility;
}

int Carrier::get_tag_index()
{
return tag_index;
}
