// unit.hxx -- class to define a battle unit
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2022 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef UNIT_H
#define UNIT_H



#include <string>


class Unit {

	std::string name;
	std::string type;
	std::string tag;
	std::string formation;

	std::string current_order;
	std::string secondary_order;
	std::string order_upon_contact;
	std::string order_upon_victory;
	std::string order_upon_position_reached;
	std::string order_upon_ammo_finished;
	std::string order_upon_target_destroyed;
	std::string projectile_type;

	std::string mount_description;

	std::string morale_status;

	bool is_in_formation;
	bool is_inactive;
	bool is_fled;
	bool is_surrendered;
	bool is_destroyed;
	bool is_firing;
	bool has_formation;
	bool has_ranged;
	bool has_mounts;
	bool has_assembly;

	bool message_flag_morale;
	bool flag_hit_and_run;
	bool flag_charge_veto;

	int army_id;

	int num_soldiers;
	int num_files;
	int num_ranks;
	int equiv_num_close_combat;
	int equiv_num_ranged_attack;
	int equiv_num_ranged_damage;
	int num_shots;
	int max_num_shots;

	int soldiers_per_mount;
	
	int tgt_id;
	int range_flag;


	int num_contacts;
	int num_contacts_last;
	int num_friendly_contacts;
	int contact_array[10];

	double contact_density;

	double speed;
	double attack;
	double damage;
	double armor;
	double ranged_attack;
	double ranged_defense;
	double ranged_damage;
	double range;
	double shot_interval;
	double projectile_drag;
	double firing_timer;
	double charge_veto_timer;
	double under_fire_timer;
	
	double slow_speed;
	double advance_speed;
	double melee_speed;
	double rush_speed;
	double run_speed;
	double next_speed;

	double file_spacing;
	double rank_spacing;
	double density;
	double push_density;
	double soldier_mass;
	double size_file;
	double size_rank;

	double penalty_flank_attack;
	double penalty_rear_attack;
	double penalty_without_formation;



	double bonus_mounted_charge;

	double stamina;

	double fraction_untouched;
	double fraction_injured;
	double fraction_incapacitated;
	double fraction_dead;
	double fraction_fighting;

	double pos_x;
	double pos_y;
	double dir_x;
	double dir_y;
	double forced_motion;
	double ang;
	double tgt_dir_x;
	double tgt_dir_y;
	double tgt_ang;
	double tgt_pos_x;
	double tgt_pos_y;
	double assembly_pos_x;
	double assembly_pos_y;
	double current_speed;
	double speed_last;
	double dist_to_fire;
	double turn_rad_per_min;

	double terrain_limit_speed;
	double terrain_slowdown_factor;
	double terrain_slope_across;
	double terrain_slope_along;
	double terrain_surface_slowdown_factor;
	double terrain_surface_limit_speed;

	double mount_mass;

	double dist_to_engage;
	double dist_to_disengage;


	double morale;

	double rnd (double min, double max);
	double normalize_angle_180(double ang_in);
	double normalize_angle_360(double ang_in);
	void vec_to_ang(void);
	void ang_to_vec(void);

	public:



	void init(std::string name, std::string type, double speed, double attack, double damage, double armor);
	void set_file_spacing(double spacing);
	void set_rank_spacing(double spacing);
	void set_spacings(double file, double rank);
	void set_tag(std::string tag);
	void set_morale(double morale);
	void set_ranged_combat(double ranged_attack, double ranged_damage, double range, double shots_per_min, int num_shots, std::string ptype);
	void set_mounted_combat(int soldiers_per_mount, int equiv_combat_power, double mount_mass, std::string name);
	void set_position(double x, double y);
	void set_direction(double vx, double vy);
	void set_assembly_point(double x, double y);
	void set_init_direction(double vx, double vy);
	void set_terrain_effects(double along, double across);
	void set_surface_effects(double, double);
	void set_parameter(std::string par, int value);
	void set_parameter(std::string par, double value);
	void assign_formation(int file, int rank);
	void assign_to_army(int army);
	void assign_number(int num);
	void do_damage(double l, double h, double d);
	void scatter();
	void check_morale(double difficulty);
	void set_initial_orders(std::string order, std::string upon_contact, std::string upon_victory, std::string upon_position, std::string secondary);
	void set_initial_ranged_orders(std::string upon_ammo, std::string upon_target);
	void set_initial_order_params(double val1, double val2);
	void set_order (std::string condition, std::string order);
	
	void give_order(std::string order);
	void give_order(std::string order, double tgt_x, double tgt_y);
	void give_order(std::string order, double dir);
	void give_order(std::string order, int id);

	void move(double timefrac);
	void contact_move(double timefrac, double dir_x, double dir_y, double speed); 
	void register_contact(int id, double pos2_x, double pos2_y);
	void register_friendly_contact(int id, double density);
	void register_event(std::string event);
	void clear_contacts(void);
	void check_contact_broken(void);

	void list(void);
	void list_damage(void);
	void report_orders(void);
	void report_internal(void);
	void report_position(void);

	bool get_inactive(void);
	bool get_fled(void);
	bool get_mounted(void);
	bool check_range(void);

	bool get_flag(std::string flag);
	void set_flag(std::string flag, bool value);

	int get_army_id(void);
	int get_num_contacts(void);
	int get_tgt_id(void);
	int get_ready_to_fire(double dt);
	int get_num_shots(void);
	int get_max_num_shots(void);
	int get_nominal_num_soldiers(void);
	int get_current_num_soldiers(void);
	int get_equiv_num_soldiers_cc(void);
	int get_equiv_num_soldiers_ra(void);
	int get_equiv_num_soldiers_rd(void);

	double get_speed(void);
	double get_attack(void);
	double get_ranged_attack(void);
	double get_ranged_defense(void);
	double get_damage(void);
	double get_ranged_damage(void);
	double get_projectile_drag(void);
	double get_armor(void);
	double get_range();

	double get_current_speed(void);
	double get_push_density(void);
	double get_density(void);

	double get_pos_x(void);
	double get_pos_y(void);

	double get_dir_x(void);
	double get_dir_y(void);
	double get_dir(void);

	double get_forced_motion(void);


	double get_contact_distance(void);
	double get_contact_distance(double pos_x, double pos_y);
	double get_dist_to_engage(void);
	double get_dist_to_disengage(void);
	double get_dist_to_fire(void);

	double get_penalty_flank_attack(void);
	double get_penalty_rear_attack(void);

	double get_health(void);

	
	std::string get_name(void);
	std::string get_tag(void);
	std::string get_order(void);
	std::string get_secondary_order(void);
	std::string get_morale(void);
	std::string get_type(void);

};

#endif
