// parser.hxx -- parser for config files
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2022  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301



Options file_parser (string config_file)
{
string element, star_type, mode, block, key;

double value;

int key_flag = 0; // initially expect a keyword
int n_unit_type = 0;
int i_unit_type = 0;
int n_unit = 0;
int n_unit_direct = 0;
int i_unit = 0;
int n_unit_line = 0;
int i_unit_line = 0;
int n_formation = 0;
int i_formation = 0;
int n_evd = 0;
int i_evd = 0;
int n_event_trigger = 0;
int i_event_trigger = 0;
int n_event_trigger_fd = 0;
int n_event_trigger_ud = 0;
int n_event_trigger_lc = 0;
int n_event_trigger_ue = 0;
int n_event_result = 0;
int i_event_result = 0;
int n_event_logic = 0;
int i_event_logic = 0;
bool unit_line_flag = false;
bool num_unit_flag = false;

mode = "void";
block = "void";
key = "void";

// preparse to see how many unit types, units and formations we need


  ifstream cfgfile (config_file.c_str());
  if (cfgfile.is_open())
  {
    while (element !="end")
    {
      cfgfile >> element;
	if (element == "unit_type") {n_unit_type++;}
	else if (element == "unit") {n_unit++;}
	else if (element == "formation") {n_formation++;}
	else if (element == "unit_line") {unit_line_flag = true; n_unit_line++;}
	else if (element == "num_units") {if (unit_line_flag) {num_unit_flag = true;}}
	else if (element == "destruction") {n_evd++;}
	else if (element == "event_trigger") {n_event_trigger++;}
	else if (element == "event_result") {n_event_result++;}
	else if (element == "event_logic") {n_event_logic++;}
	else if (num_unit_flag) {n_unit += static_cast<int>(atof (element.c_str())); unit_line_flag = false; num_unit_flag = false;}
    }
  //cfgfile.close(); cout << "closing" << endl;	
  }


element = "";
cfgfile.seekg( 0, cfgfile.beg);

//cout << "Preparsing: Unit types: " << n_unit_type << " units: "<< n_unit << " lines: " << n_unit_line <<" formations: " << n_formation << " global conditions: " << n_evd << endl; 

Options options_internal (n_unit_type, n_unit, n_unit_line, n_formation, n_evd, n_event_trigger, n_event_result, n_event_logic);

for (int i=0; i<n_unit_type; i++)
	{
	options_internal.unit_type_ranged_weapons[i] = false;
	options_internal.unit_type_mounted[i] = false;
	options_internal.unit_type_base_resistance[i] = 0;
	options_internal.unit_type_num_soldiers[i] = 0;
	options_internal.unit_type_ranged_attack_strength[i] = 0.0;
	options_internal.unit_type_ranged_defense[i] = 0.0;
	options_internal.unit_type_range[i] = 0.0;
	options_internal.unit_type_ranged_damage[i] = 0.0;
	options_internal.unit_type_shots_per_min[i] = 0.0;
	options_internal.unit_type_num_shots[i] = 0;
	options_internal.unit_type_turn_deg_per_min[i] = 180.0;
	options_internal.unit_type_mount_description[i] = "";
	options_internal.unit_type_ptype[i] = "";
	options_internal.unit_type_soldiers_per_mount[i] = 1;
	options_internal.unit_type_equiv_combat_power[i] = 1;
	options_internal.unit_type_mount_mass[i] = 0.0;
	options_internal.unit_type_num_ranks[i] = 0;
	options_internal.unit_type_num_files[i] = 0;
	options_internal.unit_type_penalty_flank_attack[i] = -1.0;
	options_internal.unit_type_penalty_rear_attack[i] = -1.0;
	options_internal.unit_type_bonus_mounted_charge[i] = 0.0;

	}

for (int i=0; i< n_unit; i++)
	{
	options_internal.unit_morale[i] = 8;
	options_internal.unit_init_order[i] = "advance";
	options_internal.unit_init_uc[i] = "attack";
	options_internal.unit_init_uv[i] = "seek_enemy";
	options_internal.unit_init_up[i] = "halt";
	options_internal.unit_init_ua[i] = "seek_enemy";
	options_internal.unit_init_ut[i] = "fire_upon";
	options_internal.unit_init_sec[i] = "none";
	options_internal.unit_init_dist_to_engage[i] = 30.0;
	options_internal.unit_init_dist_to_disengage[i] = 0.0;
	options_internal.unit_init_dist_to_fire[i] = 50.0;
	options_internal.unit_assembly_x[i] = -1.0;
	options_internal.unit_assembly_y[i] = -1.0;
	options_internal.unit_target[i] = "none";
	options_internal.unit_default_orders[i] = true;
	}

for (int i=0; i < n_unit_line; i++)
	{
	options_internal.line_morale[i] = 8;
	}

for (int i=0; i< n_formation; i++)
	{
	options_internal.formation_dist_to_fire[i] = -1.0;
	options_internal.formation_dist_to_engage[i] = -1.0;
	options_internal.formation_dist_to_disengage[i] = -1.0;
	options_internal.formation_speed[i] = "";
	options_internal.formation_ua[i] = "";
	options_internal.formation_ut[i] = "";
	options_internal.formation_uc[i] = "";
	options_internal.formation_up[i] = "";
	options_internal.formation_uv[i] = "";
	}
for (int i=0; i< n_evd; i++)
	{
	options_internal.global_morale_check_destruction[i] = 0.0; 
	}
for (int i=0; i< n_event_trigger; i++)
	{
	options_internal.event_trigger_formation[i] = "";
	options_internal.event_trigger_line_crossed[i] = "";
	options_internal.event_trigger_line_crossed_2[i] = "";
	options_internal.event_trigger_line_crossed_3[i] = "";
	options_internal.event_trigger_line_crossed_4[i] = "";
	options_internal.event_trigger_line_crossed_5[i] = "";
	options_internal.event_trigger_unit[i] = "";
	options_internal.event_trigger_unit_2[i] = "";
	options_internal.event_trigger_unit_3[i] = "";
	options_internal.event_trigger_unit_4[i] = "";
	options_internal.event_trigger_unit_5[i] = "";
	options_internal.event_trigger_ue[i] = "";
	options_internal.event_trigger_ue_2[i] = "";
	options_internal.event_trigger_ue_3[i] = "";
	options_internal.event_trigger_ue_4[i] = "";
	options_internal.event_trigger_ue_5[i] = "";
	options_internal.event_trigger_ud_fraction[i] = 1.0;
	options_internal.event_trigger_fd_fraction[i] = 1.0;
	options_internal.event_trigger_logic[i] = "";
	}
for (int i=0; i< n_event_result; i++)
	{
	options_internal.event_result_formation[i] = "";
	options_internal.event_result_unit[i] = "";
	options_internal.event_result_order_par_1[i] = -1.0;
	options_internal.event_result_order_par_2[i] = -1.0;
	}
for (int i=0; i< n_event_logic; i++)
	{
	options_internal.event_logic_input_1[i] = "";
	options_internal.event_logic_input_2[i] = "";
	options_internal.event_logic_input_3[i] = "";
	options_internal.event_logic_input_4[i] = "";
	options_internal.event_logic_input_5[i] = "";
	options_internal.event_logic_type[i] = "AND";
	options_internal.event_logic_timer[i] = 0.0;
	}


n_unit_type = 0;
n_unit = 0;
n_unit_line = 0;
n_formation = 0;
n_event_trigger = 0;
n_event_result = 0;
n_event_logic = 0;


options_internal.config_random_range = 100.0;
options_internal.config_battle_verbose = false;
options_internal.config_battle_terse = false;
options_internal.config_random_seed_set = false;
options_internal.config_colors = false;
options_internal.config_auto_battlefield_display = false;
options_internal.config_auto_report_units = false;
options_internal.config_auto_report_soldiers = false;
options_internal.config_events_verbose = false;
options_internal.config_check_morale = false;
options_internal.config_check_los = false;
options_internal.config_internal_timestep = 0.02;
options_internal.config_battle_timestep = 1.0;
options_internal.config_damage_multiplier = 1.0;
options_internal.config_charge_threshold = 250.0;
options_internal.config_initial_zoom = 10.0;

options_internal.config_army_designation_1 = "Army A";
options_internal.config_army_designation_2 = "Army B";

options_internal.config_tag_length = 2;
options_internal.config_n_iterations = 1;

options_internal.config_y_limit_1 = 0.0;
options_internal.config_y_limit_2 = 0.0;

options_internal.field_color_coding = 0;
options_internal.field_aspect_factor = 1;

options_internal.terrain_defined = false;
options_internal.terrain_surface_defined = false;
options_internal.terrain_elevation_map_filename = "";
options_internal.terrain_surface_map_filename = "";
options_internal.terrain_plot_filename = "terrain_plot.dat";
options_internal.terrain_surface_atlas_filename = "";
options_internal.terrain_surface_map_size_x = 0;
options_internal.terrain_surface_map_size_y = 0;

options_internal.event_management = false;
			

//cout << "Hello!" << endl;

 // ifstream cfgfile (config_file.c_str());
  if (cfgfile.is_open())
  {
    while (element !="end")
    {
	
      cfgfile >> element;
     // cout << element << " " << key_flag << '\n';

      	if (key_flag == 1)
		{
		value = atof (element.c_str());
		}

   	if (key_flag == 0)
		{
		//cout << "parsing key: " << element << endl;
		if (element == "input") {mode = "input"; block = "void";}
		else if (element == "unit_type") {mode = "void"; block = "unit_type"; n_unit_type++; i_unit_type = n_unit_type-1;}
		else if (element == "unit") {mode = "void"; block = "unit"; n_unit++; i_unit = n_unit-1;}
		else if (element == "unit_line") {mode = "void"; block = "unit_line"; n_unit_line++; i_unit_line = n_unit_line-1;}
		else if (element == "formation") {mode = "void"; block = "formation"; n_formation++; i_formation = n_formation-1;}
		else if (element == "event_trigger") {mode = "void"; block = "event_trigger"; n_event_trigger++; i_event_trigger = n_event_trigger-1;}
		else if (element == "event_result") {mode = "void"; block = "event_result"; n_event_result++; i_event_result = n_event_result-1;}
		else if (element == "event_logic") {mode = "void"; block = "event_logic"; n_event_logic++; i_event_logic = n_event_logic-1;}
		else if (element == "config") {mode = "void"; block = "config";}
		else if (element == "battlefield") {mode = "void"; block = "battlefield";}
		else if (element == "terrain") {mode = "void"; block = "terrain";}
		else if (element == "global_morale_check") {mode = "void"; block = "global_morale_check";}
		else if (element == "end") {mode = "end";}
		else if (element == "name") {key = element; key_flag = 2;}
		else if (element == "tag") {key = element; key_flag = 2;}
		else if (element == "type") {key = element; key_flag = 2;}
		else if (element == "assign_to") {key = element; key_flag = 2;}
		else if (element == "battle_verbose") {key = element; key_flag = 2;}
		else if (element == "battle_terse") {key = element; key_flag = 2;}
		else if (element == "events_verbose") {key = element; key_flag = 2;}
		else if (element == "auto_display") {key = element; key_flag = 2;}
		else if (element == "auto_report_units") {key = element; key_flag = 2;}
		else if (element == "colors") {key = element; key_flag = 2;}
		else if (element == "check_morale") {key = element; key_flag = 2;}
		else if (element == "check_los") {key = element; key_flag = 2;}
		else if (element == "order") {key = element; key_flag = 2;}
		else if (element == "secondary_order") {key = element; key_flag = 2;}
		else if (element == "upon_position") {key = element; key_flag = 2;}
		else if (element == "upon_victory") {key = element; key_flag = 2;}
		else if (element == "upon_contact") {key = element; key_flag = 2;}
		else if (element == "upon_ammo") {key = element; key_flag = 2;}
		else if (element == "upon_target") {key = element; key_flag = 2;}
		else if (element == "army_designation_1") {key = element; key_flag = 2;}
		else if (element == "army_designation_2") {key = element; key_flag = 2;}
		else if (element == "destruction") {key = element; key_flag = 2;}
		else if (element == "mount") {key = element; key_flag = 2;}
		else if (element == "target") {key = element; key_flag = 2;}
		else if (element == "projectile_type") {key = element; key_flag = 2;}
		else if (element == "elevation_map") {key = element; key_flag = 2;}
		else if (element == "elevation_grid") {key = element; key_flag = 2;}
		else if (element == "terrain_plot_name") {key = element; key_flag = 2;}
		else if (element == "surface_map") {key = element; key_flag = 2;}
		else if (element == "surface_atlas") {key = element; key_flag = 2;}
		else if (element == "id") {key = element; key_flag = 2;}
		else if (element == "input_1") {key = element; key_flag = 2;}
		else if (element == "input_2") {key = element; key_flag = 2;}
		else if (element == "input_3") {key = element; key_flag = 2;}
		else if (element == "input_4") {key = element; key_flag = 2;}
		else if (element == "input_5") {key = element; key_flag = 2;}
		else if (element == "type") {key = element; key_flag = 2;}
		else if (element == "logic") {key = element; key_flag = 2;}
		else if (element == "formation_destroyed") {key = element; key_flag = 2;}
		else if (element == "unit_destroyed") {key = element; key_flag = 2;}
		else if (element == "unit_destroyed_2") {key = element; key_flag = 2;}
		else if (element == "unit_destroyed_3") {key = element; key_flag = 2;}
		else if (element == "unit_destroyed_4") {key = element; key_flag = 2;}
		else if (element == "unit_destroyed_5") {key = element; key_flag = 2;}
		else if (element == "unit_engaged") {key = element; key_flag = 2;}
		else if (element == "unit_engaged_2") {key = element; key_flag = 2;}
		else if (element == "unit_engaged_3") {key = element; key_flag = 2;}
		else if (element == "unit_engaged_4") {key = element; key_flag = 2;}
		else if (element == "unit_engaged_5") {key = element; key_flag = 2;}
		else if (element == "line_crossed") {key = element; key_flag = 2;}
		else if (element == "line_crossed_2") {key = element; key_flag = 2;}
		else if (element == "line_crossed_3") {key = element; key_flag = 2;}
		else if (element == "line_crossed_4") {key = element; key_flag = 2;}
		else if (element == "line_crossed_5") {key = element; key_flag = 2;}
		else if (element == "trigger_id") {key = element; key_flag = 2;}
		else if (element == "command_formation") {key = element; key_flag = 2;}
		else if (element == "command_unit") {key = element; key_flag = 2;}
		else if ((element == "speed") && (block == "formation")) {key = element; key_flag = 2;}
		else {key = element; key_flag = 1;}
		}

   	else if (key_flag == 1)
		{
		//cout << "parsing value: " << value << endl;
		if (block == "unit_type")
			{
			if (key == "speed") {options_internal.unit_type_movement_speed[i_unit_type] = value;}
			else if (key == "armor") {options_internal.unit_type_armor_value[i_unit_type] = value;}
			else if (key == "armour") {options_internal.unit_type_armor_value[i_unit_type] = value;}
			else if (key == "resistance") {options_internal.unit_type_base_resistance[i_unit_type] = value;}
			else if (key == "attack") {options_internal.unit_type_base_attack_strength[i_unit_type] = value;}
			else if (key == "ranged_attack") {options_internal.unit_type_ranged_attack_strength[i_unit_type] = value;}
			else if (key == "ranged_defense") {options_internal.unit_type_ranged_defense[i_unit_type] = value;}
			else if (key == "damage") {options_internal.unit_type_weapon_damage[i_unit_type] = value;}
			else if (key == "ranged_damage") {options_internal.unit_type_ranged_damage[i_unit_type] = value;}
			else if (key == "range") {options_internal.unit_type_range[i_unit_type] = value;}
			else if (key == "shots_per_min") {options_internal.unit_type_shots_per_min[i_unit_type] = value;}
			else if (key == "turn_deg_per_min") {options_internal.unit_type_turn_deg_per_min[i_unit_type] = value;}
			else if (key == "penalty_flank_attack") {options_internal.unit_type_penalty_flank_attack[i_unit_type] = value;}
			else if (key == "penalty_rear_attack") {options_internal.unit_type_penalty_rear_attack[i_unit_type] = value;}
			else if (key == "bonus_mounted_charge") {options_internal.unit_type_bonus_mounted_charge[i_unit_type] = value;}
			else if (key == "mount_weight") {options_internal.unit_type_mount_mass[i_unit_type] = value;}
			else if (key == "num_ranks"){options_internal.unit_type_num_ranks[i_unit_type] = static_cast<int>(value);}
			else if (key == "num_files"){options_internal.unit_type_num_files[i_unit_type] = static_cast<int>(value);}
			else if (key == "num_soldiers"){options_internal.unit_type_num_soldiers[i_unit_type] = static_cast<int>(value);}
			else if (key == "num_shots"){options_internal.unit_type_num_shots[i_unit_type] = static_cast<int>(value);}
			else if (key == "soldiers_per_mount"){options_internal.unit_type_soldiers_per_mount[i_unit_type] = static_cast<int>(value);}
			else if (key == "equiv_combat_power"){options_internal.unit_type_equiv_combat_power[i_unit_type] = static_cast<int>(value);}
			else {cout << "Keyword " << key << " not recognized in context 'unit_type', exiting..." << endl; exit(0);}
			}
		else if (block == "unit")
			{
			if (key == "army"){options_internal.unit_army[i_unit] = static_cast<int>(value);}
			else if (key == "pos_x") {options_internal.unit_init_pos_x[i_unit] = value;}
			else if (key == "pos_y") {options_internal.unit_init_pos_y[i_unit] = value;}
			else if (key == "dir_x") {options_internal.unit_init_dir_x[i_unit] = value;}
			else if (key == "dir_y") {options_internal.unit_init_dir_y[i_unit] = value;}
			else if (key == "morale") {options_internal.unit_morale[i_unit] = value;}
			else if (key == "tgt_x") {options_internal.unit_tgt_x[i_unit] = value;}
			else if (key == "tgt_y") {options_internal.unit_tgt_y[i_unit] = value;}
			else if (key == "assembly_x") {options_internal.unit_assembly_x[i_unit] = value; }
			else if (key == "assembly_y") {options_internal.unit_assembly_y[i_unit] = value; }
			else if (key == "order_par_1") {options_internal.unit_init_order_par_1[i_unit] = value;}
			else if (key == "order_par_2") {options_internal.unit_init_order_par_2[i_unit] = value;}
			else if (key == "dist_to_engage") {options_internal.unit_init_dist_to_engage[i_unit] = value;}
			else if (key == "dist_to_disengage") {options_internal.unit_init_dist_to_disengage[i_unit] = value;}
			else if (key == "dist_to_fire") {options_internal.unit_init_dist_to_fire[i_unit] = value;}
			else {cout << "Keyword " << key << " not recognized in context 'unit', exiting..." << endl; exit(0);}
			}
		else if (block == "unit_line")
			{
			if (key == "army"){options_internal.line_army[i_unit_line] = static_cast<int>(value);}
			else if (key == "pos_x") {options_internal.line_init_pos_x[i_unit_line] = value;}
			else if (key == "pos_y") {options_internal.line_init_pos_y[i_unit_line] = value;}
			else if (key == "spacing_x") {options_internal.line_spacing_x[i_unit_line] = value;}
			else if (key == "spacing_y") {options_internal.line_spacing_y[i_unit_line] = value;}
			else if (key == "dir_x") {options_internal.line_init_dir_x[i_unit_line] = value;}
			else if (key == "dir_y") {options_internal.line_init_dir_y[i_unit_line] = value;}
			else if (key == "morale") {options_internal.line_morale[i_unit_line] = value;}
			else if (key == "num_units"){options_internal.line_num_units[i_unit_line] = static_cast<int>(value);}
			else {cout << "Keyword " << key << " not recognized in context 'unit_line', exiting..." << endl; exit(0);}
			}
		else if (block == "formation")
			{
			if (key == "order_par_1") {options_internal.formation_order_par_1[i_formation] = value;}
			else if (key == "order_par_2") {options_internal.formation_order_par_2[i_formation] = value;}
			else if (key == "dist_to_engage") {options_internal.formation_dist_to_engage[i_formation] = value; }
			else if (key == "dist_to_disengage") {options_internal.formation_dist_to_disengage[i_formation] = value; }
			else if (key == "dist_to_fire") {options_internal.formation_dist_to_fire[i_formation] = value;}
			else {cout << "Keyword " << key << " not recognized in this context, exiting..." << endl; exit(0);}		
			}
		else if (block == "battlefield")
			{
			if (key == "size_x") {options_internal.field_size_x = static_cast<int>(value);}
			else if (key == "size_y") {options_internal.field_size_y = static_cast<int>(value);}
			else if (key == "scale") {options_internal.field_scale = value;}
			else if (key == "aspect_ratio") {options_internal.field_aspect_factor = static_cast<int>(value);}
			else {cout << "Keyword " << key << " not recognized in this context, exiting..." << endl; exit(0);}
			}
		else if (block == "config")
			{
			if (key == "run_iterations") {options_internal.config_n_iterations = static_cast<int>(value);}
			else if (key == "y_limit_1") {options_internal.config_y_limit_1 = value;}
			else if (key == "y_limit_2") {options_internal.config_y_limit_2 = value;}
			else if (key == "damage_multiplier") {options_internal.config_damage_multiplier = value;}
			else if (key == "internal_timestep") {options_internal.config_internal_timestep = value;}
			else if (key == "battle_timestep") {options_internal.config_battle_timestep = value;}
			else if (key == "tag_length") {options_internal.config_tag_length = static_cast<int>(value);}
			else if (key == "initial_zoom") {options_internal.config_initial_zoom = value;}
			else {cout << "Keyword " << key << " not recognized in this context, exiting..." << endl; exit(0);}
			}
		else if (block == "terrain")
			{
			if (key == "surface_map_size_x") {options_internal.terrain_surface_map_size_x = static_cast<int>(value);}
			else if (key == "surface_map_size_y") {options_internal.terrain_surface_map_size_y = static_cast<int>(value);}
			}
		else if (block == "event_result")
			{
			if (key == "order_par_1") {options_internal.event_result_order_par_1[i_event_result] = value;}
			else if (key == "order_par_2") {options_internal.event_result_order_par_2[i_event_result] = value;}
			}
		else if (block == "event_logic")
			{
			if (key == "timer") {options_internal.event_logic_timer[i_event_logic] = value;}
			}
		else if (block == "event_trigger")
			{
			if (key == "unit_destroyed_fraction") {options_internal.event_trigger_ud_fraction[i_event_trigger] = value;}
			else if (key == "formation_destroyed_fraction") {options_internal.event_trigger_fd_fraction[i_event_trigger] = value;}
			else if (key == "line_crossed_y") {options_internal.event_trigger_lc_pos[i_event_trigger] = value;}
			else if (key == "line_crossed_sign") {options_internal.event_trigger_lc_sign[i_event_trigger] = static_cast<int>(value);}
			}
		else if (block == "global_morale_check")
			{
			if (key == "difficulty")
				{
				if (i_evd == 0) {i_evd = 1;}
				options_internal.global_morale_check_difficulty[i_evd-1] = value; 
				}
			else {cout << "Keyword " << key << " not recognized in this context, exiting..." << endl; exit(0);}
			}
		else 	
			{
			cout << "Keyword " << block << " not recognized in block definition context, exiting..." << endl;
			exit(0);
			}
	
		key_flag = 0;
		}

	else if (key_flag == 2)
		{
		if (block == "unit_type")
			{
			if (key == "name") {options_internal.unit_type_description[i_unit_type] = element;}
			else if (key == "mount") {options_internal.unit_type_mount_description[i_unit_type] = element;}
			else if (key == "projectile_type") {options_internal.unit_type_ptype[i_unit_type] = element;}
			}
		else if (block == "unit")
			{
			if (key == "name") {options_internal.unit_name[i_unit] = element;}
			else if (key == "tag") {options_internal.unit_tag[i_unit] = element;}
			else if (key == "type") {options_internal.unit_type[i_unit] = element;}
			else if (key == "order") {options_internal.unit_init_order[i_unit] = element; options_internal.unit_default_orders[i_unit] = false;}
			else if (key == "upon_position") {options_internal.unit_init_up[i_unit] = element; options_internal.unit_default_orders[i_unit] = false;}
			else if (key == "upon_victory") {options_internal.unit_init_uv[i_unit] = element; options_internal.unit_default_orders[i_unit] = false;}
			else if (key == "upon_contact") {options_internal.unit_init_uc[i_unit] = element; options_internal.unit_default_orders[i_unit] = false;}
			else if (key == "upon_ammo") {options_internal.unit_init_ua[i_unit] = element; options_internal.unit_default_orders[i_unit] = false;}
			else if (key == "upon_target") {options_internal.unit_init_ut[i_unit] = element; options_internal.unit_default_orders[i_unit] = false;}
			else if (key == "secondary_order") {options_internal.unit_init_sec[i_unit] = element; options_internal.unit_default_orders[i_unit] = false;}
			else if (key == "assign_to") {options_internal.unit_formation[i_unit] = element;}
			else if (key == "target") {options_internal.unit_target[i_unit] = element;}
			else {cout << "Keyword " << key << " not recognized in context 'unit', exiting..." << endl; exit(0);}
			}
		else if (block == "unit_line")
			{
			if (key == "name") {options_internal.line_name_prefix[i_unit_line] = element;}
			else if (key == "tag") {options_internal.line_tag_prefix[i_unit_line] = element;}
			else if (key == "type") {options_internal.line_type[i_unit_line] = element;}
			else if (key == "assign_to") {options_internal.line_formation[i_unit_line] = element;}
			else {cout << "Keyword " << key << " not recognized in context 'unit_line', exiting..." << endl; exit(0);}
			}
		else if (block == "formation")
			{
			if (key == "name") {options_internal.formation_name[i_formation] = element;}
			else if (key == "order") {options_internal.formation_order[i_formation] = element;}
			else if (key == "upon_position") {options_internal.formation_up[i_formation] = element;}
			else if (key == "upon_victory") {options_internal.formation_uv[i_formation] = element;}
			else if (key == "upon_contact") {options_internal.formation_uc[i_formation] = element;}
			else if (key == "upon_ammo") {options_internal.formation_ua[i_formation] = element;}
			else if (key == "upon_target") {options_internal.formation_ut[i_formation] = element;}
			else if (key == "secondary_order") {options_internal.formation_sec[i_formation] = element;}
			else if (key == "speed") {options_internal.formation_speed[i_formation] = element;}
			else {cout << "Keyword " << key << " not recognized in context 'formation', exiting..." << endl; exit(0);}
			}
		else if (block == "terrain")
			{
			if (key == "elevation_map") {options_internal.terrain_elevation_map_filename = element; options_internal.terrain_defined = true;}
			else if (key == "elevation_grid") {options_internal.terrain_elevation_grid_filename = element; options_internal.terrain_defined = true;}
			else if (key == "surface_map") {options_internal.terrain_surface_map_filename = element; options_internal.terrain_defined = true;}
			else if (key == "surface_atlas") {options_internal.terrain_surface_atlas_filename = element; }
			else if (key == "terrain_plot_name") {options_internal.terrain_plot_filename = element;}
			else {cout << "Keyword " << key << " not recognized in context 'terrain', exiting..." << endl; exit(0);}
			}
		else if (block == "event_trigger")
			{
			if (key == "id") {options_internal.event_trigger_id[i_event_trigger] = element; options_internal.event_management = true;}
			else if (key == "logic") {options_internal.event_trigger_logic[i_event_trigger] = element; }
			else if (key == "formation_destroyed") 
				{
				options_internal.event_trigger_formation[i_event_trigger] = element; 
				options_internal.event_management = true;
				n_event_trigger_fd++;
				}
			else if (key == "unit_destroyed") 
				{
				options_internal.event_trigger_unit[i_event_trigger] = element; 
				options_internal.event_management = true;
				n_event_trigger_ud++;
				}
			else if (key == "unit_destroyed_2")
				{options_internal.event_trigger_unit_2[i_event_trigger] = element; n_event_trigger_ud++;}
			else if (key == "unit_destroyed_3")
				{options_internal.event_trigger_unit_3[i_event_trigger] = element; n_event_trigger_ud++;}
			else if (key == "unit_destroyed_4")
				{options_internal.event_trigger_unit_4[i_event_trigger] = element; n_event_trigger_ud++;}
			else if (key == "unit_destroyed_5")
				{options_internal.event_trigger_unit_5[i_event_trigger] = element; n_event_trigger_ud++;}
			else if (key == "line_crossed")
				{
				options_internal.event_trigger_line_crossed[i_event_trigger] = element;
				options_internal.event_management = true; 
				n_event_trigger_lc++;
				}
			else if (key == "line_crossed_2")
				{options_internal.event_trigger_line_crossed_2[i_event_trigger] = element; n_event_trigger_lc++;}
			else if (key == "line_crossed_3")
				{options_internal.event_trigger_line_crossed_3[i_event_trigger] = element; n_event_trigger_lc++;}
			else if (key == "line_crossed_4")
				{options_internal.event_trigger_line_crossed_4[i_event_trigger] = element; n_event_trigger_lc++;}
			else if (key == "line_crossed_5")
				{options_internal.event_trigger_line_crossed_5[i_event_trigger] = element; n_event_trigger_lc++;}
			else if (key == "unit_engaged") 
				{
				options_internal.event_trigger_ue[i_event_trigger] = element; 
				options_internal.event_management = true;
				n_event_trigger_ue++;
				}
			else if (key == "unit_engaged_2") 
				{options_internal.event_trigger_ue_2[i_event_trigger] = element; n_event_trigger_ue++;}
			else if (key == "unit_engaged_3") 
				{options_internal.event_trigger_ue_2[i_event_trigger] = element; n_event_trigger_ue++;}
			else if (key == "unit_engaged_4") 
				{options_internal.event_trigger_ue_2[i_event_trigger] = element; n_event_trigger_ue++;}
			else if (key == "unit_engaged_5") 
				{options_internal.event_trigger_ue_2[i_event_trigger] = element; n_event_trigger_ue++;}
			}
		else if (block == "event_result")
			{
			if (key == "trigger_id") {options_internal.event_result_trigger_id[i_event_result] = element; options_internal.event_management = true;}
			else if (key == "command_formation")  {options_internal.event_result_formation[i_event_result] = element; options_internal.event_management = true;}
			else if (key == "command_unit")  {options_internal.event_result_unit[i_event_result] = element; options_internal.event_management = true;}
			else if (key == "order") {options_internal.event_result_order[i_event_result] = element; options_internal.event_management = true;}
			}
		else if (block == "event_logic")
			{
			if (key == "id") {options_internal.event_logic_id[i_event_logic] = element;}
			else if (key == "type") {options_internal.event_logic_type[i_event_logic] = element;}
			else if (key == "input_1") {options_internal.event_logic_input_1[i_event_logic] = element;}
			else if (key == "input_2") {options_internal.event_logic_input_2[i_event_logic] = element;}
			else if (key == "input_3") {options_internal.event_logic_input_3[i_event_logic] = element;}
			else if (key == "input_4") {options_internal.event_logic_input_4[i_event_logic] = element;}
			else if (key == "input_5") {options_internal.event_logic_input_5[i_event_logic] = element;}
			}
		else if (block == "config")
			{
			if (key == "battle_verbose")
				{
				if (element == "true") {options_internal.config_battle_verbose = true;}
				else if (element == "false") {options_internal.config_battle_verbose = false;}
				}
			else if (key == "events_verbose")
				{
				if (element == "true") {options_internal.config_events_verbose = true;}
				else if (element == "false") {options_internal.config_events_verbose = false;}
				}
			else if (key == "battle_terse")
				{
				if (element == "true") {options_internal.config_battle_terse = true;}
				else if (element == "false") {options_internal.config_battle_terse = false;}
				}
			else if (key == "auto_display")
				{
				if (element == "true") {options_internal.config_auto_battlefield_display = true;}
				else if (element == "false") {options_internal.config_auto_battlefield_display = false;}
				}
			else if (key == "auto_report_units")
				{
				if (element == "true") {options_internal.config_auto_report_units = true;}
				else if (element == "false") {options_internal.config_auto_report_units = false;}
				}
			else if (key == "colors")
				{
				if (element == "true") {options_internal.config_colors = true;}
				else if (element == "false") {options_internal.config_colors = false;}
				}
			else if (key == "check_morale")
				{
				if (element == "true") {options_internal.config_check_morale = true;}
				else if (element == "false") {options_internal.config_check_morale = false;}
				}
			else if (key == "check_los")
				{
				if (element == "true") {options_internal.config_check_los = true;}
				else if (element == "false") {options_internal.config_check_los = false;}
				}
			else if (key == "army_designation_1"){options_internal.config_army_designation_1 = element;}
			else if (key == "army_designation_2"){options_internal.config_army_designation_2 = element;}
			else {cout << "Keyword " << key << " not recognized in this context, exiting..." << endl; exit(0);}
		
			}
		else if (block == "global_morale_check")
			{
			if (key == "destruction")
				{
				options_internal.global_morale_check_destruction[i_evd] = element; 
				i_evd++;
				}
			else {cout << "Keyword " << key << " not recognized in this context, exiting..." << endl; exit(0);}
			}
		else 	
			{
			cout << "Keyword " << block << " not recognized in this context, exiting..." << endl;
			exit(0);
			}

		key_flag = 0;
		}


	//cout << key_flag << endl;


    }
    cfgfile.close();	
  }




options_internal.num_unit_types = n_unit_type;
options_internal.num_lines = n_unit_line;

// total number of units is directly defined number plus units defined in battle lines

n_unit_direct = n_unit;

for (int i=0; i< options_internal.num_lines; i++)
	{
	n_unit += options_internal.line_num_units[i];
	}
options_internal.num_units = n_unit;



unit_array = new Unit[n_unit];
formation_array = new Formation[n_formation];


battle_array_1 = new int[2 * n_unit];
battle_array_2 = new int[2 * n_unit];
charge_array_1 = new int[2 * n_unit];
charge_array_2 = new int[2 * n_unit];

// pre-process options

options_internal.field_show_x_low = 0;
options_internal.field_show_y_low = 0;
options_internal.field_show_x_high = options_internal.field_size_x;
options_internal.field_show_y_high = options_internal.field_size_y;
options_internal.field_size_x_orig = options_internal.field_size_x;
options_internal.field_size_y_orig = options_internal.field_size_y;
options_internal.field_scale_orig = options_internal.field_scale;
options_internal.field_xl_current = 0.0;
options_internal.field_xh_current = 1.0;
options_internal.field_yl_current = 0.0;
options_internal.field_yh_current = 1.0;

for (int i=0; i< n_unit_type; i++)
{
 if (options_internal.unit_type_num_soldiers[i] == 0)
	{
	if ((options_internal.unit_type_num_files[i] > 0) && (options_internal.unit_type_num_ranks[i] > 0))
		{
		options_internal.unit_type_num_soldiers[i] = options_internal.unit_type_num_ranks[i] * options_internal.unit_type_num_files[i];
		}
	else
		{
		cout << "Incomplete unit type description, cannot obtain number of soldiers, exiting..." << endl;
		exit(0);
		}
	}
 if ((options_internal.unit_type_ranged_attack_strength[i] > 0.0) && (options_internal.unit_type_ranged_damage[i] > 0.0) && (options_internal.unit_type_range[i] > 0.0))
	{
	options_internal.unit_type_ranged_weapons[i] = true;
	}

 if ((options_internal.unit_type_mount_description[i] != "") && (options_internal.unit_type_mount_mass[i] == 0.0))
	{
	if (options_internal.unit_type_mount_description[i] == "horse")
		{
		options_internal.unit_type_mount_mass[i] = 600.0;
		options_internal.unit_type_soldiers_per_mount[i] = 1;
		if (options_internal.unit_type_equiv_combat_power[i] == 1) {options_internal.unit_type_equiv_combat_power[i] = 3;}
		options_internal.unit_type_mounted[i] = true;
		}
	else if (options_internal.unit_type_mount_description[i] == "elephant")
		{
		options_internal.unit_type_mount_mass[i] = 4000.0;
		options_internal.unit_type_soldiers_per_mount[i] = 4;
		if (options_internal.unit_type_equiv_combat_power[i] == 1) {options_internal.unit_type_equiv_combat_power[i] = 35;}
		options_internal.unit_type_mounted[i] = true;
		}
	else if (options_internal.unit_type_mount_description[i] == "chariot")
		{
		options_internal.unit_type_mount_mass[i] = 1250.0;
		options_internal.unit_type_soldiers_per_mount[i] = 2;
		if (options_internal.unit_type_equiv_combat_power[i] == 1) {options_internal.unit_type_equiv_combat_power[i] = 5;}
		options_internal.unit_type_mounted[i] = true;
		}
	}
 else if (options_internal.unit_type_mount_mass[i] > 0.0)
	{
	options_internal.unit_type_mounted[i] = true;
	}


}


if (options_internal.config_colors)
	{
	color_red = "\033[0;31m";
	color_green = "\033[0;32m";
	color_blue = "\033[0;34m";
	color_magenta = "\033[0;35m";
	color_bred = "\033[1;31m";
	color_bgreen = "\033[1;32m";
	color_bblue = "\033[1;34m";
	color_bmagenta = "\033[1;35m";
	color_bold = "\033[1m";
	color_normal = "\033[0m";
	color_rbg = "\033[0;41m";
	color_ybg = "\033[0;43m";
	color_bybg = "\033[1;43m";
	color_brbg = "\033[1;41m";
	}
	
else
	{
	color_red = "";
	color_green = "";
	color_bred = "";
	color_bgreen = "";
	color_normal = "";
	color_bold = "";
	color_magenta = "";
	color_bmagenta = "";
	color_rbg = "";
	color_ybg = "";
	color_bybg = "";
	color_brbg = "";
	}


if ((options_internal.config_y_limit_1 == 0.0) && (options_internal.config_y_limit_2 == 0.0))
	{
	options_internal.config_y_limit_2 = options_internal.field_size_y * options_internal.field_scale;
	}


// add units from battle lines to the unit array

int line_add_counter = 0;
int tag_base_size;
int current_num_size;
int tag_add_zero = 0;
double current_pos_x, current_pos_y;


if (n_unit_direct == 0) {line_add_counter = -1;}

for (int i=0; i<n_unit_line; i++)
	{
	tag_base_size = options_internal.line_tag_prefix[i].size();

	
		
	for (int j=0; j< options_internal.line_num_units[i]; j++)
		{
		line_add_counter++;
		current_pos_x = options_internal.line_init_pos_x[i] + j * options_internal.line_spacing_x[i];
		current_pos_y = options_internal.line_init_pos_y[i] + j * options_internal.line_spacing_y[i];
		stringstream ss;
		if (j >99) {current_num_size = 3;}
		else if (j > 9) {current_num_size = 2;}
		else {current_num_size = 1;}
		tag_add_zero = options_internal.config_tag_length - tag_base_size - current_num_size;
		for (int k=0; k< tag_add_zero; k++)
			{
			ss << "0";
			}
		ss << j;
		options_internal.unit_type[i_unit + line_add_counter] = options_internal.line_type[i];
		options_internal.unit_name[i_unit + line_add_counter] = options_internal.line_name_prefix[i] + ss.str();
		options_internal.unit_tag[i_unit + line_add_counter] = options_internal.line_tag_prefix[i] + ss.str();
		options_internal.unit_formation[i_unit + line_add_counter] = options_internal.line_formation[i];
		options_internal.unit_army[i_unit + line_add_counter] = options_internal.line_army[i];
		options_internal.unit_init_pos_x[i_unit + line_add_counter] = current_pos_x;
		options_internal.unit_init_pos_y[i_unit + line_add_counter] = current_pos_y;
		options_internal.unit_init_dir_x[i_unit + line_add_counter] = options_internal.line_init_dir_x[i];
		options_internal.unit_init_dir_y[i_unit + line_add_counter] = options_internal.line_init_dir_y[i];
		options_internal.unit_morale[i_unit + line_add_counter] = options_internal.line_morale[i];


		}
	}


// create actual units as type instances

//cout << "Starting unit creation " << endl;

for (int i = 0; i< n_unit; i++)
	{
	for (int j=0; j< n_unit_type; j++)
		{
		if (options_internal.unit_type_description[j] == options_internal.unit_type[i])
			{
			unit_array[i].init (options_internal.unit_name[i], options_internal.unit_type_description[j], options_internal.unit_type_movement_speed[j], options_internal.unit_type_base_attack_strength[j], options_internal.unit_type_weapon_damage[j], options_internal.unit_type_armor_value[j] );

			
			if (options_internal.unit_type_num_ranks[j] > 0)
				{
				unit_array[i].assign_formation(options_internal.unit_type_num_files[j],options_internal.unit_type_num_ranks[j]);
				}
			else
				{
				unit_array[i].assign_number(options_internal.unit_type_num_soldiers[j]);
				}
			

			if (options_internal.unit_type_ranged_weapons[j] == true)
				{
				unit_array[i].set_ranged_combat(options_internal.unit_type_ranged_attack_strength[j], options_internal.unit_type_ranged_damage[j], options_internal.unit_type_range[j], options_internal.unit_type_shots_per_min[j], options_internal.unit_type_num_shots[j], options_internal.unit_type_ptype[j]);
				}
			if (options_internal.unit_type_mounted[j] == true)
				{
				unit_array[i].set_mounted_combat(options_internal.unit_type_soldiers_per_mount[j], options_internal.unit_type_equiv_combat_power[j], options_internal.unit_type_mount_mass[j], options_internal.unit_type_mount_description[j]);
				}
			if (options_internal.unit_type_ranged_defense[j] > 0.0)
				{
				unit_array[i].set_parameter("ranged_defense", options_internal.unit_type_ranged_defense[j]);
				}

			if (options_internal.unit_type_turn_deg_per_min[j] != 180.0)
				{
				unit_array[i].set_parameter("turn_rad_per_min", 3.1415926535/180.0 * options_internal.unit_type_turn_deg_per_min[j]);
				}
			if (options_internal.unit_type_penalty_flank_attack[j] > 0.0)
				{
				unit_array[i].set_parameter("penalty_flank_attack", options_internal.unit_type_penalty_flank_attack[j]);
				}
			if (options_internal.unit_type_penalty_rear_attack[j] > 0.0)
				{
				unit_array[i].set_parameter("penalty_rear_attack", options_internal.unit_type_penalty_rear_attack[j]);
				}
			if (options_internal.unit_type_bonus_mounted_charge[j] > 0.0)
				{
				unit_array[i].set_parameter("bonus_mounted_charge", options_internal.unit_type_bonus_mounted_charge[j]);
				}


			}
		}
	unit_array[i].assign_to_army(options_internal.unit_army[i]);
	unit_array[i].set_tag(options_internal.unit_tag[i]);
	unit_array[i].set_position(options_internal.unit_init_pos_x[i], options_internal.unit_init_pos_y[i]);	
	unit_array[i].set_init_direction(options_internal.unit_init_dir_x[i], options_internal.unit_init_dir_y[i]);	
	unit_array[i].set_morale(options_internal.unit_morale[i]);
	unit_array[i].set_initial_orders(options_internal.unit_init_order[i], options_internal.unit_init_uc[i], options_internal.unit_init_uv[i], options_internal.unit_init_up[i], options_internal.unit_init_sec[i]);
	unit_array[i].set_initial_ranged_orders(options_internal.unit_init_ua[i], options_internal.unit_init_ut[i]);

	unit_array[i].set_parameter("dist_to_engage", options_internal.unit_init_dist_to_engage[i]);
	unit_array[i].set_parameter("dist_to_disengage", options_internal.unit_init_dist_to_disengage[i]);
	unit_array[i].set_parameter("dist_to_fire", options_internal.unit_init_dist_to_fire[i]);

	if ((options_internal.unit_assembly_x[i] > 0.0) && (options_internal.unit_assembly_y[i] > 0.0))
		{
		unit_array[i].set_assembly_point(options_internal.unit_assembly_x[i], options_internal.unit_assembly_y[i]);
		}


	
	if ((options_internal.unit_init_order[i] == "advance_to") || (options_internal.unit_init_order[i] == "rush_to"))
		{
		unit_array[i].set_initial_order_params(options_internal.unit_tgt_x[i], options_internal.unit_tgt_y[i]);
		}
	else if (options_internal.unit_init_order[i] == "engage_upon") 
		{
		unit_array[i].set_initial_order_params(options_internal.unit_init_order_par_1[i],0.0);
		}

	

	}

// post-processing for relative unit information like target finding

for (int i = 0; i< n_unit; i++)
	{
	if (options_internal.unit_target[i] != "none")
		{

		for (int k=0;k<n_unit;k++)
			{
			if (options_internal.unit_target[i] == unit_array[k].get_tag())
				{
				unit_array[i].set_parameter("tgt_id", k);
				break;
				}
			}
		}

	//unit_array[i].list();
	}

// assign units to formations, load formation specific commands


options_internal.num_formations = n_formation;

if (n_formation > 0)
	{

	for (int i=0; i< n_formation; i++)
		{
		formation_array[i].init(options_internal.formation_name[i]);
		}


	for (int i=0;i<n_unit; i++)
		{
		for (int j=0; j< n_formation; j++)
			{
			if (options_internal.unit_formation[i] == formation_array[j].get_name() && (options_internal.unit_formation[i] != ""))
				{
				formation_array[j].add_unit(i);
				}
			}
		}
	
	for (int id=0; id< n_formation; id++)
		{
		for (int i=0; i< formation_array[id].get_num_units(); i++)
				{

				if (options_internal.formation_speed[id] != "")
					{

					if ((options_internal.formation_speed[id] == "advance") || (options_internal.formation_speed[id] == "slow") || (options_internal.formation_speed[id] == "rush") || (options_internal.formation_speed[id] == "run"))
						{
						unit_array[formation_array[id].get_unit_id(i)].give_order(options_internal.formation_speed[id]);
						}
					else if ((options_internal.formation_speed[id] == "trot") || (options_internal.formation_speed[id] == "walk") || (options_internal.formation_speed[id] == "gallop") || (options_internal.formation_speed[id] == "charge"))
						{
						unit_array[formation_array[id].get_unit_id(i)].give_order(options_internal.formation_speed[id]);
						}
					}

				if (options_internal.formation_order[id] != "")
					{
					if ((options_internal.formation_order[id] == "advance") || (options_internal.formation_order[id] == "slow") || (options_internal.formation_order[id] == "rush") || (options_internal.formation_order[id] == "run") || (options_internal.formation_order[id] == "halt") || (options_internal.formation_order[id] == "seek_enemy") || (options_internal.formation_order[id] == "guard") )
						{
						unit_array[formation_array[id].get_unit_id(i)].give_order(options_internal.formation_order[id]);
						}
					else if (options_internal.formation_order[id] == "engage_upon")
						{
						unit_array[formation_array[id].get_unit_id(i)].give_order(options_internal.formation_order[id], options_internal.formation_order_par_1[id]);
						}
					else if ((options_internal.formation_order[id] == "hit_and_run") || (options_internal.formation_order[id] == "hit_and_retreat"))
						{
						unit_array[formation_array[id].get_unit_id(i)].give_order(options_internal.formation_order[id]);
						}

					}
				if (options_internal.formation_uc[id] != "")
					{unit_array[formation_array[id].get_unit_id(i)].set_order("upon_contact", options_internal.formation_uc[id]);}
				if (options_internal.formation_uv[id] != "")
					{unit_array[formation_array[id].get_unit_id(i)].set_order("upon_victory", options_internal.formation_uc[id]);}
				if (options_internal.formation_up[id] != "")
					{unit_array[formation_array[id].get_unit_id(i)].set_order("upon_position", options_internal.formation_up[id]);}
				if (options_internal.formation_ua[id] != "")
					{unit_array[formation_array[id].get_unit_id(i)].set_order("upon_ammo_finished", options_internal.formation_ua[id]);}
				if (options_internal.formation_ut[id] != "")
					{unit_array[formation_array[id].get_unit_id(i)].set_order("upon_target_destroyed", options_internal.formation_ut[id]);}
				if (options_internal.formation_sec[id] != "")
					{unit_array[formation_array[id].get_unit_id(i)].set_order("secondary", options_internal.formation_sec[id]);}
				if (options_internal.formation_dist_to_engage[id] > 0.0)
					{unit_array[formation_array[id].get_unit_id(i)].set_parameter("dist_to_engage", options_internal.formation_dist_to_engage[id]);}
				if (options_internal.formation_dist_to_disengage[id] > 0.0)
					{unit_array[formation_array[id].get_unit_id(i)].set_parameter("dist_to_disengage", options_internal.formation_dist_to_disengage[id]);}
				if (options_internal.formation_dist_to_fire[id] > 0.0)
					{unit_array[formation_array[id].get_unit_id(i)].set_parameter("dist_to_fire", options_internal.formation_dist_to_fire[id]);}


					
				}

		}	

	}


// terrain generation is done only once, but we need to do the options per iteration otherwise they're reset



if ((options_internal.terrain_surface_map_filename != "") && (options_internal.terrain_surface_atlas_filename != "") && (options_internal.terrain_surface_map_size_x > 0) && (options_internal.terrain_surface_map_size_y > 0))
	{
	options_internal.terrain_surface_defined = true;
	}



// start the event manager

if (options_internal.event_management == true)
	{
	//cout << "Starting event manager..." << endl;
	//cout << n_event_trigger << " triggers " << n_event_result << " results  and " << n_event_logic << " logic elements." << endl;
	options_internal.event_num_triggers = n_event_trigger;
	options_internal.event_num_fd_triggers = n_event_trigger_fd;
	options_internal.event_num_ud_triggers = n_event_trigger_ud;
	options_internal.event_num_lc_triggers = n_event_trigger_lc;
	options_internal.event_num_results = n_event_result;
	options_internal.event_num_logics = n_event_logic;

	events.initialize(n_event_trigger, n_event_result, n_event_logic);


	/*for (int i=0; i< n_event_trigger_fd; i++)
		{
		events.init_trigger(1, 0);
		events.add_trigger_fd(options_internal.event_trigger_formation[i]);
		events.set_trigger_id(options_internal.event_trigger_id[i]);
		}
	for (int i=0; i< n_event_trigger_ud; i++)
		{
		events.init_trigger(0, 1);
		events.add_trigger_ud(options_internal.event_trigger_unit[i]);
		events.set_trigger_id(options_internal.event_trigger_id[i]);
		}	*/

	for (int i=0; i< n_event_trigger; i++)
		{
		int trf = 0;
		int tru = 0;
		int trl = 0;
		int tue = 0;

		if (options_internal.event_trigger_formation[i] != "") {trf++;}
		if (options_internal.event_trigger_unit[i] != "") {tru++;}
		if (options_internal.event_trigger_unit_2[i] != "") {tru++;}
		if (options_internal.event_trigger_unit_3[i] != "") {tru++;}
		if (options_internal.event_trigger_unit_4[i] != "") {tru++;}
		if (options_internal.event_trigger_unit_5[i] != "") {tru++;}
		if (options_internal.event_trigger_line_crossed[i] != "") {trl++;}
		if (options_internal.event_trigger_line_crossed_2[i] != "") {trl++;}
		if (options_internal.event_trigger_line_crossed_3[i] != "") {trl++;}
		if (options_internal.event_trigger_line_crossed_4[i] != "") {trl++;}
		if (options_internal.event_trigger_line_crossed_5[i] != "") {trl++;}
		if (options_internal.event_trigger_ue[i] != "") {tue++;}
		if (options_internal.event_trigger_ue_2[i] != "") {tue++;}
		if (options_internal.event_trigger_ue_3[i] != "") {tue++;}
		if (options_internal.event_trigger_ue_4[i] != "") {tue++;}
		if (options_internal.event_trigger_ue_5[i] != "") {tue++;}

		events.init_trigger(trf, tru, trl, tue);
		if (trf == 1)
			{events.add_trigger_fd(options_internal.event_trigger_formation[i]);}
		if (trl > 0)
			{events.add_trigger_lc(options_internal.event_trigger_line_crossed[i], options_internal.event_trigger_lc_pos[i], options_internal.event_trigger_lc_sign[i]);}	
		if (options_internal.event_trigger_line_crossed_2[i] != "") {events.add_trigger_lc(options_internal.event_trigger_line_crossed_2[i], options_internal.event_trigger_lc_pos[i], options_internal.event_trigger_lc_sign[i]);}
		if (options_internal.event_trigger_line_crossed_3[i] != "") {events.add_trigger_lc(options_internal.event_trigger_line_crossed_3[i], options_internal.event_trigger_lc_pos[i], options_internal.event_trigger_lc_sign[i]);}
		if (options_internal.event_trigger_line_crossed_4[i] != "") {events.add_trigger_lc(options_internal.event_trigger_line_crossed_4[i], options_internal.event_trigger_lc_pos[i], options_internal.event_trigger_lc_sign[i]);}
		if (options_internal.event_trigger_line_crossed_5[i] != "") {events.add_trigger_lc(options_internal.event_trigger_line_crossed_5[i], options_internal.event_trigger_lc_pos[i], options_internal.event_trigger_lc_sign[i]);}
		if (tru > 0)
			{events.add_trigger_ud(options_internal.event_trigger_unit[i]);}
		if (options_internal.event_trigger_unit_2[i] != "") {events.add_trigger_ud(options_internal.event_trigger_unit_2[i]);}
		if (options_internal.event_trigger_unit_3[i] != "") {events.add_trigger_ud(options_internal.event_trigger_unit_3[i]);}
		if (options_internal.event_trigger_unit_4[i] != "") {events.add_trigger_ud(options_internal.event_trigger_unit_4[i]);}
		if (options_internal.event_trigger_unit_5[i] != "") {events.add_trigger_ud(options_internal.event_trigger_unit_5[i]);}

		if (options_internal.event_trigger_logic[i] != "") {events.set_trigger_logic(options_internal.event_trigger_logic[i]);}
		
		if (options_internal.event_trigger_ud_fraction[i] != 1.0) {events.set_trigger_ud_fraction(options_internal.event_trigger_ud_fraction[i]);}
		if (options_internal.event_trigger_fd_fraction[i] != 1.0) {events.set_trigger_fd_fraction(options_internal.event_trigger_fd_fraction[i]);}

		events.set_trigger_id(options_internal.event_trigger_id[i]);

		}	

	for (int i=0; i < n_event_result; i++)
		{

		if (options_internal.event_result_formation[i] != "")
			{

			if ((options_internal.event_result_order_par_1[i] == -1.0) && (options_internal.event_result_order_par_2[i] == -1.0))
				{events.create_result_formation(options_internal.event_result_trigger_id[i], options_internal.event_result_formation[i], options_internal.event_result_order[i]); }
			else if (options_internal.event_result_order_par_2[i] == -1.0)
				{
				events.create_result_formation(options_internal.event_result_trigger_id[i], options_internal.event_result_formation[i], options_internal.event_result_order[i], options_internal.event_result_order_par_1[i]);
				}
			else
				{
				events.create_result_formation(options_internal.event_result_trigger_id[i], options_internal.event_result_formation[i], options_internal.event_result_order[i], options_internal.event_result_order_par_1[i],  options_internal.event_result_order_par_2[i]);
				}
			}
		else if (options_internal.event_result_unit[i] != "")
			{
			if ((options_internal.event_result_order_par_1[i] == -1.0) && (options_internal.event_result_order_par_2[i] == -1.0))
				{events.create_result_unit(options_internal.event_result_trigger_id[i], options_internal.event_result_unit[i], options_internal.event_result_order[i]); }
			}
		}

	for (int i=0; i< n_event_logic; i++)
		{
		if (options_internal.event_logic_input_1[i]!= "") {events.add_logic_input(options_internal.event_logic_input_1[i]);}
		if (options_internal.event_logic_input_2[i]!= "") {events.add_logic_input(options_internal.event_logic_input_2[i]);}
		if (options_internal.event_logic_input_3[i]!= "") {events.add_logic_input(options_internal.event_logic_input_3[i]);}
		if (options_internal.event_logic_input_4[i]!= "") {events.add_logic_input(options_internal.event_logic_input_4[i]);}
		if (options_internal.event_logic_input_5[i]!= "") {events.add_logic_input(options_internal.event_logic_input_5[i]);}
		events.set_logic_type(options_internal.event_logic_type[i]);
		events.set_logic_id(options_internal.event_logic_id[i]);
		}


	}





return options_internal;


}
	
