// options.hxx -- hash to store the parsed configuration options 
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2022  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <string>

using namespace std;

class Options {
	public:

	// config

	bool config_battle_verbose;
	bool config_battle_terse;
	bool config_events_verbose;
	bool config_random_seed_set;
	bool config_auto_battlefield_display;
	bool config_auto_report_units;
	bool config_auto_report_soldiers;
	bool config_colors;
	bool config_check_morale;
	bool config_check_los;
	
	int config_random_seed;
	int config_tag_length;
	int config_n_iterations;

	double config_random_range;
	double config_internal_timestep;
	double config_battle_timestep;
	double config_damage_multiplier;
	double config_charge_threshold;
	double config_initial_zoom;

	string config_army_designation_1;
	string config_army_designation_2;

	double config_y_limit_1;
	double config_y_limit_2;

	Options();
	Options(int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8);
	


	//unit type definitions
	int num_unit_types;
	int* unit_type_num_ranks;
	int* unit_type_num_files;
	int* unit_type_num_soldiers;
	int* unit_type_num_shots;
	int* unit_type_soldiers_per_mount;
	int* unit_type_equiv_combat_power;

	string* unit_type_description;
	string* unit_type_mount_description;
	string* unit_type_ptype;

	bool* unit_type_ranged_weapons;
	bool* unit_type_mounted;

	double* unit_type_movement_speed;
	double* unit_type_armor_value;
	double* unit_type_base_resistance;
	double* unit_type_base_attack_strength;
	double* unit_type_ranged_attack_strength;
	double* unit_type_ranged_defense;
	double* unit_type_weapon_damage;
	double* unit_type_ranged_damage;
	double* unit_type_formation_control;
	double* unit_type_morale;
	double* unit_type_shots_per_min;
	double* unit_type_range;
	double* unit_type_turn_deg_per_min;
	double* unit_type_mount_mass;
	double* unit_type_penalty_flank_attack;
	double* unit_type_penalty_rear_attack;
	double* unit_type_bonus_mounted_charge;


	// unit battle line definitions

	int num_lines;

	string* line_name_prefix;
	string* line_type;
	string* line_tag_prefix;
	string* line_formation;

	int* line_army;
	int* line_num_units;
	
	double* line_morale;
	double* line_init_pos_x;
	double* line_init_pos_y;
	double* line_spacing_x;
	double* line_spacing_y;
	double* line_init_dir_x;
	double* line_init_dir_y;


	// unit definitions
	int num_units;

	string* unit_name;
	string* unit_type;
	string* unit_tag;
	string* unit_formation;

	int* unit_army;

	bool* unit_default_orders;
	
	double* unit_morale;
	double* unit_init_pos_x;
	double* unit_init_pos_y;
	double* unit_init_dir_x;
	double* unit_init_dir_y;
	double* unit_tgt_x;
	double* unit_tgt_y;
	double* unit_assembly_x;
	double* unit_assembly_y;

	string* unit_init_order;
	string* unit_init_uc;		
	string* unit_init_uv;	
	string* unit_init_up;
	string* unit_init_ua;
	string* unit_init_ut;
	string* unit_init_sec;
	string* unit_target;

	double* unit_init_order_par_1;
	double* unit_init_order_par_2;
	double* unit_init_dist_to_engage;
	double* unit_init_dist_to_disengage;
	double* unit_init_dist_to_fire;

	// formation definitions	

	int num_formations;

	string* formation_name;
	string* formation_order;
	string* formation_speed;		
	string* formation_uc;	
	string* formation_uv;
	string* formation_up;
	string* formation_ua;
	string* formation_ut;
	string* formation_sec;

	double* formation_order_par_1;
	double* formation_order_par_2;	
	double* formation_dist_to_fire;
	double* formation_dist_to_engage;
	double* formation_dist_to_disengage;

	// battlefield

	int field_size_x;
	int field_size_y;
	int field_size_x_orig;
	int field_size_y_orig;
	int field_show_x_low;
	int field_show_x_high;
	int field_show_y_low;
	int field_show_y_high;
	int field_color_coding;
	int field_aspect_factor;
	double field_scale;
	double field_scale_orig;
	double field_xl_current;
	double field_xh_current;
	double field_yl_current;
	double field_yh_current;

	// terrain

	bool terrain_defined;
	bool terrain_surface_defined;

	int terrain_surface_map_size_x;
	int terrain_surface_map_size_y;

	string terrain_elevation_map_filename;
	string terrain_elevation_grid_filename;
	string terrain_surface_map_filename;
	string terrain_surface_atlas_filename;
	string terrain_plot_filename;


	// global morale check events

	bool global_morale_checks;
	int num_global_morale_checks_destruction;
	string* global_morale_check_destruction;
	double* global_morale_check_difficulty;

	// event_management

	bool event_management;
		
	int event_num_triggers;
	int event_num_fd_triggers;
	int event_num_ud_triggers;
	int event_num_lc_triggers;	

	string* event_trigger_id;
	string* event_trigger_logic;
	string* event_trigger_formation;
	string* event_trigger_unit;	
	string* event_trigger_unit_2;
	string* event_trigger_unit_3;
	string* event_trigger_unit_4;
	string* event_trigger_unit_5;
	string* event_trigger_line_crossed;
	string* event_trigger_line_crossed_2;
	string* event_trigger_line_crossed_3;
	string* event_trigger_line_crossed_4;
	string* event_trigger_line_crossed_5;
	string* event_trigger_ue;
	string* event_trigger_ue_2;
	string* event_trigger_ue_3;
	string* event_trigger_ue_4;
	string* event_trigger_ue_5; 

	double* event_trigger_fd_fraction;
	double* event_trigger_ud_fraction;
	double* event_trigger_lc_pos;

	int* event_trigger_lc_sign;

	int event_num_results;

	string* event_result_trigger_id;
	string* event_result_formation;
	string* event_result_unit;
	string* event_result_order;
	double* event_result_order_par_1;
	double* event_result_order_par_2;

	int event_num_logics;
	
	string* event_logic_id;
	string* event_logic_type;
	string* event_logic_input_1;
	string* event_logic_input_2;
	string* event_logic_input_3;
	string* event_logic_input_4;
	string* event_logic_input_5;

	double* event_logic_timer;

};

class Command{

	public:
	
	string unit_tag;
	int unit_id;
	int formation_id;
	
	string command;
	double timestep;
	
	double par_1;
	double par_2;
	double par_3;

	int int_1;
	int int_2;

};
