// options.cxx -- hash to store the parsed configuration options 
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2022  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <stdlib.h>
#include <iostream>
#include <string>
#include "options.hxx"

Options::Options()
{

cout << "Options empty init!" << endl;
}


Options::Options(int n_type, int n_unit, int n_line, int n_formation, int n_evd, int n_trigger, int n_result, int n_logic)
{


unit_type_num_ranks = new int[n_type];
unit_type_num_files = new int[n_type];
unit_type_num_soldiers = new int[n_type];
unit_type_num_shots = new int[n_type];
unit_type_soldiers_per_mount = new int[n_type];
unit_type_equiv_combat_power = new int[n_type];

unit_type_description = new string[n_type];
unit_type_mount_description = new string[n_type];
unit_type_ptype = new string[n_type];

unit_type_movement_speed = new double[n_type];
unit_type_armor_value = new double[n_type];


unit_type_base_resistance= new double[n_type];
unit_type_base_attack_strength = new double[n_type];
unit_type_ranged_attack_strength = new double[n_type];
unit_type_ranged_defense = new double[n_type];
unit_type_weapon_damage = new double[n_type];
unit_type_ranged_damage = new double[n_type];
unit_type_mount_mass = new double[n_type];
unit_type_formation_control = new double[n_type];
unit_type_morale = new double[n_type];
unit_type_shots_per_min = new double[n_type];
unit_type_range = new double[n_type];
unit_type_turn_deg_per_min = new double[n_type];
unit_type_penalty_flank_attack = new double[n_type];
unit_type_penalty_rear_attack = new double[n_type];
unit_type_bonus_mounted_charge = new double[n_type];

unit_type_ranged_weapons = new bool[n_type];
unit_type_mounted = new bool[n_type];


line_name_prefix = new string[n_line];
line_type = new string[n_line];
line_tag_prefix = new string[n_line];
line_formation = new string[n_line];

line_army = new int[n_line];
line_num_units = new int[n_line];

line_morale = new double[n_line];
line_init_pos_x = new double[n_line];
line_init_pos_y = new double[n_line];	
line_spacing_x = new double[n_line];
line_spacing_y = new double[n_line];
line_init_dir_x = new double[n_line];
line_init_dir_y = new double[n_line];



unit_name = new string[n_unit];
unit_type = new string[n_unit];
unit_tag = new string[n_unit];
unit_formation = new string[n_unit];
unit_init_order = new string[n_unit];
unit_init_uc = new string[n_unit];		
unit_init_uv = new string[n_unit];	
unit_init_up = new string[n_unit];
unit_init_ua = new string[n_unit];
unit_init_ut = new string[n_unit];
unit_init_sec = new string[n_unit];
unit_target = new string[n_unit];

unit_army = new int[n_unit];

unit_default_orders = new bool[n_unit];

unit_morale = new double[n_unit];
unit_init_pos_x = new double[n_unit];
unit_init_pos_y = new double[n_unit];
unit_init_dir_x = new double[n_unit];
unit_init_dir_y = new double[n_unit];
unit_tgt_x = new double[n_unit];
unit_tgt_y = new double[n_unit];
unit_assembly_x = new double[n_unit];
unit_assembly_y = new double[n_unit];
unit_init_order_par_1 = new double[n_unit];
unit_init_order_par_2 = new double[n_unit];
unit_init_dist_to_engage = new double[n_unit];
unit_init_dist_to_disengage = new double[n_unit];
unit_init_dist_to_fire = new double[n_unit];


formation_name = new string[n_formation];
formation_order = new string[n_formation];
formation_speed = new string[n_formation];		
formation_uc = new string[n_formation];	
formation_uv = new string[n_formation];
formation_up = new string[n_formation];
formation_ua = new string[n_formation];
formation_ut = new string[n_formation];
formation_sec = new string[n_formation];
formation_dist_to_fire = new double[n_formation];
formation_dist_to_engage = new double[n_formation];
formation_dist_to_disengage = new double[n_formation];
formation_order_par_1 = new double[n_formation];
formation_order_par_2 = new double[n_formation];

global_morale_check_destruction = new string[n_evd];
global_morale_check_difficulty = new double[n_evd];

global_morale_checks = false;
num_global_morale_checks_destruction = n_evd;
if (n_evd > 0) {global_morale_checks = true;}

event_trigger_id = new string[n_trigger];
event_trigger_logic = new string[n_trigger];
event_trigger_formation = new string[n_trigger];
event_trigger_line_crossed = new string[n_trigger];
event_trigger_line_crossed_2 = new string[n_trigger];
event_trigger_line_crossed_3 = new string[n_trigger];
event_trigger_line_crossed_4 = new string[n_trigger];
event_trigger_line_crossed_5 = new string[n_trigger];
event_trigger_unit = new string[n_trigger];
event_trigger_unit_2 = new string[n_trigger];
event_trigger_unit_3 = new string[n_trigger];
event_trigger_unit_4 = new string[n_trigger];
event_trigger_unit_5 = new string[n_trigger];
event_trigger_ue = new string[n_trigger];
event_trigger_ue_2 = new string[n_trigger];
event_trigger_ue_3 = new string[n_trigger];
event_trigger_ue_4 = new string[n_trigger];
event_trigger_ue_5 = new string[n_trigger];

event_trigger_fd_fraction = new double[n_trigger];
event_trigger_ud_fraction = new double[n_trigger];
event_trigger_lc_pos = new double[n_trigger];

event_trigger_lc_sign = new int[n_trigger];

event_result_trigger_id = new string[n_result];
event_result_order = new string[n_result];
event_result_formation = new string[n_result];
event_result_unit = new string[n_result];
event_result_order_par_1 = new double[n_result];
event_result_order_par_2 = new double[n_result];

event_logic_id = new string[n_logic];
event_logic_type = new string[n_logic];
event_logic_input_1 = new string[n_logic];
event_logic_input_2 = new string[n_logic];
event_logic_input_3 = new string[n_logic];
event_logic_input_4 = new string[n_logic];
event_logic_input_5 = new string[n_logic];

event_logic_timer = new double[n_logic];

cout << "Options initialized for " << n_type << " unit types " << n_unit << " units and " << n_formation << " formations." <<  endl;
cout << n_trigger << " event triggers " << n_logic << " logical elements and " << n_result << " event results have been created." << endl;
}
