// formation.hxx -- class to define a battle formation
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2022 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301


#ifndef FORMATION_H
#define FORMATION_H


#include <string>


class Formation {

	std::string name;
	int num_units;
	int unit_id_array[50];
	
	double cog_x;
	double cog_y;

	double max_x;
	double min_x;
	double max_y;
	double min_y;

	bool is_active;

	public:

	void init (std::string name);
	void add_unit (int id);
	void set_active(bool);
	int get_num_units();
	int get_unit_id(int i);
	std::string get_name();

	double get_pos_x();
	double get_pos_y();

	bool get_inactive();

	void set_shape(double, double, double, double, double, double);

};

#endif
