// formation.cxx -- class to define a formation of units
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2022 Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#include <math.h>
#include <cmath>
#include <iostream>

#include "formation.hxx"

using namespace std;

void Formation::init(string name_in)
	{
	name = name_in;
	num_units = 0;
	cog_x = 0.0;
	cog_y = 0.0;
	max_x = 0.0;
	min_x = 0.0;
	max_y = 0.0;
	min_y = 0.0;

	is_active = true;
	}

void Formation::add_unit(int id)
	{
	unit_id_array[num_units] = id;
	num_units++;
	}

int Formation::get_num_units()
	{
	return num_units;
	}

int Formation::get_unit_id(int i)
	{
	return unit_id_array[i];
	}

std::string Formation::get_name()
	{
	return name;
	}

void Formation::set_shape(double cx, double cy, double max, double mix, double may, double miy)
{
cog_x = cx;
cog_y = cy;

max_x = max;
min_x = mix;

max_y = may;
min_y = miy;
}

void Formation::set_active(bool flag)
{
is_active = flag;
}

double Formation::get_pos_x()
{
return cog_x;
}

double Formation::get_pos_y()
{
return cog_y;
}

bool Formation::get_inactive()
{
if (is_active == true) {return false;}
else {return true;}
}
