// events.hxx -- provides event management for battle simulation
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2023  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301

#ifndef EVENTS_H
#define EVENTS_H


#include "unit.hxx"
#include "formation.hxx"


using namespace std;





class EventTrigger {

	bool trigger_condition;
	bool check_formation_destroyed;
	bool check_unit_destroyed;
	bool check_line_crossed;
	bool check_unit_engaged;

	int n_formation_destroyed;
	int i_formation_destroyed;

	int n_unit_destroyed;
	int i_unit_destroyed;

	int n_line_crossed;
	int i_line_crossed;

	int n_unit_engaged;
	int i_unit_engaged;

	int *lc_sign_array;

	bool *formation_destroyed;
	bool *unit_destroyed;
	bool *line_crossed;
	bool *unit_engaged;

	double *fd_percentage_array;
	double *ud_percentage_array;
	double *lc_pos_array;



	std::string id;
	std::string logic;
	std::string *fd_array;
	std::string *ud_array;
	std::string *lc_array;
	std::string *ue_array;

	bool check_logic (int n, bool array[]);


	public:

	friend class EventManager;

	EventTrigger();

	void set_id(std::string);
	void set_formation_destroyed(std::string);
	void set_unit_destroyed(std::string);
	void set_line_crossed(std::string, double, int);
	void set_unit_engaged(std::string);
	void set_logic(std::string);
	void set_ud_fraction(double);
	void set_fd_fraction(double);

	void initialize(int, int, int, int);
	void check_conditions(Unit unit_array[], int num_units, Formation formation_array[], int num_formations);

	std::string get_id();

	bool get_trigger_condition();

};

class EventLogic {
	
	bool trigger_condition;
	bool *trigger_array;

	int num_slots;
	int num_slots_set;

	std::string *trigger_id_array;
	std::string logic;
	std::string logic_id;

	bool check_logic (int n, bool array[]);

	public:

	EventLogic();

	void add_trigger_id(std::string);
	void set_logic(std::string);
	void set_id(std::string);
	void set_condition(int, bool);
	void check_trigger_conditions();

	bool get_trigger_condition();

	int get_num_conditions();
	
	std::string get_condition_id(int);
	std::string get_id();

	
};

class EventResult {

	bool event_triggered;
	bool event_executed;
	bool command_to_formation;
	bool command_to_unit;

	std::string formation_target;
	std::string unit_target;
	std::string order;
	std::string trigger_id;
	std::string command_string;
	
	double order_par_1;
	double order_par_2;

	public:

	friend class EventManager;

	EventResult();

	void set_formation_target (std::string);
	void set_unit_target (std::string);
	void set_order (std::string);
	void set_trigger_id(std::string);
	void set_order_par_1 (double);
	void set_order_par_2 (double);

	std::string get_command();
	std::string get_id();

	void trigger();


};

class EventManager {

	int n_result;
	int i_result;

	int n_trigger;
	int i_trigger;

	int n_logic;
	int i_logic;

	int n_unit;
	int n_formation;

	EventResult *result_array;
	EventTrigger *trigger_array;
	EventLogic *logic_array;
	std::string *command_buffer;

	public:




	void initialize(int, int, int);
	void create_result_formation(std::string, std::string, std::string);
	void create_result_formation(std::string, std::string, std::string, double);
	void create_result_formation(std::string, std::string, std::string, double, double);
	void create_result_unit(std::string, std::string, std::string);

	void init_trigger(int, int, int, int);
	void set_trigger_id(std::string);
	void set_trigger_logic(std::string);
	void set_trigger_fd_fraction (double);
	void set_trigger_ud_fraction (double);
	void add_trigger_fd(std::string);
	void add_trigger_ud(std::string);
	void add_trigger_lc(std::string, double, int);
	void add_trigger_ue(std::string);

	void set_logic_id(std::string);
	void add_logic_input(std::string);
	void set_logic_type(std::string);

	int manage(Unit unit_array[], int num_units, Formation formation_array[], int num_formations);

	std::string get_commandline(int);

};

#endif
