// commandline_parser.hxx -- parser for the command line
//
// Written by Thorsten Renk, started 2022
//
// Copyright (C) 2022  Thorsten Renk - thorsten@science-and-fiction.org 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301



int find_id (string tag)
{
int id;

id = -1;
for (int i=0; i<options_list.num_units;i++)
	{
	if (tag == unit_array[i].get_tag())
		{id = i; break;}
	}

return id;
}


void input_parser (string keyboard_command_string)
{
string cmd1, cmd2, cmd3, cmd4, cmd5, cmd6;
int id, id1;
double dir, tgt_x, tgt_y;
double scale, xl, xh, yl, yh;

stringstream(keyboard_command_string) >> cmd1 >> cmd2 >> cmd3 >> cmd4 >> cmd5 >> cmd6;

cmd_input.command = "void";

if ((cmd1 == "end") || (cmd1 == "exit") || (cmd1=="q")) 
	{cmd_input.command = "end";}
else if (cmd1 == "reset") 
	{cmd_input.command = "reset";}
else if ((cmd1 == "go") || (cmd1 == "advance") || (cmd1 == "evolve"))
	{
	cmd_input.command = "evolve";
	if (cmd2 == "")
		{cmd_input.timestep = 1.0;}
	else
		{cmd_input.timestep = atof (cmd2.c_str());}
	}
else if (cmd1 == "show")
	{
	if (cmd2 == "battlefield")
		{cmd_input.command = "show_battlefield";}
	
	}
else if ((cmd1 == "get") && (cmd2 == "elevation") && (cmd4 == ""))
	{
	if (options_list.terrain_defined)
		{

		id = find_id(cmd3);
		if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

		cmd_input.command = "get_elevation";
		cmd_input.par_1 = unit_array[id].get_pos_x();
		cmd_input.par_2 = unit_array[id].get_pos_y();
		}
	else {cout << "No terrain defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "elevation"))
	{
	if (options_list.terrain_defined)
		{
		cmd_input.command = "get_elevation";
		cmd_input.par_1 = atof (cmd3.c_str());
		cmd_input.par_2 = atof (cmd4.c_str());
		}
	else {cout << "No terrain defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "movement_slowdown") && (cmd4 == ""))
	{
	if (options_list.terrain_surface_defined)
		{

		id = find_id(cmd3);
		if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

		cmd_input.command = "get_movement_factor";
		cmd_input.par_1 = unit_array[id].get_pos_x();
		cmd_input.par_2 = unit_array[id].get_pos_y();
		}
	else {cout << "No terrain surface defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "movement_max") && (cmd4 == ""))
	{
	if (options_list.terrain_surface_defined)
		{

		id = find_id(cmd3);
		if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

		cmd_input.command = "get_movement_max";
		cmd_input.par_1 = unit_array[id].get_pos_x();
		cmd_input.par_2 = unit_array[id].get_pos_y();
		}
	else {cout << "No terrain surface defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "soft_cover") && (cmd4 == ""))
	{
	if (options_list.terrain_surface_defined)
		{

		id = find_id(cmd3);
		if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

		cmd_input.command = "get_soft_cover";
		cmd_input.par_1 = unit_array[id].get_pos_x();
		cmd_input.par_2 = unit_array[id].get_pos_y();
		}
	else {cout << "No terrain surface defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "hard_cover") && (cmd4 == ""))
	{
	if (options_list.terrain_surface_defined)
		{

		id = find_id(cmd3);
		if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

		cmd_input.command = "get_hard_cover";
		cmd_input.par_1 = unit_array[id].get_pos_x();
		cmd_input.par_2 = unit_array[id].get_pos_y();
		}
	else {cout << "No terrain surface defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "movement_slowdown"))
	{
	if (options_list.terrain_surface_defined)
		{
		cmd_input.command = "get_movement_factor";
		cmd_input.par_1 = atof (cmd3.c_str());
		cmd_input.par_2 = atof (cmd4.c_str());
		}
	else {cout << "No terrain surface defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "movement_max"))
	{
	if (options_list.terrain_surface_defined)
		{
		cmd_input.command = "get_movement_max";
		cmd_input.par_1 = atof (cmd3.c_str());
		cmd_input.par_2 = atof (cmd4.c_str());
		}
	else {cout << "No terrain surface defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "soft_cover"))
	{
	if (options_list.terrain_surface_defined)
		{
		cmd_input.command = "get_soft_cover";
		cmd_input.par_1 = atof (cmd3.c_str());
		cmd_input.par_2 = atof (cmd4.c_str());
		}
	else {cout << "No terrain surface defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "hard_cover"))
	{
	if (options_list.terrain_surface_defined)
		{
		cmd_input.command = "get_hard_cover";
		cmd_input.par_1 = atof (cmd3.c_str());
		cmd_input.par_2 = atof (cmd4.c_str());
		}
	else {cout << "No terrain surface defined." << endl;}
	}

else if ((cmd1 == "get") && (cmd2 == "slope") && (cmd4 == ""))
	{
	if (options_list.terrain_defined)
		{

		id = find_id(cmd3);
		if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

		cmd_input.command = "get_slope";
		cmd_input.par_1 = unit_array[id].get_pos_x();
		cmd_input.par_2 = unit_array[id].get_pos_y();
		cmd_input.par_3 = unit_array[id].get_dir();
		}
	else {cout << "No terrain defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "slope"))
	{
	if (options_list.terrain_defined)
		{
		cmd_input.command = "get_slope";
		cmd_input.par_1 = atof (cmd3.c_str());
		cmd_input.par_2 = atof (cmd4.c_str());
		cmd_input.par_3 = atof (cmd5.c_str()) * 0.01745329251;
		}
	else {cout << "No terrain defined." << endl;}
	}
else if ((cmd1 == "get") && (cmd2 == "distance") && (cmd5 == ""))
	{
	id = find_id(cmd3);
	if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

	id1 = find_id(cmd4);
	if (id1 == -1) {cout << "No unit with this tag found..." << endl; return;}

	cout << "Distance is " << unit_dist(id, id1) << " m." << endl;
		
	}
else if ((cmd1 == "get") && (cmd2 == "los") && (cmd5 == ""))
	{
	id = find_id(cmd3);
	if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

	id1 = find_id(cmd4);
	if (id1 == -1) {cout << "No unit with this tag found..." << endl; return;}

	cmd_input.command = "get_los";
	cmd_input.int_1 = id;
	cmd_input.int_2 = id1;
	}
else if (cmd1 == "save")
	{
	if ((cmd2 == "elevation_grid") && (cmd3 != ""))
		{
		terrain.save_grid(cmd3);
		}
	}
else if (cmd1 == "color")
	{
	if (cmd2 == "normal") {options_list.field_color_coding = 0;}
	else if ((cmd2 == "ammo") || (cmd2 == "ammunition")){options_list.field_color_coding = 1;}
	else if (cmd2 == "type") {options_list.field_color_coding = 2;}
	else if (cmd2 == "slope") {options_list.field_color_coding = 3;}
	cmd_input.command = "show_battlefield";
	}
else if ((cmd1 == "zoom") && (cmd2 == "out") && (cmd3 == ""))
	{
	zoom_battlefield_reset();
	}
else if ((cmd1 == "zoom") && (cmd3 == ""))
	{
	scale = atof (cmd2.c_str());
	zoom_battlefield(scale);
	}
else if (cmd1 == "zoom") 
	{
	scale = atof (cmd2.c_str());
	xl = atof (cmd3.c_str());
	xh = atof (cmd4.c_str());
	yl = atof (cmd5.c_str());
	yh = atof (cmd6.c_str());
	zoom_battlefield(scale, xl, xh, yl, yh);
	}
else if (cmd1 == "crop")
	{
	xl = atof (cmd2.c_str());
	xh = atof (cmd3.c_str());
	yl = atof (cmd4.c_str());
	yh = atof (cmd5.c_str());
	crop_battlefield(xl, xh, yl, yh);
	}
else if (cmd1 == "sb")
	{
	cmd_input.command = "show_battlefield";
	}
else if (cmd1 == "report")
	{
	if (cmd2 == "status")
		{
		cmd_input.command = "report_status";
		}
	else if (cmd2 == "composition")
		{
		cmd_input.command = "report_composition";
		}
	}
else if ((cmd1 == "unit") || (cmd1 == "u"))
	{

	id = -1;
	for (int i=0; i<options_list.num_units;i++)
		{
		if (cmd2 == unit_array[i].get_tag())
			{id = i; break;}
		}
	if (id == -1) {cout << "No unit with this tag found..." << endl; return;}

	cmd_input.unit_id = id;
	cmd_input.command = cmd3;

	if (((cmd3 == "slow") ||(cmd3 == "advance") || (cmd3 == "rush") || (cmd3 == "halt") || (cmd3 == "run") || (cmd3 == "fall_back")) && (cmd4 == ""))
		{
		unit_array[id].give_order(cmd_input.command);
		}
	else if (((cmd3 == "walk") ||(cmd3 == "trot") || (cmd3 == "canter") || (cmd3 == "charge")) && (cmd4 == ""))
		{
		unit_array[id].give_order(cmd_input.command);
		}
	else if (((cmd3 == "slow") ||(cmd3 == "advance") || (cmd3 == "rush") || (cmd3 == "run") || (cmd3 == "halt") || (cmd3 == "fall_back")) && (cmd5 == ""))
		{
		dir = 3.1415926/180.0 * atof (cmd4.c_str());
		unit_array[id].give_order(cmd3, dir);		
		}
	else if (((cmd3 == "walk") ||(cmd3 == "trot") || (cmd3 == "canter") || (cmd3 == "charge")) && (cmd5 == ""))
		{
		dir = 3.1415926/180.0 * atof (cmd4.c_str());
		unit_array[id].give_order(cmd3, dir);		
		}
	else if ((cmd3 == "seek_enemy") || (cmd3 == "hold_fire"))
		{
		unit_array[id].give_order(cmd_input.command);
		}
	else if ((cmd3 == "engage") || (cmd3 == "fire_at"))
		{
		id1 = -1;

		for (int i=0; i<options_list.num_units;i++)
				{
				if (cmd4 == unit_array[i].get_tag()) {id1 = i; break;}
				}
		if (id != -1)
			{unit_array[id].give_order(cmd3, id1);}
		else
			{cout << "No target unit with this tag found..." << endl; return;}
		}
	else if ((cmd3 == "engage_upon")|| (cmd3 == "fire_upon"))
		{
		tgt_x = atof (cmd4.c_str());
		unit_array[id].give_order(cmd_input.command, tgt_x);
		}
	else if ((cmd3 == "guard") || (cmd3 == "surrender"))
		{
		unit_array[id].give_order(cmd_input.command);
		}
	else if ((cmd3 == "slow_to") || (cmd3 == "advance_to") || (cmd3 == "rush_to") || (cmd3 == "hit_and_run") || (cmd3 == "slow_for") || (cmd3 == "advance_for") || (cmd3 == "rush_for")) 
		{
		tgt_x = atof (cmd4.c_str());
		tgt_y = atof (cmd5.c_str());

		unit_array[id].give_order(cmd3, tgt_x, tgt_y);		
		}
	else if (((cmd3 == "walk_to") || (cmd3 == "trot_to") || (cmd3 == "canter_to") ) )
		{
		tgt_x = atof (cmd4.c_str());
		tgt_y = atof (cmd5.c_str());

		unit_array[id].give_order(cmd3, tgt_x, tgt_y);		
		}

	else if (cmd3 == "report")
		{
		if (cmd4 == "orders")
			{unit_array[id].report_orders();}
		else if (cmd4 == "damage")
			{unit_array[id].list_damage();}
		else if (cmd4 == "composition")
			{unit_array[id].list();}
		else if (cmd4 == "position")
			{unit_array[id].report_position();}
		else if (cmd4 == "internal")
			{unit_array[id].report_internal();}
		else
			{
			unit_array[id].list();
			unit_array[id].list_damage();
			unit_array[id].report_orders();
			unit_array[id].report_position();
			}
	
		}
	else 
		{
		cout << "Order to unit not recognized." << endl;
		}

	}
else if ((cmd1 == "formation") || (cmd1 == "f"))
	{
	id = -1;
	
	for (int i=0; i<options_list.num_formations;i++)
		{
		if (cmd2 == formation_array[i].get_name())
			{id = i; break;}
		}
	if (id == -1) {cout << "No formation with this name found..." << endl; return;}

	cmd_input.formation_id = id;
	cmd_input.command = cmd3;

	if (((cmd3 == "advance") || (cmd3 == "slow") || (cmd3 == "rush") || (cmd3 == "halt") || (cmd3 == "fall_back") || (cmd3 == "guard")) && (cmd4 == ""))
		{

		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			unit_array[formation_array[id].get_unit_id(i)].give_order(cmd_input.command);
			}		

		}
	else if (((cmd3 == "walk") ||(cmd3 == "trot") || (cmd3 == "canter") || (cmd3 == "charge")) && (cmd4 == ""))
		{
		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			unit_array[formation_array[id].get_unit_id(i)].give_order(cmd_input.command);
			}
		
		}
	else if (((cmd3 == "advance") || (cmd3 == "slow") || (cmd3 == "rush") || (cmd3 == "run") || (cmd3 == "halt") || (cmd3 == "fall_back")) && (cmd5 == ""))
		{
		dir = 3.1415926/180.0 * atof (cmd4.c_str());
		
		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			unit_array[formation_array[id].get_unit_id(i)].give_order(cmd_input.command, dir);
			}	

		}
	else if (((cmd3 == "walk") || (cmd3 == "trot") || (cmd3 == "canter") || (cmd3 == "charge")) && (cmd5 == ""))
		{
		dir = 3.1415926/180.0 * atof (cmd4.c_str());
		
		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			unit_array[formation_array[id].get_unit_id(i)].give_order(cmd_input.command, dir);
			}	

		}
	else if ((cmd3 == "seek_enemy") || (cmd3 == "hold_fire"))
		{
		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			unit_array[formation_array[id].get_unit_id(i)].give_order(cmd_input.command);
			}		

		}
	else if ((cmd3 == "slow_to") || (cmd3 == "advance_to") || (cmd3 == "rush_to") || (cmd3 == "slow_for") || (cmd3 == "advance_for") || (cmd3 == "rush_for")) 
		{

		tgt_x = atof (cmd4.c_str());
		tgt_y = atof (cmd5.c_str());

		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			unit_array[formation_array[id].get_unit_id(i)].give_order(cmd_input.command, tgt_x, tgt_y);
			}		
		}

	else if ((cmd3 == "engage_upon")|| (cmd3 == "fire_upon"))
		{
		tgt_x = atof (cmd4.c_str());

		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			unit_array[formation_array[id].get_unit_id(i)].give_order(cmd_input.command, tgt_x);
			}
		}
	else if ((cmd3 == "report") && (cmd4 == "damage"))
		{
		int counter_nominal, counter_current, counter_fled;
		counter_nominal = 0;
		counter_current = 0;
		counter_fled = 0;
		for (int i=0; i< formation_array[id].get_num_units(); i++)
			{
			counter_nominal += unit_array[formation_array[id].get_unit_id(i)].get_nominal_num_soldiers();

			if (unit_array[formation_array[id].get_unit_id(i)].get_fled())
				{
				counter_fled += unit_array[formation_array[id].get_unit_id(i)].get_current_num_soldiers();
				}
			else if (unit_array[formation_array[id].get_unit_id(i)].get_inactive() == false)
				{
				counter_current += unit_array[formation_array[id].get_unit_id(i)].get_current_num_soldiers();
				}

			}
		cout << "Formation " << formation_array[id].get_name() << " reporting damage:" << endl;
		cout << "Of " << counter_nominal << " soldiers " << counter_current << " remain, " << counter_fled << " have fled and " << counter_nominal - counter_current - counter_fled << " are wounded or dead." << endl;
		}
	else if (((cmd3 == "plot") && (cmd4 == "positions")) || (cmd3 == "plot_positions"))
		{
		cmd_input.command = "plot_positions";
		}
	else
		{
		cout << "Order to formation not recognized." << endl;
		}

	}
else
	{
	cout << "No valid order recognized." << endl;
	}

}

