#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <stdlib.h>
#include <math.h>

using namespace std;

string command;

double missile_mass;
double missile_v0;
double missile_angle;
double missile_drag;
double missile_kinetic_energy;

double target_alt_difference;
double target_alt_difference_min;
double target_alt_difference_max;
double impact_range;
double impact_kinetic_energy;
double impact_velocity;
double impact_y_max;

double g;

void commandline_parser (int argc, char *argv[]) 
{ 

if (argc < 2)
	{
	cout <<"Please specify a command!" << endl;
	exit(0);
	}
else
	{
	command = argv[1];
	if ((command == "shoot") && (argc == 6))
		{


		missile_mass = atof (argv[2]);
		missile_v0 = atof (argv[3]);
		missile_angle = atof (argv[4]);
		missile_drag = atof (argv[5]);
		cout << "Shooting " << missile_mass << " kg projectile with " << missile_v0 << " m/s  at angle " << missile_angle << " degrees."  << endl;
		cout << "Initial kinetic energy is " << 0.5 * missile_mass * pow(missile_v0,2.0) << " J." << endl;
		}
	else if (command == "shoot")
		{
		cout << "Please specify projectile mass, velocity, angle and drag." << endl;
		exit(0);
		}
	else if ((command == "optimize_angle") && (argc == 6))
		{


		missile_mass = atof (argv[2]);
		missile_v0 = atof (argv[3]);
		missile_drag = atof (argv[4]);
		target_alt_difference = atof (argv[5]);
		//cout << "Shooting " << missile_mass << " kg projectile with " << missile_v0 << " m/s  at angle " << missile_angle << " degrees."  << endl;
		//cout << "Initial kinetic energy is " << 0.5 * missile_mass * pow(missile_v0,2.0) << " J." << endl;
		}
	else if (command == "optimize_angle")
		{
		cout << "Please specify projectile mass, velocity, drag and target altitude difference." << endl;
		exit(0);
		}
	else if ((command == "do_table") && (argc == 7))
		{


		missile_mass = atof (argv[2]);
		missile_v0 = atof (argv[3]);
		missile_drag = atof (argv[4]);
		target_alt_difference_min = atof (argv[5]);
		target_alt_difference_max = atof (argv[6]);
	
		}
	else if (command == "do_table")
		{
		cout << "Please specify projectile mass, velocity, drag and target altitude difference min and max." << endl;
		exit(0);
		}
	else 
		{
		cout << "Something is wrong." << endl;
		exit(0);
		}
	}



}


void trajectory()
{
double x, y, vx, vy, E_kin, dt;
double a_drag, v_tot;


bool impact;

impact = false;

x = 0; 
y = 0;
dt = 0.0001;
impact_y_max = 0.0;

vx = cos(missile_angle) * missile_v0;
vy = sin(missile_angle) * missile_v0;

E_kin = 0.5 * missile_mass * pow(missile_v0,2.0); 
missile_kinetic_energy = E_kin;


while (impact == false)
	{
	v_tot = sqrt(vx*vx + vy*vy);
	a_drag = missile_drag *  pow(v_tot, 2.0) / missile_mass;
	

	vy -= (g * dt + vy/v_tot * a_drag * dt);
	vx -= vx/v_tot * a_drag * dt;

	x += vx * dt;
	y += vy * dt;
	
	if (y > impact_y_max) {impact_y_max = y;}

	//cout << x << " " << y << endl;

	if ((vy < 0) && (y < target_alt_difference))
		{
		impact = true;
		}
	}

impact_range = x;
impact_velocity = sqrt(vx * vx + vy * vy);
impact_kinetic_energy = 0.5 * missile_mass * impact_velocity * impact_velocity;

if (command == "shoot")
	{
	cout << "Impact after " << impact_range << " m with " << impact_velocity << " m/s." << endl;
	cout << "Highest altitude is " << impact_y_max << endl;
	cout << "Final kinetic energy is " << impact_kinetic_energy << " J." << endl;
	}
}

void find_angle()
{

bool fit_converged;
double ang_step, range_last;

fit_converged = false;


if (target_alt_difference < 0.0)
	{
	missile_angle = 1.0 * 3.1415926535/180.0;
	ang_step = 0.001;
	}
else
	{
	missile_angle = 89.0 * 3.1415926535/180.0;
	ang_step = -0.001;
	}
	
trajectory();

range_last = impact_range;

while (fit_converged == false)
	{
	missile_angle += ang_step;

	//cout << missile_angle * 180.0/3.1415926535 << " " << ang_step * 180/3.1415926535 << " " << impact_range << endl;

	trajectory();
	
	if (impact_range < range_last)
		{	
		//cout << missile_angle * 180/3.1415926535 << " " << impact_range << " " << range_last << endl;
		ang_step *=-0.5;
		}
	range_last = impact_range;

	if (abs(ang_step) < 0.000001) {fit_converged = true;} 
	}

if (impact_y_max < target_alt_difference)
	{
	cout << "Target is too high to be reached." << endl;
	}
else
	{
	if (command == "optimize_angle")
		{
		cout << "Optimum angle is " << missile_angle * 180/3.1415926535 << " deg for a range of " << impact_range << " m." << endl;
		cout << "Kinetic energy at impact is  " << impact_kinetic_energy << " J." << endl;
		}
	}

}

void do_table()
{

target_alt_difference = target_alt_difference_min;

while (target_alt_difference < target_alt_difference_max)
	{

	find_angle();

	cout << target_alt_difference << " " << impact_range << " " << impact_kinetic_energy << endl;

	target_alt_difference += 5.0;
	}

} 


int main (int argc, char *argv[] ) 
{

commandline_parser(argc, argv);
missile_angle *= 3.1415926535/180.0;
g = 9.81;

if (command == "shoot")
	{
	target_alt_difference = 0.0;
	trajectory();
	}
else if (command == "optimize_angle")
	{
	find_angle();
	}
else if (command == "do_table")
	{
	do_table();
	}

}
